/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.IOException;

public class BackupDataInput {
    long mBackupReader;
    private EntityHeader mHeader = new EntityHeader();
    private boolean mHeaderReady;

    @SystemApi
    public BackupDataInput(FileDescriptor fd) {
        if (fd == null) {
            throw new NullPointerException();
        }
        this.mBackupReader = BackupDataInput.ctor(fd);
        if (this.mBackupReader == 0L) {
            throw new RuntimeException("Native initialization failed with fd=" + fd);
        }
    }

    protected void finalize() throws Throwable {
        try {
            BackupDataInput.dtor(this.mBackupReader);
        }
        finally {
            super.finalize();
        }
    }

    public boolean readNextHeader() throws IOException {
        int result = this.readNextHeader_native(this.mBackupReader, this.mHeader);
        if (result == 0) {
            this.mHeaderReady = true;
            return true;
        }
        if (result > 0) {
            this.mHeaderReady = false;
            return false;
        }
        this.mHeaderReady = false;
        throw new IOException("failed: 0x" + Integer.toHexString(result));
    }

    public String getKey() {
        if (this.mHeaderReady) {
            return this.mHeader.key;
        }
        throw new IllegalStateException("Entity header not read");
    }

    public int getDataSize() {
        if (this.mHeaderReady) {
            return this.mHeader.dataSize;
        }
        throw new IllegalStateException("Entity header not read");
    }

    public int readEntityData(byte[] data, int offset, int size) throws IOException {
        if (this.mHeaderReady) {
            int result = this.readEntityData_native(this.mBackupReader, data, offset, size);
            if (result >= 0) {
                return result;
            }
            throw new IOException("result=0x" + Integer.toHexString(result));
        }
        throw new IllegalStateException("Entity header not read");
    }

    public void skipEntityData() throws IOException {
        if (!this.mHeaderReady) {
            throw new IllegalStateException("Entity header not read");
        }
        this.skipEntityData_native(this.mBackupReader);
    }

    private static long ctor(FileDescriptor fileDescriptor) {
        return OverrideMethod.invokeL("android.app.backup.BackupDataInput#ctor(Ljava/io/FileDescriptor;)J", true, null);
    }

    private static void dtor(long l) {
        OverrideMethod.invokeV("android.app.backup.BackupDataInput#dtor(J)V", true, null);
    }

    private int readNextHeader_native(long l, EntityHeader entityHeader) {
        return OverrideMethod.invokeI("android.app.backup.BackupDataInput#readNextHeader_native(JLandroid/app/backup/BackupDataInput$EntityHeader;)I", true, this);
    }

    private int readEntityData_native(long l, byte[] byArray, int n, int n2) {
        return OverrideMethod.invokeI("android.app.backup.BackupDataInput#readEntityData_native(J[BII)I", true, this);
    }

    private int skipEntityData_native(long l) {
        return OverrideMethod.invokeI("android.app.backup.BackupDataInput#skipEntityData_native(J)I", true, this);
    }

    private static class EntityHeader {
        @UnsupportedAppUsage
        String key;
        @UnsupportedAppUsage
        int dataSize;

        private EntityHeader() {
        }
    }
}

