/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SystemApi;
import android.app.AutomaticZenRule;
import android.app.INotificationManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.UserHandle;
import android.service.notification.Condition;
import android.service.notification.StatusBarNotification;
import android.service.notification.ZenModeConfig;
import android.util.Log;
import android.util.proto.ProtoOutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NotificationManager {
    private static String TAG = "NotificationManager";
    private static boolean localLOGV = false;
    public static final String ACTION_APP_BLOCK_STATE_CHANGED = "android.app.action.APP_BLOCK_STATE_CHANGED";
    public static final String ACTION_NOTIFICATION_CHANNEL_BLOCK_STATE_CHANGED = "android.app.action.NOTIFICATION_CHANNEL_BLOCK_STATE_CHANGED";
    public static final String EXTRA_NOTIFICATION_CHANNEL_ID = "android.app.extra.NOTIFICATION_CHANNEL_ID";
    public static final String EXTRA_NOTIFICATION_CHANNEL_GROUP_ID = "android.app.extra.NOTIFICATION_CHANNEL_GROUP_ID";
    public static final String EXTRA_BLOCKED_STATE = "android.app.extra.BLOCKED_STATE";
    public static final String ACTION_NOTIFICATION_CHANNEL_GROUP_BLOCK_STATE_CHANGED = "android.app.action.NOTIFICATION_CHANNEL_GROUP_BLOCK_STATE_CHANGED";
    public static final String ACTION_AUTOMATIC_ZEN_RULE_STATUS_CHANGED = "android.app.action.AUTOMATIC_ZEN_RULE_STATUS_CHANGED";
    public static final String EXTRA_AUTOMATIC_ZEN_RULE_STATUS = "android.app.extra.AUTOMATIC_ZEN_RULE_STATUS";
    public static final String EXTRA_AUTOMATIC_ZEN_RULE_ID = "android.app.extra.AUTOMATIC_ZEN_RULE_ID";
    public static final int AUTOMATIC_RULE_STATUS_UNKNOWN = -1;
    public static final int AUTOMATIC_RULE_STATUS_ENABLED = 1;
    public static final int AUTOMATIC_RULE_STATUS_DISABLED = 2;
    public static final int AUTOMATIC_RULE_STATUS_REMOVED = 3;
    public static final String ACTION_EFFECTS_SUPPRESSOR_CHANGED = "android.os.action.ACTION_EFFECTS_SUPPRESSOR_CHANGED";
    public static final String ACTION_NOTIFICATION_POLICY_ACCESS_GRANTED_CHANGED = "android.app.action.NOTIFICATION_POLICY_ACCESS_GRANTED_CHANGED";
    public static final String ACTION_NOTIFICATION_POLICY_CHANGED = "android.app.action.NOTIFICATION_POLICY_CHANGED";
    public static final String ACTION_INTERRUPTION_FILTER_CHANGED = "android.app.action.INTERRUPTION_FILTER_CHANGED";
    public static final String ACTION_INTERRUPTION_FILTER_CHANGED_INTERNAL = "android.app.action.INTERRUPTION_FILTER_CHANGED_INTERNAL";
    public static final int INTERRUPTION_FILTER_ALL = 1;
    public static final int INTERRUPTION_FILTER_PRIORITY = 2;
    public static final int INTERRUPTION_FILTER_NONE = 3;
    public static final int INTERRUPTION_FILTER_ALARMS = 4;
    public static final int INTERRUPTION_FILTER_UNKNOWN = 0;
    public static final String ACTION_AUTOMATIC_ZEN_RULE = "android.app.action.AUTOMATIC_ZEN_RULE";
    public static final String EXTRA_AUTOMATIC_RULE_ID = "android.app.extra.AUTOMATIC_RULE_ID";
    public static final String META_DATA_AUTOMATIC_RULE_TYPE = "android.service.zen.automatic.ruleType";
    public static final String META_DATA_RULE_INSTANCE_LIMIT = "android.service.zen.automatic.ruleInstanceLimit";
    public static final int VISIBILITY_NO_OVERRIDE = -1000;
    public static final int IMPORTANCE_UNSPECIFIED = -1000;
    public static final int IMPORTANCE_NONE = 0;
    public static final int IMPORTANCE_MIN = 1;
    public static final int IMPORTANCE_LOW = 2;
    public static final int IMPORTANCE_DEFAULT = 3;
    public static final int IMPORTANCE_HIGH = 4;
    public static final int IMPORTANCE_MAX = 5;
    public static final int BUBBLE_PREFERENCE_NONE = 0;
    public static final int BUBBLE_PREFERENCE_ALL = 1;
    public static final int BUBBLE_PREFERENCE_SELECTED = 2;
    @UnsupportedAppUsage
    private static INotificationManager sService;
    private Context mContext;

    @UnsupportedAppUsage
    public static INotificationManager getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("notification");
        sService = INotificationManager.Stub.asInterface(b);
        return sService;
    }

    @UnsupportedAppUsage
    NotificationManager(Context context, Handler handler) {
        this.mContext = context;
    }

    @UnsupportedAppUsage
    public static NotificationManager from(Context context) {
        return (NotificationManager)context.getSystemService("notification");
    }

    public void notify(int id2, Notification notification) {
        this.notify(null, id2, notification);
    }

    public void notify(String tag, int id2, Notification notification) {
        this.notifyAsUser(tag, id2, notification, this.mContext.getUser());
    }

    public void notifyAsPackage(String targetPackage, String tag, int id2, Notification notification) {
        INotificationManager service = NotificationManager.getService();
        String sender = this.mContext.getPackageName();
        try {
            if (localLOGV) {
                Log.v(TAG, sender + ": notify(" + id2 + ", " + notification + ")");
            }
            service.enqueueNotificationWithTag(targetPackage, sender, tag, id2, this.fixNotification(notification), this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void notifyAsUser(String tag, int id2, Notification notification, UserHandle user) {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        try {
            if (localLOGV) {
                Log.v(TAG, pkg + ": notify(" + id2 + ", " + notification + ")");
            }
            service.enqueueNotificationWithTag(pkg, this.mContext.getOpPackageName(), tag, id2, this.fixNotification(notification), user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private Notification fixNotification(Notification notification) {
        String pkg = this.mContext.getPackageName();
        Notification.addFieldsFromContext(this.mContext, notification);
        if (notification.sound != null) {
            notification.sound = notification.sound.getCanonicalUri();
            if (StrictMode.vmFileUriExposureEnabled()) {
                notification.sound.checkFileUriExposed("Notification.sound");
            }
        }
        this.fixLegacySmallIcon(notification, pkg);
        if (this.mContext.getApplicationInfo().targetSdkVersion > 22 && notification.getSmallIcon() == null) {
            throw new IllegalArgumentException("Invalid notification (no valid small icon): " + notification);
        }
        notification.reduceImageSizes(this.mContext);
        return Notification.Builder.maybeCloneStrippedForDelivery(notification);
    }

    private void fixLegacySmallIcon(Notification n, String pkg) {
        if (n.getSmallIcon() == null && n.icon != 0) {
            n.setSmallIcon(Icon.createWithResource(pkg, n.icon));
        }
    }

    public void cancel(int id2) {
        this.cancel(null, id2);
    }

    public void cancel(String tag, int id2) {
        this.cancelAsUser(tag, id2, this.mContext.getUser());
    }

    public void cancelAsPackage(String targetPackage, String tag, int id2) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.cancelNotificationWithTag(targetPackage, this.mContext.getOpPackageName(), tag, id2, this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void cancelAsUser(String tag, int id2, UserHandle user) {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        if (localLOGV) {
            Log.v(TAG, pkg + ": cancel(" + id2 + ")");
        }
        try {
            service.cancelNotificationWithTag(pkg, this.mContext.getOpPackageName(), tag, id2, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void cancelAll() {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        if (localLOGV) {
            Log.v(TAG, pkg + ": cancelAll()");
        }
        try {
            service.cancelAllNotifications(pkg, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setNotificationDelegate(String delegate) {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        if (localLOGV) {
            Log.v(TAG, pkg + ": cancelAll()");
        }
        try {
            service.setNotificationDelegate(pkg, delegate);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String getNotificationDelegate() {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        try {
            return service.getNotificationDelegate(pkg);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean canNotifyAsPackage(String pkg) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.canNotifyAsPackage(this.mContext.getPackageName(), pkg, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void createNotificationChannelGroup(NotificationChannelGroup group) {
        this.createNotificationChannelGroups(Arrays.asList(group));
    }

    public void createNotificationChannelGroups(List<NotificationChannelGroup> groups) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.createNotificationChannelGroups(this.mContext.getPackageName(), new ParceledListSlice<NotificationChannelGroup>(groups));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void createNotificationChannel(NotificationChannel channel) {
        this.createNotificationChannels(Arrays.asList(channel));
    }

    public void createNotificationChannels(List<NotificationChannel> channels) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.createNotificationChannels(this.mContext.getPackageName(), new ParceledListSlice<NotificationChannel>(channels));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public NotificationChannel getNotificationChannel(String channelId) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getNotificationChannel(this.mContext.getOpPackageName(), this.mContext.getUserId(), this.mContext.getPackageName(), channelId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public NotificationChannel getNotificationChannel(String channelId, String conversationId) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getConversationNotificationChannel(this.mContext.getOpPackageName(), this.mContext.getUserId(), this.mContext.getPackageName(), channelId, true, conversationId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<NotificationChannel> getNotificationChannels() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getNotificationChannels(this.mContext.getOpPackageName(), this.mContext.getPackageName(), this.mContext.getUserId()).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void deleteNotificationChannel(String channelId) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.deleteNotificationChannel(this.mContext.getPackageName(), channelId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public NotificationChannelGroup getNotificationChannelGroup(String channelGroupId) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getNotificationChannelGroup(this.mContext.getPackageName(), channelGroupId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<NotificationChannelGroup> getNotificationChannelGroups() {
        INotificationManager service = NotificationManager.getService();
        try {
            ParceledListSlice parceledList = service.getNotificationChannelGroups(this.mContext.getPackageName());
            if (parceledList != null) {
                return parceledList.getList();
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return new ArrayList<NotificationChannelGroup>();
    }

    public void deleteNotificationChannelGroup(String groupId) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.deleteNotificationChannelGroup(this.mContext.getPackageName(), groupId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public ComponentName getEffectsSuppressor() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getEffectsSuppressor();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean matchesCallFilter(Bundle extras) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.matchesCallFilter(extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isSystemConditionProviderEnabled(String path) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.isSystemConditionProviderEnabled(path);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void setZenMode(int mode, Uri conditionId, String reason) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.setZenMode(mode, conditionId, reason);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getZenMode() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getZenMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public ZenModeConfig getZenModeConfig() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getZenModeConfig();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Policy getConsolidatedNotificationPolicy() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getConsolidatedNotificationPolicy();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getRuleInstanceCount(ComponentName owner) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getRuleInstanceCount(owner);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Map<String, AutomaticZenRule> getAutomaticZenRules() {
        INotificationManager service = NotificationManager.getService();
        try {
            List<ZenModeConfig.ZenRule> rules = service.getZenRules();
            HashMap<String, AutomaticZenRule> ruleMap = new HashMap<String, AutomaticZenRule>();
            for (ZenModeConfig.ZenRule rule : rules) {
                ruleMap.put(rule.id, new AutomaticZenRule(rule.name, rule.component, rule.configurationActivity, rule.conditionId, rule.zenPolicy, NotificationManager.zenModeToInterruptionFilter(rule.zenMode), rule.enabled, rule.creationTime));
            }
            return ruleMap;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public AutomaticZenRule getAutomaticZenRule(String id2) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getAutomaticZenRule(id2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String addAutomaticZenRule(AutomaticZenRule automaticZenRule) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.addAutomaticZenRule(automaticZenRule);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean updateAutomaticZenRule(String id2, AutomaticZenRule automaticZenRule) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.updateAutomaticZenRule(id2, automaticZenRule);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setAutomaticZenRuleState(String id2, Condition condition) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.setAutomaticZenRuleState(id2, condition);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean removeAutomaticZenRule(String id2) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.removeAutomaticZenRule(id2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean removeAutomaticZenRules(String packageName) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.removeAutomaticZenRules(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getImportance() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getPackageImportance(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean areNotificationsEnabled() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.areNotificationsEnabled(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean areBubblesAllowed() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.areBubblesAllowed(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void silenceNotificationSound() {
        INotificationManager service = NotificationManager.getService();
        try {
            service.silenceNotificationSound();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean areNotificationsPaused() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.isPackagePaused(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isNotificationPolicyAccessGranted() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.isNotificationPolicyAccessGranted(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isNotificationListenerAccessGranted(ComponentName listener) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.isNotificationListenerAccessGranted(listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public boolean isNotificationAssistantAccessGranted(ComponentName assistant) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.isNotificationAssistantAccessGranted(assistant);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean shouldHideSilentStatusBarIcons() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.shouldHideSilentStatusIcons(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public List<String> getAllowedAssistantAdjustments() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getAllowedAssistantAdjustments(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void allowAssistantAdjustment(String capability) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.allowAssistantAdjustment(capability);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void disallowAssistantAdjustment(String capability) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.disallowAssistantAdjustment(capability);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isNotificationPolicyAccessGrantedForPackage(String pkg) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.isNotificationPolicyAccessGrantedForPackage(pkg);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<String> getEnabledNotificationListenerPackages() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getEnabledNotificationListenerPackages();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Policy getNotificationPolicy() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getNotificationPolicy(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setNotificationPolicy(Policy policy) {
        NotificationManager.checkRequired("policy", policy);
        INotificationManager service = NotificationManager.getService();
        try {
            service.setNotificationPolicy(this.mContext.getOpPackageName(), policy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setNotificationPolicyAccessGranted(String pkg, boolean granted) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.setNotificationPolicyAccessGranted(pkg, granted);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setNotificationListenerAccessGranted(ComponentName listener, boolean granted) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.setNotificationListenerAccessGranted(listener, granted);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setNotificationListenerAccessGrantedForUser(ComponentName listener, int userId, boolean granted) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.setNotificationListenerAccessGrantedForUser(listener, userId, granted);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void setNotificationAssistantAccessGranted(ComponentName assistant, boolean granted) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.setNotificationAssistantAccessGranted(assistant, granted);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<ComponentName> getEnabledNotificationListeners(int userId) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getEnabledNotificationListeners(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public ComponentName getAllowedNotificationAssistant() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getAllowedNotificationAssistant();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static void checkRequired(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(name + " is required");
        }
    }

    public StatusBarNotification[] getActiveNotifications() {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        try {
            ParceledListSlice parceledList = service.getAppActiveNotifications(pkg, this.mContext.getUserId());
            if (parceledList != null) {
                List list = parceledList.getList();
                return list.toArray(new StatusBarNotification[list.size()]);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return new StatusBarNotification[0];
    }

    public int getCurrentInterruptionFilter() {
        INotificationManager service = NotificationManager.getService();
        try {
            return NotificationManager.zenModeToInterruptionFilter(service.getZenMode());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setInterruptionFilter(int interruptionFilter) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.setInterruptionFilter(this.mContext.getOpPackageName(), interruptionFilter);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static int zenModeToInterruptionFilter(int zen) {
        switch (zen) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 2: {
                return 3;
            }
        }
        return 0;
    }

    public static int zenModeFromInterruptionFilter(int interruptionFilter, int defValue) {
        switch (interruptionFilter) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 3;
            }
            case 3: {
                return 2;
            }
        }
        return defValue;
    }

    public static class Policy
    implements Parcelable {
        public static final int PRIORITY_CATEGORY_REMINDERS = 1;
        public static final int PRIORITY_CATEGORY_EVENTS = 2;
        public static final int PRIORITY_CATEGORY_MESSAGES = 4;
        public static final int PRIORITY_CATEGORY_CALLS = 8;
        public static final int PRIORITY_CATEGORY_REPEAT_CALLERS = 16;
        public static final int PRIORITY_CATEGORY_ALARMS = 32;
        public static final int PRIORITY_CATEGORY_MEDIA = 64;
        public static final int PRIORITY_CATEGORY_SYSTEM = 128;
        public static final int PRIORITY_CATEGORY_CONVERSATIONS = 256;
        public static final int[] ALL_PRIORITY_CATEGORIES = new int[]{32, 64, 128, 1, 2, 4, 8, 16, 256};
        public static final int PRIORITY_SENDERS_ANY = 0;
        public static final int PRIORITY_SENDERS_CONTACTS = 1;
        public static final int PRIORITY_SENDERS_STARRED = 2;
        public static final int CONVERSATION_SENDERS_ANYONE = 1;
        public static final int CONVERSATION_SENDERS_IMPORTANT = 2;
        public static final int CONVERSATION_SENDERS_NONE = 3;
        public final int priorityCategories;
        public final int priorityCallSenders;
        public final int priorityMessageSenders;
        public final int priorityConversationSenders;
        public static final int CONVERSATION_SENDERS_UNSET = -1;
        public static final int SUPPRESSED_EFFECTS_UNSET = -1;
        @Deprecated
        public static final int SUPPRESSED_EFFECT_SCREEN_OFF = 1;
        @Deprecated
        public static final int SUPPRESSED_EFFECT_SCREEN_ON = 2;
        public static final int SUPPRESSED_EFFECT_FULL_SCREEN_INTENT = 4;
        public static final int SUPPRESSED_EFFECT_LIGHTS = 8;
        public static final int SUPPRESSED_EFFECT_PEEK = 16;
        public static final int SUPPRESSED_EFFECT_STATUS_BAR = 32;
        public static final int SUPPRESSED_EFFECT_BADGE = 64;
        public static final int SUPPRESSED_EFFECT_AMBIENT = 128;
        public static final int SUPPRESSED_EFFECT_NOTIFICATION_LIST = 256;
        private static final int[] ALL_SUPPRESSED_EFFECTS = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256};
        public final int suppressedVisualEffects;
        public static final int STATE_CHANNELS_BYPASSING_DND = 1;
        public static final int STATE_UNSET = -1;
        public final int state;
        public static final Parcelable.Creator<Policy> CREATOR = new Parcelable.Creator<Policy>(){

            @Override
            public Policy createFromParcel(Parcel in) {
                return new Policy(in);
            }

            public Policy[] newArray(int size) {
                return new Policy[size];
            }
        };

        public Policy(int priorityCategories, int priorityCallSenders, int priorityMessageSenders) {
            this(priorityCategories, priorityCallSenders, priorityMessageSenders, -1, -1, -1);
        }

        public Policy(int priorityCategories, int priorityCallSenders, int priorityMessageSenders, int suppressedVisualEffects) {
            this(priorityCategories, priorityCallSenders, priorityMessageSenders, suppressedVisualEffects, -1, -1);
        }

        public Policy(int priorityCategories, int priorityCallSenders, int priorityMessageSenders, int suppressedVisualEffects, int priorityConversationSenders) {
            this(priorityCategories, priorityCallSenders, priorityMessageSenders, suppressedVisualEffects, -1, priorityConversationSenders);
        }

        public Policy(int priorityCategories, int priorityCallSenders, int priorityMessageSenders, int suppressedVisualEffects, int state, int priorityConversationSenders) {
            this.priorityCategories = priorityCategories;
            this.priorityCallSenders = priorityCallSenders;
            this.priorityMessageSenders = priorityMessageSenders;
            this.suppressedVisualEffects = suppressedVisualEffects;
            this.state = state;
            this.priorityConversationSenders = priorityConversationSenders;
        }

        public Policy(Parcel source) {
            this(source.readInt(), source.readInt(), source.readInt(), source.readInt(), source.readInt(), source.readInt());
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.priorityCategories);
            dest.writeInt(this.priorityCallSenders);
            dest.writeInt(this.priorityMessageSenders);
            dest.writeInt(this.suppressedVisualEffects);
            dest.writeInt(this.state);
            dest.writeInt(this.priorityConversationSenders);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public int hashCode() {
            return Objects.hash(this.priorityCategories, this.priorityCallSenders, this.priorityMessageSenders, this.suppressedVisualEffects, this.state, this.priorityConversationSenders);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Policy)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Policy other = (Policy)o;
            return other.priorityCategories == this.priorityCategories && other.priorityCallSenders == this.priorityCallSenders && other.priorityMessageSenders == this.priorityMessageSenders && this.suppressedVisualEffectsEqual(this.suppressedVisualEffects, other.suppressedVisualEffects) && other.state == this.state && other.priorityConversationSenders == this.priorityConversationSenders;
        }

        private boolean suppressedVisualEffectsEqual(int suppressedEffects, int otherSuppressedVisualEffects) {
            int otherWithoutOldEffects;
            int thisWithoutOldEffects;
            int currSuppressedEffects;
            if (suppressedEffects == otherSuppressedVisualEffects) {
                return true;
            }
            if ((suppressedEffects & 2) != 0) {
                suppressedEffects |= 0x10;
            }
            if ((suppressedEffects & 1) != 0) {
                suppressedEffects |= 4;
                suppressedEffects |= 8;
                suppressedEffects |= 0x80;
            }
            if ((otherSuppressedVisualEffects & 2) != 0) {
                otherSuppressedVisualEffects |= 0x10;
            }
            if ((otherSuppressedVisualEffects & 1) != 0) {
                otherSuppressedVisualEffects |= 4;
                otherSuppressedVisualEffects |= 8;
                otherSuppressedVisualEffects |= 0x80;
            }
            if ((suppressedEffects & 2) != (otherSuppressedVisualEffects & 2)) {
                int n = currSuppressedEffects = (suppressedEffects & 2) != 0 ? otherSuppressedVisualEffects : suppressedEffects;
                if ((currSuppressedEffects & 0x10) == 0) {
                    return false;
                }
            }
            if ((suppressedEffects & 1) != (otherSuppressedVisualEffects & 1)) {
                int n = currSuppressedEffects = (suppressedEffects & 1) != 0 ? otherSuppressedVisualEffects : suppressedEffects;
                if ((currSuppressedEffects & 4) == 0 || (currSuppressedEffects & 8) == 0 || (currSuppressedEffects & 0x80) == 0) {
                    return false;
                }
            }
            return (thisWithoutOldEffects = suppressedEffects & 0xFFFFFFFD & 0xFFFFFFFE) == (otherWithoutOldEffects = otherSuppressedVisualEffects & 0xFFFFFFFD & 0xFFFFFFFE);
        }

        public String toString() {
            return "NotificationManager.Policy[priorityCategories=" + Policy.priorityCategoriesToString(this.priorityCategories) + ",priorityCallSenders=" + Policy.prioritySendersToString(this.priorityCallSenders) + ",priorityMessageSenders=" + Policy.prioritySendersToString(this.priorityMessageSenders) + ",priorityConvSenders=" + Policy.conversationSendersToString(this.priorityConversationSenders) + ",suppressedVisualEffects=" + Policy.suppressedEffectsToString(this.suppressedVisualEffects) + ",areChannelsBypassingDnd=" + ((this.state & 1) != 0 ? "true" : "false") + "]";
        }

        public void dumpDebug(ProtoOutputStream proto, long fieldId) {
            long pToken = proto.start(fieldId);
            Policy.bitwiseToProtoEnum(proto, 2259152797697L, this.priorityCategories);
            proto.write(1159641169922L, this.priorityCallSenders);
            proto.write(1159641169923L, this.priorityMessageSenders);
            Policy.bitwiseToProtoEnum(proto, 2259152797700L, this.suppressedVisualEffects);
            proto.end(pToken);
        }

        private static void bitwiseToProtoEnum(ProtoOutputStream proto, long fieldId, int data) {
            int i = 1;
            while (data > 0) {
                if ((data & 1) == 1) {
                    proto.write(fieldId, i);
                }
                ++i;
                data >>>= 1;
            }
        }

        public static int getAllSuppressedVisualEffects() {
            int effects = 0;
            for (int i = 0; i < ALL_SUPPRESSED_EFFECTS.length; ++i) {
                effects |= ALL_SUPPRESSED_EFFECTS[i];
            }
            return effects;
        }

        public static boolean areAllVisualEffectsSuppressed(int effects) {
            for (int i = 0; i < ALL_SUPPRESSED_EFFECTS.length; ++i) {
                int effect = ALL_SUPPRESSED_EFFECTS[i];
                if ((effects & effect) != 0) continue;
                return false;
            }
            return true;
        }

        private static int toggleEffects(int currentEffects, int[] effects, boolean suppress) {
            for (int i = 0; i < effects.length; ++i) {
                int effect = effects[i];
                if (suppress) {
                    currentEffects |= effect;
                    continue;
                }
                currentEffects &= ~effect;
            }
            return currentEffects;
        }

        public static String suppressedEffectsToString(int effects) {
            if (effects <= 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ALL_SUPPRESSED_EFFECTS.length; ++i) {
                int effect = ALL_SUPPRESSED_EFFECTS[i];
                if ((effects & effect) != 0) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(Policy.effectToString(effect));
                }
                effects &= ~effect;
            }
            if (effects != 0) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append("UNKNOWN_").append(effects);
            }
            return sb.toString();
        }

        public static String priorityCategoriesToString(int priorityCategories) {
            if (priorityCategories == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ALL_PRIORITY_CATEGORIES.length; ++i) {
                int priorityCategory = ALL_PRIORITY_CATEGORIES[i];
                if ((priorityCategories & priorityCategory) != 0) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(Policy.priorityCategoryToString(priorityCategory));
                }
                priorityCategories &= ~priorityCategory;
            }
            if (priorityCategories != 0) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append("PRIORITY_CATEGORY_UNKNOWN_").append(priorityCategories);
            }
            return sb.toString();
        }

        private static String effectToString(int effect) {
            switch (effect) {
                case 4: {
                    return "SUPPRESSED_EFFECT_FULL_SCREEN_INTENT";
                }
                case 8: {
                    return "SUPPRESSED_EFFECT_LIGHTS";
                }
                case 16: {
                    return "SUPPRESSED_EFFECT_PEEK";
                }
                case 32: {
                    return "SUPPRESSED_EFFECT_STATUS_BAR";
                }
                case 64: {
                    return "SUPPRESSED_EFFECT_BADGE";
                }
                case 128: {
                    return "SUPPRESSED_EFFECT_AMBIENT";
                }
                case 256: {
                    return "SUPPRESSED_EFFECT_NOTIFICATION_LIST";
                }
                case 1: {
                    return "SUPPRESSED_EFFECT_SCREEN_OFF";
                }
                case 2: {
                    return "SUPPRESSED_EFFECT_SCREEN_ON";
                }
                case -1: {
                    return "SUPPRESSED_EFFECTS_UNSET";
                }
            }
            return "UNKNOWN_" + effect;
        }

        private static String priorityCategoryToString(int priorityCategory) {
            switch (priorityCategory) {
                case 1: {
                    return "PRIORITY_CATEGORY_REMINDERS";
                }
                case 2: {
                    return "PRIORITY_CATEGORY_EVENTS";
                }
                case 4: {
                    return "PRIORITY_CATEGORY_MESSAGES";
                }
                case 8: {
                    return "PRIORITY_CATEGORY_CALLS";
                }
                case 16: {
                    return "PRIORITY_CATEGORY_REPEAT_CALLERS";
                }
                case 32: {
                    return "PRIORITY_CATEGORY_ALARMS";
                }
                case 64: {
                    return "PRIORITY_CATEGORY_MEDIA";
                }
                case 128: {
                    return "PRIORITY_CATEGORY_SYSTEM";
                }
                case 256: {
                    return "PRIORITY_CATEGORY_CONVERSATIONS";
                }
            }
            return "PRIORITY_CATEGORY_UNKNOWN_" + priorityCategory;
        }

        public static String prioritySendersToString(int prioritySenders) {
            switch (prioritySenders) {
                case 0: {
                    return "PRIORITY_SENDERS_ANY";
                }
                case 1: {
                    return "PRIORITY_SENDERS_CONTACTS";
                }
                case 2: {
                    return "PRIORITY_SENDERS_STARRED";
                }
            }
            return "PRIORITY_SENDERS_UNKNOWN_" + prioritySenders;
        }

        public static String conversationSendersToString(int priorityConversationSenders) {
            switch (priorityConversationSenders) {
                case 1: {
                    return "anyone";
                }
                case 2: {
                    return "important";
                }
                case 3: {
                    return "none";
                }
                case -1: {
                    return "unset";
                }
            }
            return "invalidConversationType{" + priorityConversationSenders + "}";
        }

        public boolean allowAlarms() {
            return (this.priorityCategories & 0x20) != 0;
        }

        public boolean allowMedia() {
            return (this.priorityCategories & 0x40) != 0;
        }

        public boolean allowSystem() {
            return (this.priorityCategories & 0x80) != 0;
        }

        public boolean allowRepeatCallers() {
            return (this.priorityCategories & 0x10) != 0;
        }

        public boolean allowCalls() {
            return (this.priorityCategories & 8) != 0;
        }

        public boolean allowConversations() {
            return (this.priorityCategories & 0x100) != 0;
        }

        public boolean allowMessages() {
            return (this.priorityCategories & 4) != 0;
        }

        public boolean allowEvents() {
            return (this.priorityCategories & 2) != 0;
        }

        public boolean allowReminders() {
            return (this.priorityCategories & 1) != 0;
        }

        public int allowCallsFrom() {
            return this.priorityCallSenders;
        }

        public int allowMessagesFrom() {
            return this.priorityMessageSenders;
        }

        public int allowConversationsFrom() {
            return this.priorityConversationSenders;
        }

        public boolean showFullScreenIntents() {
            return (this.suppressedVisualEffects & 4) == 0;
        }

        public boolean showLights() {
            return (this.suppressedVisualEffects & 8) == 0;
        }

        public boolean showPeeking() {
            return (this.suppressedVisualEffects & 0x10) == 0;
        }

        public boolean showStatusBarIcons() {
            return (this.suppressedVisualEffects & 0x20) == 0;
        }

        public boolean showAmbient() {
            return (this.suppressedVisualEffects & 0x80) == 0;
        }

        public boolean showBadges() {
            return (this.suppressedVisualEffects & 0x40) == 0;
        }

        public boolean showInNotificationList() {
            return (this.suppressedVisualEffects & 0x100) == 0;
        }

        public Policy copy() {
            Parcel parcel = Parcel.obtain();
            try {
                this.writeToParcel(parcel, 0);
                parcel.setDataPosition(0);
                Policy policy = new Policy(parcel);
                return policy;
            }
            finally {
                parcel.recycle();
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ConversationSenders {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface PrioritySenders {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Importance {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InterruptionFilter {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AutomaticZenRuleStatus {
    }
}

