/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITransientNotification
extends IInterface {
    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/app/ITransientNotification.aidl:22:1:22:25")
    public void show(IBinder var1) throws RemoteException;

    public void hide() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITransientNotification {
        private static final String DESCRIPTOR = "android.app.ITransientNotification";
        static final int TRANSACTION_show = 1;
        static final int TRANSACTION_hide = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITransientNotification asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITransientNotification) {
                return (ITransientNotification)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "show";
                }
                case 2: {
                    return "hide";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    this.show(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.hide();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ITransientNotification impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ITransientNotification getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ITransientNotification {
            private IBinder mRemote;
            public static ITransientNotification sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void show(IBinder windowToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().show(windowToken);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void hide() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().hide();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITransientNotification {
        @Override
        public void show(IBinder windowToken) throws RemoteException {
        }

        @Override
        public void hide() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

