/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions.scheme;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.StatisticsDevKitUtil;
import com.intellij.internal.statistic.actions.scheme.EditEventsTestSchemePanel;
import com.intellij.internal.statistic.eventLog.whitelist.LocalWhitelistGroup;
import com.intellij.internal.statistic.eventLog.whitelist.WhitelistTestGroupStorage;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.TextIcon;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/statistic/actions/scheme/EditEventsTestSchemeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "recorderId", "", "(Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "loadEventsScheme", "Lcom/intellij/internal/statistic/actions/scheme/EditEventsTestSchemeAction$EventsTestScheme;", "project", "Lcom/intellij/openapi/project/Project;", "testSchemeStorage", "Lcom/intellij/internal/statistic/eventLog/whitelist/WhitelistTestGroupStorage;", "update", "Companion", "EventsTestScheme", "intellij.platform.statistics.devkit"})
public final class EditEventsTestSchemeAction
extends DumbAwareAction {
    private final String recorderId;
    private static final LayeredIcon ICON;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void title$iv;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        WhitelistTestGroupStorage testSchemeStorage = WhitelistTestGroupStorage.getTestStorage((String)this.recorderId);
        if (testSchemeStorage == null) {
            StatisticsDevKitUtil.INSTANCE.showNotification(project2, NotificationType.ERROR, StatisticsBundle.message((String)"stats.cannot.find.test.scheme.storage", (Object[])new Object[0]));
            return;
        }
        EventsTestScheme scheme = this.loadEventsScheme(project2, testSchemeStorage);
        if (scheme == null) {
            return;
        }
        EditEventsTestSchemePanel editTestSchemePanel = new EditEventsTestSchemePanel(project2, scheme.getLocalGroups(), scheme.getProductionGroups());
        DialogWrapper dialog2 = ComponentsKt.dialog$default((String)StatisticsBundle.message((String)"stats.edit.test.scheme", (Object[])new Object[0]), (JComponent)editTestSchemePanel, (boolean)true, (JComponent)editTestSchemePanel.getFocusedComponent(), (boolean)false, (Project)project2, null, null, null, null, (Function0)((Function0)new Function0<List<? extends ValidationInfo>>(editTestSchemePanel){
            final /* synthetic */ EditEventsTestSchemePanel $editTestSchemePanel;

            @Nullable
            public final List<ValidationInfo> invoke() {
                return this.$editTestSchemePanel.validateGroups();
            }
            {
                this.$editTestSchemePanel = editEventsTestSchemePanel;
                super(0);
            }
        }), (int)976, null);
        Disposer.register((Disposable)dialog2.getDisposable(), (Disposable)editTestSchemePanel);
        if (!dialog2.showAndGet()) {
            return;
        }
        String string = StatisticsBundle.message((String)"stats.updating.test.scheme", (Object[])new Object[0]);
        boolean cancellable$iv = false;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, (String)title$iv, cancellable$iv, project2, (String)title$iv, cancellable$iv, testSchemeStorage, editTestSchemePanel, project2){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ WhitelistTestGroupStorage $testSchemeStorage$inlined;
            final /* synthetic */ EditEventsTestSchemePanel $editTestSchemePanel$inlined;
            final /* synthetic */ Project $project$inlined;
            {
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$cancellable = $captured_local_variable$3;
                this.$testSchemeStorage$inlined = whitelistTestGroupStorage;
                this.$editTestSchemePanel$inlined = editEventsTestSchemePanel;
                this.$project$inlined = project;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                ProgressIndicator it = indicator;
                boolean bl = false;
                try {
                    this.$testSchemeStorage$inlined.updateTestGroups(this.$editTestSchemePanel$inlined.getGroups());
                    StatisticsDevKitUtil.INSTANCE.showNotification(this.$project$inlined, NotificationType.INFORMATION, StatisticsBundle.message((String)"stats.test.scheme.was.updated", (Object[])new Object[0]));
                }
                catch (IOException ex) {
                    StatisticsDevKitUtil.INSTANCE.showNotification(this.$project$inlined, NotificationType.ERROR, StatisticsBundle.message((String)"stats.failed.updating.test.scheme.0", (Object[])new Object[]{ex.getMessage()}));
                }
            }
        });
    }

    private final EventsTestScheme loadEventsScheme(Project project, WhitelistTestGroupStorage testSchemeStorage) {
        return (EventsTestScheme)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<EventsTestScheme, IOException>(testSchemeStorage, project, project, StatisticsBundle.message((String)"stats.loading.test.scheme", (Object[])new Object[0]), true){
            final /* synthetic */ WhitelistTestGroupStorage $testSchemeStorage;
            final /* synthetic */ Project $project;

            @Nullable
            protected EventsTestScheme compute(@NotNull ProgressIndicator indicator) {
                List localGroups = this.$testSchemeStorage.loadLocalWhitelistGroups();
                if (indicator.isCanceled()) {
                    return null;
                }
                FUStatisticsWhiteListGroupsService.WLGroups productionGroups = this.$testSchemeStorage.loadProductionGroups();
                if (indicator.isCanceled()) {
                    return null;
                }
                return new EventsTestScheme(localGroups, productionGroups);
            }
            {
                this.$testSchemeStorage = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        WhitelistTestGroupStorage whitelistTestGroupStorage = WhitelistTestGroupStorage.getTestStorage((String)this.recorderId);
        int testSchemeSize = whitelistTestGroupStorage != null ? whitelistTestGroupStorage.size() : 0;
        String text = testSchemeSize < 100 ? String.valueOf(testSchemeSize) : "99+";
        TextIcon sizeCountIcon = new TextIcon(text, (Color)JBColor.DARK_GRAY, UIUtil.getLabelBackground(), 1);
        sizeCountIcon.setFont(new Font(UIUtil.getLabelFont().getName(), 1, JBUIScale.scale((int)9)));
        sizeCountIcon.setInsets(1, 1, 0, 0);
        ICON.setIcon((Icon)sizeCountIcon, 1, JBUIScale.scale((int)10), JBUIScale.scale((int)10));
        e.getPresentation().setIcon((Icon)ICON);
    }

    public EditEventsTestSchemeAction(@NotNull String recorderId) {
        super(ActionsBundle.messagePointer((String)"action.EditTestSchemeAction.text", (Object[])new Object[0]), ActionsBundle.messagePointer((String)"action.EditTestSchemeAction.description", (Object[])new Object[0]), (Icon)ICON);
        this.recorderId = recorderId;
    }

    public /* synthetic */ EditEventsTestSchemeAction(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "FUS";
        }
        this(string);
    }

    public EditEventsTestSchemeAction() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        ICON = new LayeredIcon(2);
        ICON.setIcon(AllIcons.Actions.Edit, 0);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/internal/statistic/actions/scheme/EditEventsTestSchemeAction$EventsTestScheme;", "", "localGroups", "", "Lcom/intellij/internal/statistic/eventLog/whitelist/LocalWhitelistGroup;", "productionGroups", "Lcom/intellij/internal/statistic/service/fus/FUStatisticsWhiteListGroupsService$WLGroups;", "(Ljava/util/List;Lcom/intellij/internal/statistic/service/fus/FUStatisticsWhiteListGroupsService$WLGroups;)V", "getLocalGroups", "()Ljava/util/List;", "getProductionGroups", "()Lcom/intellij/internal/statistic/service/fus/FUStatisticsWhiteListGroupsService$WLGroups;", "intellij.platform.statistics.devkit"})
    public static final class EventsTestScheme {
        @NotNull
        private final List<LocalWhitelistGroup> localGroups;
        @NotNull
        private final FUStatisticsWhiteListGroupsService.WLGroups productionGroups;

        @NotNull
        public final List<LocalWhitelistGroup> getLocalGroups() {
            return this.localGroups;
        }

        @NotNull
        public final FUStatisticsWhiteListGroupsService.WLGroups getProductionGroups() {
            return this.productionGroups;
        }

        public EventsTestScheme(@NotNull List<LocalWhitelistGroup> localGroups, @NotNull FUStatisticsWhiteListGroupsService.WLGroups productionGroups) {
            this.localGroups = localGroups;
            this.productionGroups = productionGroups;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/internal/statistic/actions/scheme/EditEventsTestSchemeAction$Companion;", "", "()V", "ICON", "Lcom/intellij/ui/LayeredIcon;", "intellij.platform.statistics.devkit"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

