/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class NotNullCachedComputableWrapper<T>
implements NotNullComputable<T> {
    private volatile NotNullComputable<T> myComputable;
    private final AtomicReference<T> myValueRef = new AtomicReference();

    public NotNullCachedComputableWrapper(@NotNull NotNullComputable<T> computable) {
        this.myComputable = computable;
    }

    @NotNull
    public T compute() {
        Object value;
        block2: {
            while (true) {
                if ((value = this.myValueRef.get()) != null) {
                    return value;
                }
                NotNullComputable<T> computable = this.myComputable;
                if (computable == null) continue;
                RecursionGuard.StackStamp stamp = RecursionManager.markStack();
                value = computable.compute();
                if (!stamp.mayCacheNow()) break block2;
                if (this.myValueRef.compareAndSet(null, value)) break;
            }
            this.myComputable = null;
            return value;
        }
        return value;
    }

    public boolean isComputed() {
        return this.myValueRef.get() != null;
    }
}

