/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.unwrap;

import com.intellij.java.JavaBundle;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.unwrap.GroovyUnwrapper;

public class GroovyAnonymousUnwrapper
extends GroovyUnwrapper {
    public GroovyAnonymousUnwrapper() {
        super(JavaBundle.message((String)"unwrap.anonymous", (Object[])new Object[0]));
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        return e instanceof GrAnonymousClassDefinition && ((GrAnonymousClassDefinition)e).getMethods().length <= 1;
    }

    public PsiElement collectAffectedElements(@NotNull PsiElement e, @NotNull List<PsiElement> toExtract) {
        super.collectAffectedElements(e, toExtract);
        return GroovyAnonymousUnwrapper.findElementToExtractFrom(e);
    }

    protected void doUnwrap(PsiElement element, GroovyUnwrapper.Context context) throws IncorrectOperationException {
        PsiElement from = GroovyAnonymousUnwrapper.findElementToExtractFrom(element);
        for (PsiMethod psiMethod : ((PsiAnonymousClass)element).getMethods()) {
        }
        PsiElement next = from.getNextSibling();
        if (PsiUtil.isJavaToken((PsiElement)next, (IElementType)JavaTokenType.SEMICOLON)) {
            context.deleteExactly(from.getNextSibling());
        }
        context.deleteExactly(from);
    }

    private static PsiElement findElementToExtractFrom(PsiElement el) {
        if (el.getParent() instanceof PsiNewExpression) {
            el = el.getParent();
        }
        el = GroovyAnonymousUnwrapper.findTopmostParentOfType(el, PsiMethodCallExpression.class);
        el = GroovyAnonymousUnwrapper.findTopmostParentOfType(el, PsiAssignmentExpression.class);
        el = GroovyAnonymousUnwrapper.findTopmostParentOfType(el, PsiDeclarationStatement.class);
        while (el.getParent() instanceof PsiExpressionStatement) {
            el = el.getParent();
        }
        return el;
    }

    private static PsiElement findTopmostParentOfType(PsiElement el, Class<? extends PsiElement> clazz) {
        PsiElement temp;
        while ((temp = PsiTreeUtil.getParentOfType((PsiElement)el, clazz, (boolean)true, (Class[])new Class[]{PsiAnonymousClass.class})) != null && !(temp instanceof PsiFile)) {
            el = temp;
        }
        return el;
    }
}

