/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.net.HttpConfigurable;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.bundled.BundledGroovy;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class DefaultGroovyScriptRunner
extends GroovyScriptRunner {
    @Override
    public boolean isValidModule(@NotNull Module module) {
        return LibrariesUtil.hasGroovySdk(module);
    }

    @Override
    public void ensureRunnerConfigured(@NotNull GroovyScriptRunConfiguration configuration) throws RuntimeConfigurationException {
        Module module = configuration.getModule();
        if (module == null) {
            throw new RuntimeConfigurationException("Module is not specified");
        }
        if (LibrariesUtil.getGroovyHomePath(module) == null) {
            RuntimeConfigurationException e = new RuntimeConfigurationException("Groovy is not configured for module '" + module.getName() + "'");
            e.setQuickFix(() -> ModulesConfigurator.showDialog((Project)module.getProject(), (String)module.getName(), (String)ClasspathEditor.getName()));
            throw e;
        }
    }

    @Override
    public void configureCommandLine(JavaParameters params, @Nullable Module module, boolean tests, VirtualFile script, GroovyScriptRunConfiguration configuration) throws CantRunException {
        DefaultGroovyScriptRunner.configureGenericGroovyRunner(params, module, "groovy.ui.GroovyMain", false, tests, configuration.isAddClasspathToTheRunner(), true);
        params.getVMParametersList().addParametersString(configuration.getVMParameters());
        DefaultGroovyScriptRunner.addScriptEncodingSettings(params, script, module);
        if (configuration.isDebugEnabled()) {
            params.getProgramParametersList().add("--debug");
        }
        String path = ScriptFileUtil.getLocalFilePath((String)StringUtil.notNullize((String)configuration.getScriptPath()));
        params.getProgramParametersList().add(FileUtil.toSystemDependentName((String)path));
        params.getProgramParametersList().addParametersString(configuration.getProgramParameters());
    }

    public static void configureGenericGroovyRunner(@NotNull JavaParameters params, @NotNull Module module, @NotNull String mainClass, boolean useBundled, boolean tests) throws CantRunException {
        DefaultGroovyScriptRunner.configureGenericGroovyRunner(params, module, mainClass, useBundled, tests, true, true);
    }

    public static void configureGenericGroovyRunner(@NotNull JavaParameters params, @NotNull Module module, @NotNull String mainClass, boolean useBundled, boolean tests, boolean addClasspathToRunner, boolean addClassPathToStarter) throws CantRunException {
        String sysRoot;
        String confPath;
        String groovyHomeDependentName;
        VirtualFile groovyJar = DefaultGroovyScriptRunner.findGroovyJar(module);
        if (useBundled) {
            params.getClassPath().add(BundledGroovy.getBundledGroovyFile());
        } else if (groovyJar != null) {
            params.getClassPath().add(groovyJar);
        }
        if (addClasspathToRunner) {
            DefaultGroovyScriptRunner.getClassPathFromRootModel(module, tests, params, true, params.getClassPath());
        }
        DefaultGroovyScriptRunner.setToolsJar(params);
        String groovyHome = useBundled ? FileUtil.toCanonicalPath((String)BundledGroovy.getBundledGroovyFile().getParentFile().getParent()) : LibrariesUtil.getGroovyHomePath(module);
        String string = groovyHomeDependentName = groovyHome != null ? FileUtil.toSystemDependentName((String)groovyHome) : null;
        if (groovyHomeDependentName != null) {
            DefaultGroovyScriptRunner.setGroovyHome(params, groovyHomeDependentName);
        }
        if ((confPath = DefaultGroovyScriptRunner.getConfPath(groovyHomeDependentName)) != null) {
            params.getVMParametersList().add("-Dgroovy.starter.conf=" + confPath);
            params.getProgramParametersList().add("--conf");
            params.getProgramParametersList().add(confPath);
        }
        HttpConfigurable.getInstance().getJvmProperties(false, null).forEach(p -> params.getVMParametersList().addProperty((String)p.first, (String)p.second));
        params.setMainClass("org.codehaus.groovy.tools.GroovyStarter");
        params.getProgramParametersList().add("--main");
        params.getProgramParametersList().add(mainClass);
        if (addClassPathToStarter) {
            DefaultGroovyScriptRunner.addClasspathFromRootModel(module, tests, params, true);
        }
        if (params.getVMParametersList().getPropertyValue("grape.root") == null && (sysRoot = System.getProperty("grape.root")) != null) {
            params.getVMParametersList().defineProperty("grape.root", sysRoot);
        }
    }

    private static void addScriptEncodingSettings(JavaParameters params, VirtualFile scriptFile, Module module) {
        Charset charset = EncodingProjectManager.getInstance((Project)module.getProject()).getEncoding(scriptFile, true);
        if (charset == null) {
            charset = EncodingManager.getInstance().getDefaultCharset();
            if (!Comparing.equal((Object)CharsetToolkit.getDefaultSystemCharset(), (Object)charset)) {
                params.getProgramParametersList().add("--encoding=" + charset.displayName());
            }
        } else {
            params.getProgramParametersList().add("--encoding=" + charset.displayName());
        }
    }
}

