/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMvcPsiNodeDescriptor
extends BasePsiNode<PsiElement> {
    public static final int FOLDER = 100;
    public static final int FILE = 110;
    public static final int CLASS = 5;
    public static final int FIELD = 7;
    public static final int METHOD = 10;
    public static final int DOMAIN_CLASSES_FOLDER = 20;
    public static final int CONTROLLERS_FOLDER = 30;
    public static final int VIEWS_FOLDER = 40;
    public static final int SERVICES_FOLDER = 50;
    public static final int CONFIG_FOLDER = 60;
    public static final int OTHER_GRAILS_APP_FOLDER = 64;
    public static final int WEB_APP_FOLDER = 65;
    public static final int SRC_FOLDERS = 70;
    public static final int TESTS_FOLDER = 80;
    public static final int TAGLIB_FOLDER = 90;
    private final Module myModule;
    private final int myWeight;

    protected AbstractMvcPsiNodeDescriptor(@NotNull Module module, ViewSettings viewSettings, @NotNull PsiElement nodeId, int weight) {
        super(module.getProject(), nodeId, viewSettings);
        this.myModule = module;
        this.myWeight = weight;
    }

    @NonNls
    protected abstract String getTestPresentationImpl(@NotNull PsiElement var1);

    public final boolean contains(@NotNull VirtualFile file) {
        return this.isValid() && this.containsImpl(file);
    }

    protected boolean containsImpl(@NotNull VirtualFile file) {
        return super.contains(file);
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        PsiElement psi = this.extractPsiFromValue();
        if (psi == null || !psi.isValid() || !this.isValid()) {
            return "null";
        }
        return this.getTestPresentationImpl(psi);
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    protected void updateImpl(@NotNull PresentationData data) {
        PsiElement psiElement = this.extractPsiFromValue();
        if (psiElement instanceof NavigationItem) {
            ItemPresentation presentation = ((NavigationItem)psiElement).getPresentation();
            assert (presentation != null);
            data.setPresentableText(presentation.getPresentableText());
        }
    }

    public final int getTypeSortWeight(boolean sortByType) {
        return this.myWeight;
    }

    protected boolean hasProblemFileBeneath() {
        return WolfTheProblemSolver.getInstance((Project)this.getProject()).hasProblemFilesBeneath(virtualFile -> this.contains((VirtualFile)virtualFile));
    }

    public boolean isValid() {
        PsiElement psiElement = this.extractPsiFromValue();
        return psiElement != null && psiElement.isValid();
    }
}

