/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs;

import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListUtil;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFileStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrMethodStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrModifierListStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrPackageDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;

public final class GrStubUtils {
    public static void writeStringArray(@NotNull StubOutputStream dataStream, String @NotNull [] array) throws IOException {
        DataInputOutputUtilRt.writeSeq((DataOutput)dataStream, (Collection)ContainerUtil.newArrayList((Object[])array), arg_0 -> ((StubOutputStream)dataStream).writeName(arg_0));
    }

    public static String @NotNull [] readStringArray(@NotNull StubInputStream dataStream) throws IOException {
        return ArrayUtilRt.toStringArray((Collection)DataInputOutputUtilRt.readSeq((DataInput)dataStream, () -> ((StubInputStream)dataStream).readNameString()));
    }

    public static void writeNullableString(StubOutputStream dataStream, @Nullable String typeText) throws IOException {
        DataInputOutputUtil.writeNullable((DataOutput)dataStream, (Object)typeText, arg_0 -> ((StubOutputStream)dataStream).writeUTFFast(arg_0));
    }

    @Nullable
    public static String readNullableString(StubInputStream dataStream) throws IOException {
        return (String)DataInputOutputUtil.readNullable((DataInput)dataStream, () -> ((StubInputStream)dataStream).readUTFFast());
    }

    @Nullable
    public static String getTypeText(@Nullable GrTypeElement typeElement) {
        return typeElement == null ? null : typeElement.getText();
    }

    @NotNull
    private static Map<String, String> getAliasMapping(@Nullable PsiFile file) {
        if (!(file instanceof GroovyFile)) {
            return Collections.emptyMap();
        }
        return (Map)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            HashMap<String, String> mapping2 = new HashMap<String, String>();
            for (GrImportStatement importStatement : ((GroovyFile)file).getImportStatements()) {
                String importedName;
                String fqn = importStatement.getImportFqn();
                if (fqn == null || importStatement.isStatic() || !importStatement.isAliasedImport() || (importedName = importStatement.getImportedName()) == null) continue;
                mapping2.put(importedName, fqn);
            }
            return CachedValueProvider.Result.create(mapping2, (Object[])new Object[]{file});
        });
    }

    @Nullable
    public static String getReferenceName(@NotNull GrReferenceElement element) {
        String referenceName = element.getReferenceName();
        if (referenceName == null) {
            return null;
        }
        String mappedFqn = GrStubUtils.getAliasMapping(element.getContainingFile()).get(referenceName);
        String fullText = element.getText();
        return mappedFqn == null || element.isQualified() ? fullText : fullText.replace(referenceName, mappedFqn);
    }

    @Nullable
    public static String getBaseClassName(@NotNull GrTypeDefinition psi) {
        if (!(psi instanceof GrAnonymousClassDefinition)) {
            return null;
        }
        return GrStubUtils.getReferenceName(((GrAnonymousClassDefinition)psi).getBaseClassReferenceGroovy());
    }

    public static String[] getAnnotationNames(PsiModifierListOwner psi) {
        ArrayList<String> annoNames = new ArrayList<String>();
        PsiModifierList modifierList = psi.getModifierList();
        if (modifierList instanceof GrModifierList) {
            for (GrAnnotation annotation : ((GrModifierList)modifierList).getRawAnnotations()) {
                String name = annotation.getShortName();
                if (!StringUtil.isNotEmpty((String)name)) continue;
                annoNames.add(name);
            }
        }
        return ArrayUtilRt.toStringArray(annoNames);
    }

    public static boolean isGroovyStaticMemberStub(StubElement<?> stub) {
        StubElement classStub;
        StubElement modifierOwner = stub instanceof GrMethodStub ? stub : stub.getParentStub();
        GrModifierListStub type2 = (GrModifierListStub)modifierOwner.findChildStubByType((IStubElementType)GroovyStubElementTypes.MODIFIER_LIST);
        if (type2 == null) {
            return false;
        }
        int mask = type2.getModifiersFlags();
        if (GrModifierListUtil.hasMaskModifier(mask, "private")) {
            return false;
        }
        if (GrModifierListUtil.hasMaskModifier(mask, "static")) {
            return true;
        }
        StubElement parent2 = modifierOwner.getParentStub();
        StubElement stubElement = classStub = parent2 == null ? null : parent2.getParentStub();
        return classStub instanceof GrTypeDefinitionStub && (((GrTypeDefinitionStub)classStub).isAnnotationType() || ((GrTypeDefinitionStub)classStub).isInterface());
    }

    @NotNull
    public static String getShortTypeText(@Nullable String text) {
        if (text == null) {
            return "";
        }
        int i = text.length();
        while (i - 2 >= 0 && text.charAt(i - 2) == '[' && text.charAt(i - 1) == ']') {
            i -= 2;
        }
        return PsiNameHelper.getShortClassName((String)text.substring(0, i)) + text.substring(i);
    }

    @Nullable
    public static String getPackageName(GrFileStub stub) {
        for (StubElement child : stub.getChildrenStubs()) {
            if (!(child instanceof GrPackageDefinitionStub)) continue;
            return ((GrPackageDefinitionStub)child).getPackageName();
        }
        return null;
    }
}

