/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyElementPattern;

public class GroovyExpressionPattern<T extends GrExpression, Self extends GroovyExpressionPattern<T, Self>>
extends GroovyElementPattern<T, Self> {
    protected GroovyExpressionPattern(Class<T> aClass) {
        super(aClass);
    }

    @NotNull
    public Self ofType(final @NotNull ElementPattern pattern) {
        return (Self)((Object)((GroovyExpressionPattern)this.with(new PatternCondition<T>("ofType"){

            public boolean accepts(@NotNull T t, ProcessingContext context) {
                return pattern.accepts((Object)t.getType(), context);
            }
        })));
    }

    @NotNull
    public Self skipParentheses(final ElementPattern<? extends GrExpression> expressionPattern) {
        return (Self)((Object)((GroovyExpressionPattern)this.with(new PatternCondition<T>("skipParentheses"){

            public boolean accepts(@NotNull T t, ProcessingContext context) {
                Object expression = t;
                while (expression instanceof GrParenthesizedExpression) {
                    expression = ((GrParenthesizedExpression)expression).getOperand();
                }
                return expressionPattern.accepts(expression, context);
            }
        })));
    }

    public static class Capture<T extends GrExpression>
    extends GroovyExpressionPattern<T, Capture<T>> {
        public Capture(Class<T> aClass) {
            super(aClass);
        }
    }
}

