/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.types;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrTypeCastExpressionImpl
extends GrExpressionImpl
implements GrTypeCastExpression {
    public GrTypeCastExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitCastExpression(this);
    }

    public String toString() {
        return "Typecast expression";
    }

    @Override
    public PsiType getType() {
        GrTypeElement typeElement = this.getCastTypeElement();
        return typeElement != null ? TypesUtil.boxPrimitiveType(typeElement.getType(), (PsiManager)this.getManager(), this.getResolveScope()) : null;
    }

    @Override
    public GrTypeElement getCastTypeElement() {
        return (GrTypeElement)this.findChildByClass(GrTypeElement.class);
    }

    @Override
    @Nullable
    public GrExpression getOperand() {
        return GrTypeCastExpressionImpl.findExpressionChild(this);
    }

    @Override
    @NotNull
    public PsiElement getLeftParen() {
        ASTNode paren = this.getNode().findChildByType(GroovyTokenTypes.mLPAREN);
        assert (paren != null);
        return paren.getPsi();
    }

    @Override
    @NotNull
    public PsiElement getRightParen() {
        ASTNode paren = this.getNode().findChildByType(GroovyTokenTypes.mRPAREN);
        assert (paren != null);
        return paren.getPsi();
    }
}

