/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators;

import com.intellij.psi.PsiType;
import com.intellij.util.NullableFunction;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrOperatorExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators.GrBinaryExpressionUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;
import org.jetbrains.plugins.groovy.lang.typing.DefaultMethodCallTypeCalculatorKt;

public class GrNumericBinaryExpressionTypeCalculator
implements NullableFunction<GrOperatorExpression, PsiType> {
    public static final GrNumericBinaryExpressionTypeCalculator INSTANCE = new GrNumericBinaryExpressionTypeCalculator();

    @Nullable
    public PsiType fun(GrOperatorExpression e) {
        GroovyCallReference operatorReference = Objects.requireNonNull(e.getReference());
        GroovyResolveResult resolveResult2 = operatorReference.advancedResolve();
        if (resolveResult2.isApplicable() && !PsiUtil.isDGMMethod(resolveResult2.getElement())) {
            return DefaultMethodCallTypeCalculatorKt.getTypeFromResult(resolveResult2, operatorReference.getArguments(), e);
        }
        PsiType lType = e.getLeftType();
        PsiType rType = e.getRightType();
        if (TypesUtil.isNumericType(lType) && TypesUtil.isNumericType(rType)) {
            return this.inferNumericType(lType, rType, e);
        }
        return DefaultMethodCallTypeCalculatorKt.getTypeFromResult(resolveResult2, operatorReference.getArguments(), e);
    }

    @Nullable
    protected PsiType inferNumericType(@NotNull PsiType ltype, @NotNull PsiType rtype, GrOperatorExpression e) {
        return GrBinaryExpressionUtil.getDefaultNumericResultType(ltype, rtype, e);
    }
}

