/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypeVisitorEx;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrImmediateTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.LazyFqnClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrImmediateClosureSignatureImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ClassUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrTypeMapper;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypeConstants;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class TypesUtil
implements TypeConstants {
    public static final PsiPrimitiveType[] PRIMITIVES = new PsiPrimitiveType[]{PsiType.BYTE, PsiType.CHAR, PsiType.DOUBLE, PsiType.FLOAT, PsiType.INT, PsiType.SHORT, PsiType.LONG, PsiType.BOOLEAN, PsiType.VOID};
    private static final Map<IElementType, String> ourPrimitiveTypesToClassNames = new HashMap<IElementType, String>();
    private static final String NULL = "null";
    static final TObjectIntHashMap<String> TYPE_TO_RANK;
    static final TIntObjectHashMap<String> RANK_TO_TYPE;
    private static final List<PsiType> LUB_NUMERIC_TYPES;

    private TypesUtil() {
    }

    @Deprecated
    public static boolean isAssignable(@Nullable PsiType lType, @Nullable PsiType rType, @NotNull PsiElement context) {
        if (lType == null || rType == null) {
            return false;
        }
        return TypesUtil.canAssign(lType, rType, context, GrTypeConverter.Position.ASSIGNMENT) == ConversionResult.OK;
    }

    @NotNull
    public static ConversionResult canAssign(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull PsiElement context, @NotNull GrTypeConverter.Position position) {
        GlobalSearchScope scope;
        if (actualType instanceof PsiIntersectionType) {
            ConversionResult min = ConversionResult.ERROR;
            for (PsiType child : ((PsiIntersectionType)actualType).getConjuncts()) {
                ConversionResult result2 = TypesUtil.canAssign(targetType, child, context, position);
                if (result2.ordinal() < min.ordinal()) {
                    min = result2;
                }
                if (min != ConversionResult.OK) continue;
                return ConversionResult.OK;
            }
            return min;
        }
        if (targetType instanceof PsiIntersectionType) {
            ConversionResult max = ConversionResult.OK;
            for (PsiType child : ((PsiIntersectionType)targetType).getConjuncts()) {
                ConversionResult result3 = TypesUtil.canAssign(child, actualType, context, position);
                if (result3.ordinal() > max.ordinal()) {
                    max = result3;
                }
                if (max != ConversionResult.ERROR) continue;
                return ConversionResult.ERROR;
            }
            return max;
        }
        ConversionResult result4 = TypesUtil.areTypesConvertible(targetType, actualType, context, position);
        if (result4 != null) {
            return result4;
        }
        if (TypesUtil.isAssignableWithoutConversions(targetType, actualType)) {
            return ConversionResult.OK;
        }
        PsiManager manager = context.getManager();
        if ((targetType = TypesUtil.boxPrimitiveType(targetType, manager, scope = context.getResolveScope())).isAssignableFrom(actualType = TypesUtil.boxPrimitiveType(actualType, manager, scope))) {
            return ConversionResult.OK;
        }
        return ConversionResult.ERROR;
    }

    public static boolean isAssignableByMethodCallConversion(@Nullable PsiType targetType, @Nullable PsiType actualType, @NotNull PsiElement context) {
        if (targetType == null || actualType == null) {
            return false;
        }
        return TypesUtil.canAssign(targetType, actualType, context, GrTypeConverter.Position.METHOD_PARAMETER) == ConversionResult.OK;
    }

    public static boolean isAssignableByParameter(@Nullable PsiType targetType, @Nullable PsiType actualType, @NotNull PsiElement context) {
        if (targetType == null || actualType == null) {
            return false;
        }
        return TypesUtil.canAssign(targetType, actualType, context, GrTypeConverter.Position.GENERIC_PARAMETER) == ConversionResult.OK;
    }

    @Nullable
    private static ConversionResult areTypesConvertible(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull PsiElement context, @NotNull GrTypeConverter.Position position) {
        if (!(context instanceof GroovyPsiElement)) {
            return null;
        }
        if (targetType.equals(actualType)) {
            return ConversionResult.OK;
        }
        for (GrTypeConverter converter : (GrTypeConverter[])GrTypeConverter.EP_NAME.getExtensions()) {
            ConversionResult result2;
            if (!converter.isApplicableTo(position) || (result2 = converter.isConvertible(targetType, actualType, position, (GroovyPsiElement)context)) == null) continue;
            return result2;
        }
        return null;
    }

    public static boolean isAssignableWithoutConversions(@Nullable PsiType lType, @Nullable PsiType rType) {
        if (lType == null || rType == null) {
            return false;
        }
        if (rType == PsiType.NULL) {
            return !(lType instanceof PsiPrimitiveType);
        }
        if (rType instanceof GrTraitType) {
            for (PsiType type2 : ((GrTraitType)rType).getConjuncts()) {
                if (!TypesUtil.isAssignableWithoutConversions(lType, type2)) continue;
                return true;
            }
            return false;
        }
        if (TypesUtil.isClassType(rType, "groovy.lang.GString") && lType.equalsToText("java.lang.String")) {
            return true;
        }
        lType = TypesUtil.optionalUnbox(lType);
        rType = TypesUtil.optionalUnbox(rType);
        return TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)rType);
    }

    @NotNull
    public static ConversionResult canCast(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull PsiElement context) {
        ConversionResult result2 = TypesUtil.areTypesConvertible(targetType, actualType, context, GrTypeConverter.Position.EXPLICIT_CAST);
        if (result2 != null) {
            return result2;
        }
        return TypeConversionUtil.areTypesConvertible((PsiType)actualType, (PsiType)targetType) ? ConversionResult.OK : ConversionResult.ERROR;
    }

    @NotNull
    public static ConversionResult canAssignWithinMultipleAssignment(@NotNull PsiType targetType, @NotNull PsiType actualType) {
        return TypesUtil.isAssignableWithoutConversions(targetType, actualType) ? ConversionResult.OK : ConversionResult.ERROR;
    }

    public static boolean isNumericType(@Nullable PsiType type2) {
        if (type2 instanceof PsiClassType) {
            return TYPE_TO_RANK.contains((Object)TypesUtil.getQualifiedName(type2));
        }
        return type2 instanceof PsiPrimitiveType && TypeConversionUtil.isNumericType((PsiType)type2);
    }

    public static boolean isIntegralNumberType(@Nullable PsiType type2) {
        if (type2 instanceof PsiClassType) {
            int rank = TYPE_TO_RANK.get((Object)TypesUtil.getQualifiedName(type2));
            return rank > 0 && rank <= 6;
        }
        return type2 instanceof PsiPrimitiveType && TypeConversionUtil.isIntegralNumberType((PsiType)type2);
    }

    public static PsiType unboxPrimitiveTypeWrapperAndEraseGenerics(PsiType result2) {
        return TypeConversionUtil.erasure((PsiType)TypesUtil.unboxPrimitiveTypeWrapper(result2));
    }

    @NotNull
    public static PsiType optionalUnbox(@NotNull PsiType type2) {
        PsiType unboxed = TypesUtil.unboxPrimitiveTypeWrapper(type2);
        return unboxed == null ? type2 : unboxed;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiType unboxPrimitiveTypeWrapper(@Nullable PsiType type2) {
        PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType((PsiType)type2);
        return unboxed == null ? type2 : unboxed;
    }

    public static PsiType boxPrimitiveType(@Nullable PsiType result2, @NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope, boolean boxVoid) {
        PsiPrimitiveType primitive;
        String boxedTypeName;
        if (result2 instanceof PsiPrimitiveType && (boxVoid || !PsiType.VOID.equals((Object)result2)) && (boxedTypeName = (primitive = (PsiPrimitiveType)result2).getBoxedTypeName()) != null) {
            return GroovyPsiManager.getInstance(manager.getProject()).createTypeByFQClassName(boxedTypeName, resolveScope);
        }
        return result2;
    }

    public static PsiType boxPrimitiveType(@Nullable PsiType result2, @NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        return TypesUtil.boxPrimitiveType(result2, manager, resolveScope, false);
    }

    @NotNull
    public static PsiClassType createType(String fqName, @NotNull PsiElement context) {
        return TypesUtil.createTypeByFQClassName(fqName, context);
    }

    @NotNull
    public static PsiClassType createType(@NotNull PsiClass clazz) {
        return TypesUtil.createType(clazz, null, new PsiType[0]);
    }

    @NotNull
    public static PsiClassType createType(@NotNull PsiClass clazz, @Nullable PsiElement context, PsiType ... parameters2) {
        return JavaPsiFacade.getInstance((Project)(context == null ? clazz : context).getProject()).getElementFactory().createType(clazz, parameters2);
    }

    @NotNull
    public static PsiClassType getJavaLangObject(@NotNull PsiElement context) {
        return LazyFqnClassType.getLazyType("java.lang.Object", context);
    }

    @Nullable
    public static PsiType getLeastUpperBoundNullable(@Nullable PsiType type1, @Nullable PsiType type2, @NotNull PsiManager manager) {
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        return TypesUtil.getLeastUpperBound(type1, type2, manager);
    }

    @Nullable
    public static PsiType getLeastUpperBoundNullable(@NotNull Iterable<? extends PsiType> collection, @NotNull PsiManager manager) {
        Iterator<? extends PsiType> iterator2 = collection.iterator();
        PsiType result2 = null;
        while (iterator2.hasNext()) {
            result2 = TypesUtil.getLeastUpperBoundNullable(result2, iterator2.next(), manager);
        }
        return result2;
    }

    @Nullable
    public static PsiType getLeastUpperBound(@NotNull PsiType type1, @NotNull PsiType type2, @NotNull PsiManager manager) {
        PsiType numericLUB = TypesUtil.getNumericLUB(type1, type2);
        if (numericLUB != null) {
            return numericLUB;
        }
        if (type1 instanceof GrTupleType && type2 instanceof GrTupleType) {
            GrTupleType tuple1 = (GrTupleType)type1;
            GrTupleType tuple2 = (GrTupleType)type2;
            List<PsiType> components1 = tuple1.getComponentTypes();
            List<PsiType> components2 = tuple2.getComponentTypes();
            if (components1.isEmpty()) {
                return TypesUtil.genNewListBy(type2, manager);
            }
            if (components2.isEmpty()) {
                return TypesUtil.genNewListBy(type1, manager);
            }
            PsiType[] components3 = PsiType.createArray((int)Math.min(components1.size(), components2.size()));
            for (int i = 0; i < components3.length; ++i) {
                PsiType c1 = components1.get(i);
                PsiType c2 = components2.get(i);
                components3[i] = c1 == null || c2 == null ? null : TypesUtil.getLeastUpperBound(c1, c2, manager);
            }
            return new GrImmediateTupleType(Arrays.asList(components3), JavaPsiFacade.getInstance((Project)manager.getProject()), tuple1.getResolveScope().intersectWith(tuple2.getResolveScope()));
        }
        if (TypesUtil.checkEmptyListAndList(type1, type2)) {
            return TypesUtil.genNewListBy(type2, manager);
        }
        if (TypesUtil.checkEmptyListAndList(type2, type1)) {
            return TypesUtil.genNewListBy(type1, manager);
        }
        if (type1 instanceof GrMapType && type2 instanceof GrMapType) {
            return GrMapType.merge((GrMapType)type1, (GrMapType)type2);
        }
        if (TypesUtil.checkEmptyMapAndMap(type1, type2)) {
            return TypesUtil.genNewMapBy(type2, manager);
        }
        if (TypesUtil.checkEmptyMapAndMap(type2, type1)) {
            return TypesUtil.genNewMapBy(type1, manager);
        }
        if (type1 instanceof GrClosureType && type2 instanceof GrClosureType) {
            GrClosureType clType1 = (GrClosureType)type1;
            GrClosureType clType2 = (GrClosureType)type2;
            List<GrSignature> signatures1 = clType1.getSignatures();
            List<GrSignature> signatures2 = clType2.getSignatures();
            if (signatures1.size() == 1 && signatures2.size() == 1) {
                GrSignature signature;
                GrSignature signature1 = signatures1.get(0);
                GrSignature signature2 = signatures2.get(0);
                if (signature1.getParameterCount() == signature2.getParameterCount() && (signature = GrImmediateClosureSignatureImpl.getLeastUpperBound(signature1, signature2, manager)) != null) {
                    GlobalSearchScope scope = clType1.getResolveScope().intersectWith(clType2.getResolveScope());
                    LanguageLevel languageLevel = (LanguageLevel)ComparatorUtil.max((Comparable)clType1.getLanguageLevel(), (Comparable)clType2.getLanguageLevel());
                    return GrClosureType.create(Collections.singletonList(signature), scope, JavaPsiFacade.getInstance((Project)manager.getProject()), languageLevel, true);
                }
            }
        } else {
            if ("groovy.lang.GString".equals(TypesUtil.getQualifiedName(type1)) && "java.lang.String".equals(TypesUtil.getQualifiedName(type2))) {
                return type2;
            }
            if ("groovy.lang.GString".equals(TypesUtil.getQualifiedName(type2)) && "java.lang.String".equals(TypesUtil.getQualifiedName(type1))) {
                return type1;
            }
        }
        return GenericsUtil.getLeastUpperBound((PsiType)type1, (PsiType)type2, (PsiManager)manager);
    }

    @Nullable
    private static PsiType getNumericLUB(@Nullable PsiType type1, @Nullable PsiType type2) {
        PsiPrimitiveType unboxedType1 = PsiPrimitiveType.getOptionallyUnboxedType((PsiType)type1);
        PsiPrimitiveType unboxedType2 = PsiPrimitiveType.getOptionallyUnboxedType((PsiType)type2);
        if (unboxedType1 != null && unboxedType2 != null) {
            int i1 = LUB_NUMERIC_TYPES.indexOf(unboxedType1);
            int i2 = LUB_NUMERIC_TYPES.indexOf(unboxedType2);
            if (i1 >= 0 && i2 >= 0) {
                return i1 > i2 ? type1 : type2;
            }
        }
        return null;
    }

    private static boolean checkEmptyListAndList(PsiType type1, PsiType type2) {
        List<PsiType> types;
        return type1 instanceof GrTupleType && (types = ((GrTupleType)type1).getComponentTypes()).isEmpty() && InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.List");
    }

    private static PsiType genNewListBy(PsiType genericOwner, @NotNull PsiManager manager) {
        PsiClass list = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.util.List", genericOwner.getResolveScope());
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        if (list == null) {
            return factory.createTypeFromText("java.util.List", null);
        }
        return factory.createType(list, PsiUtil.extractIterableTypeParameter((PsiType)genericOwner, (boolean)false));
    }

    private static boolean checkEmptyMapAndMap(PsiType type1, PsiType type2) {
        return type1 instanceof GrMapType && ((GrMapType)type1).isEmpty() && InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map");
    }

    private static PsiType genNewMapBy(PsiType genericOwner, PsiManager manager) {
        PsiClass map2 = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.util.Map", genericOwner.getResolveScope());
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        if (map2 == null) {
            return factory.createTypeFromText("java.util.Map", null);
        }
        PsiType key = PsiUtil.substituteTypeParameter((PsiType)genericOwner, (String)"java.util.Map", (int)0, (boolean)false);
        PsiType value = PsiUtil.substituteTypeParameter((PsiType)genericOwner, (String)"java.util.Map", (int)1, (boolean)false);
        return factory.createType(map2, new PsiType[]{key, value});
    }

    @Nullable
    public static PsiType getPsiType(PsiElement context, IElementType elemType) {
        if (elemType == GroovyTokenTypes.kNULL) {
            return PsiType.NULL;
        }
        String typeName = TypesUtil.getBoxedTypeName(elemType);
        if (typeName != null) {
            return TypesUtil.createTypeByFQClassName(typeName, context);
        }
        return null;
    }

    @Nullable
    public static String getBoxedTypeName(IElementType elemType) {
        return ourPrimitiveTypesToClassNames.get(elemType);
    }

    @NotNull
    public static PsiType getLeastUpperBound(PsiType[] classes2, PsiManager manager) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        if (classes2.length == 0) {
            return factory.createTypeByFQClassName("java.lang.Object");
        }
        PsiType type2 = classes2[0];
        for (int i = 1; i < classes2.length; ++i) {
            PsiType t = TypesUtil.getLeastUpperBound(type2, classes2[i], manager);
            if (t == null) continue;
            type2 = t;
        }
        return type2;
    }

    @Contract(value="null, _ -> false")
    public static boolean isClassType(@Nullable PsiType type2, @NotNull String qName) {
        return qName.equals(TypesUtil.getQualifiedName(type2));
    }

    @Contract(value="null, _ -> false")
    public static boolean isClassType(@Nullable PsiType type2, String ... names) {
        String fqn = TypesUtil.getQualifiedName(type2);
        if (fqn == null) {
            return false;
        }
        return ContainerUtil.or((Object[])names, it -> it.equals(fqn));
    }

    public static PsiSubstitutor composeSubstitutors(PsiSubstitutor s1, PsiSubstitutor s2) {
        Map map2 = s1.getSubstitutionMap();
        THashMap result2 = new THashMap(map2.size());
        for (PsiTypeParameter parameter : map2.keySet()) {
            result2.put(parameter, s2.substitute((PsiType)map2.get(parameter)));
        }
        Map map22 = s2.getSubstitutionMap();
        for (PsiTypeParameter parameter : map22.keySet()) {
            if (result2.containsKey(parameter)) continue;
            result2.put(parameter, map22.get(parameter));
        }
        return PsiSubstitutor.createSubstitutor((Map)result2);
    }

    @NotNull
    public static PsiClassType createTypeByFQClassName(@NotNull String fqName, @NotNull PsiElement context) {
        return GroovyPsiManager.getInstance(context.getProject()).createTypeByFQClassName(fqName, context.getResolveScope());
    }

    @Nullable
    public static PsiType createJavaLangClassType(@Nullable PsiType type2, @NotNull PsiElement context) {
        return TypesUtil.createJavaLangClassType(type2, context.getProject(), context.getResolveScope());
    }

    @Nullable
    public static PsiType createJavaLangClassType(@Nullable PsiType type2, Project project, GlobalSearchScope resolveScope) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClassType result2 = null;
        PsiClass javaLangClass = facade.findClass("java.lang.Class", resolveScope);
        if (javaLangClass != null) {
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            PsiTypeParameter[] typeParameters = javaLangClass.getTypeParameters();
            if (typeParameters.length == 1) {
                substitutor = substitutor.put(typeParameters[0], type2);
            }
            result2 = facade.getElementFactory().createType(javaLangClass, substitutor);
        }
        return result2;
    }

    @NotNull
    public static PsiPrimitiveType getPrimitiveTypeByText(String typeText) {
        for (PsiPrimitiveType primitive : PRIMITIVES) {
            if (PsiType.VOID.equals((Object)primitive)) {
                return primitive;
            }
            if (!primitive.getCanonicalText().equals(typeText)) continue;
            return primitive;
        }
        assert (false) : "Unknown primitive type";
        return null;
    }

    @NotNull
    public static PsiClassType createGenericType(@NotNull String fqn, @NotNull PsiElement context, @Nullable PsiType type2) {
        GlobalSearchScope resolveScope;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)context.getProject());
        PsiClass clazz = facade.findClass(fqn, resolveScope = context.getResolveScope());
        if (clazz == null || clazz.getTypeParameters().length != 1) {
            return facade.getElementFactory().createTypeByFQClassName(fqn, resolveScope);
        }
        return type2 == null ? facade.getElementFactory().createType(clazz) : facade.getElementFactory().createType(clazz, type2);
    }

    @NotNull
    public static PsiClassType createIterableType(@NotNull PsiElement context, @Nullable PsiType type2) {
        return TypesUtil.createGenericType("java.lang.Iterable", context, type2);
    }

    @NotNull
    public static PsiClassType createListType(@NotNull PsiElement context, @Nullable PsiType type2) {
        PsiType boxedType = TypesUtil.boxPrimitiveType(type2, context.getManager(), context.getResolveScope());
        return TypesUtil.createGenericType("java.util.List", context, boxedType);
    }

    @NotNull
    public static PsiClassType createListType(@NotNull PsiClass elements) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)elements.getProject());
        return TypesUtil.createGenericType("java.util.List", (PsiElement)elements, (PsiType)facade.getElementFactory().createType(elements));
    }

    @NotNull
    public static PsiType createSetType(@NotNull PsiElement context, @NotNull PsiType type2) {
        return TypesUtil.createGenericType("java.util.Set", context, type2);
    }

    public static boolean isAnnotatedCheckHierarchyWithCache(@NotNull PsiClass aClass, @NotNull String annotationFQN) {
        Map<String, PsiClass> classMap = ClassUtil.getSuperClassesWithCache(aClass);
        for (PsiClass psiClass : classMap.values()) {
            PsiModifierList modifierList = psiClass.getModifierList();
            if (modifierList == null || !modifierList.hasAnnotation(annotationFQN)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiType substituteAndNormalizeType(@Nullable PsiType type2, @NotNull PsiSubstitutor substitutor, @Nullable SpreadState state, @NotNull GrExpression expression) {
        if (type2 == null) {
            return null;
        }
        if ((type2 = substitutor.substitute(type2)) == null) {
            return null;
        }
        type2 = PsiImplUtil.normalizeWildcardTypeByPosition(type2, expression);
        type2 = SpreadState.apply(type2, state, expression.getProject());
        return type2;
    }

    @Nullable
    public static PsiType getItemType(@Nullable PsiType containerType) {
        if (containerType == null) {
            return null;
        }
        if (containerType instanceof PsiArrayType) {
            return ((PsiArrayType)containerType).getComponentType();
        }
        return PsiUtil.extractIterableTypeParameter((PsiType)containerType, (boolean)false);
    }

    @Nullable
    public static PsiType inferAnnotationMemberValueType(GrAnnotationMemberValue value) {
        if (value instanceof GrExpression) {
            return ((GrExpression)value).getType();
        }
        if (value instanceof GrAnnotation) {
            PsiElement resolved = ((GrAnnotation)value).getClassReference().resolve();
            if (resolved instanceof PsiClass) {
                return JavaPsiFacade.getElementFactory((Project)value.getProject()).createType((PsiClass)resolved, PsiSubstitutor.EMPTY);
            }
            return null;
        }
        if (value instanceof GrAnnotationArrayInitializer) {
            return TypesUtil.getTupleByAnnotationArrayInitializer((GrAnnotationArrayInitializer)value);
        }
        return null;
    }

    public static PsiType getTupleByAnnotationArrayInitializer(final GrAnnotationArrayInitializer value) {
        return new GrTupleType(value.getResolveScope(), JavaPsiFacade.getInstance((Project)value.getProject())){

            @Override
            @NotNull
            protected List<PsiType> inferComponents() {
                Object[] initializers = value.getInitializers();
                return ContainerUtil.map((Object[])initializers, TypesUtil::inferAnnotationMemberValueType);
            }

            public boolean isValid() {
                return value.isValid();
            }
        };
    }

    public static boolean resolvesTo(PsiType type2, String fqn) {
        if (type2 instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)type2).resolve();
            return resolved != null && fqn.equals(resolved.getQualifiedName());
        }
        return false;
    }

    @Nullable
    public static PsiType rawSecondGeneric(PsiType type2, Project project) {
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        PsiClassType.ClassResolveResult result2 = ((PsiClassType)type2).resolveGenerics();
        PsiClass element = result2.getElement();
        if (element == null) {
            return null;
        }
        PsiType[] parameters2 = ((PsiClassType)type2).getParameters();
        boolean changed = false;
        PsiType[] newParameters = new PsiType[parameters2.length];
        for (int i = 0; i < parameters2.length; ++i) {
            PsiType parameter = parameters2[i];
            if (parameter == null) continue;
            final Ref newParam = new Ref();
            parameter.accept((PsiTypeVisitor)new PsiTypeVisitorEx<Object>(){

                @Nullable
                public Object visitClassType(@NotNull PsiClassType classType) {
                    newParam.set((Object)classType.rawType());
                    return null;
                }

                @Nullable
                public Object visitCapturedWildcardType(@NotNull PsiCapturedWildcardType capturedWildcardType) {
                    newParam.set((Object)capturedWildcardType.getWildcard().getBound());
                    return null;
                }

                @Nullable
                public Object visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                    newParam.set((Object)wildcardType.getBound());
                    return null;
                }
            });
            if (newParam.isNull()) continue;
            changed = true;
            newParameters[i] = (PsiType)newParam.get();
        }
        if (!changed) {
            return null;
        }
        return JavaPsiFacade.getElementFactory((Project)project).createType(element, newParameters);
    }

    @Nullable
    public static PsiType rawWildcard(PsiType type2, final PsiElement context) {
        GrTypeMapper visitor2 = new GrTypeMapper(context){

            public PsiType visitCapturedWildcardType(@NotNull PsiCapturedWildcardType capturedWildcardType) {
                return TypesUtil.getJavaLangObject(context);
            }

            public PsiType visitWildcardType(@NotNull PsiWildcardType capturedWildcardType) {
                return TypesUtil.getJavaLangObject(context);
            }
        };
        return (PsiType)type2.accept((PsiTypeVisitor)visitor2);
    }

    public static boolean isPsiClassTypeToClosure(PsiType type2) {
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        PsiClass psiClass = ((PsiClassType)type2).resolve();
        if (psiClass == null) {
            return false;
        }
        return "groovy.lang.Closure".equals(psiClass.getQualifiedName());
    }

    @Nullable
    public static String getQualifiedName(@Nullable PsiType type2) {
        if (type2 instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)type2).resolve();
            if (resolved instanceof PsiAnonymousClass) {
                return "anonymous " + TypesUtil.getQualifiedName((PsiType)((PsiAnonymousClass)resolved).getBaseClassType());
            }
            if (resolved != null) {
                return resolved.getQualifiedName();
            }
            return PsiNameHelper.getQualifiedClassName((String)type2.getCanonicalText(), (boolean)true);
        }
        return null;
    }

    public static boolean isEnum(PsiType type2) {
        if (type2 instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)type2).resolve();
            return resolved != null && resolved.isEnum();
        }
        return false;
    }

    static {
        ourPrimitiveTypesToClassNames.put(GroovyElementTypes.STRING_SQ, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyElementTypes.STRING_TSQ, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyElementTypes.STRING_DQ, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyElementTypes.STRING_TDQ, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mREGEX_LITERAL, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL, "java.lang.String");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_INT, "java.lang.Integer");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_LONG, "java.lang.Long");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_FLOAT, "java.lang.Float");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_DOUBLE, "java.lang.Double");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_BIG_INT, "java.math.BigInteger");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.mNUM_BIG_DECIMAL, "java.math.BigDecimal");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kFALSE, "java.lang.Boolean");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kTRUE, "java.lang.Boolean");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kNULL, NULL);
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kINT, "java.lang.Integer");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kLONG, "java.lang.Long");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kFLOAT, "java.lang.Float");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kDOUBLE, "java.lang.Double");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kBOOLEAN, "java.lang.Boolean");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kCHAR, "java.lang.Character");
        ourPrimitiveTypesToClassNames.put(GroovyTokenTypes.kBYTE, "java.lang.Byte");
        TYPE_TO_RANK = new TObjectIntHashMap();
        TYPE_TO_RANK.put((Object)"java.lang.Byte", 1);
        TYPE_TO_RANK.put((Object)"java.lang.Character", 2);
        TYPE_TO_RANK.put((Object)"java.lang.Short", 3);
        TYPE_TO_RANK.put((Object)"java.lang.Integer", 4);
        TYPE_TO_RANK.put((Object)"java.lang.Long", 5);
        TYPE_TO_RANK.put((Object)"java.math.BigInteger", 6);
        TYPE_TO_RANK.put((Object)"java.math.BigDecimal", 7);
        TYPE_TO_RANK.put((Object)"java.lang.Float", 8);
        TYPE_TO_RANK.put((Object)"java.lang.Double", 9);
        TYPE_TO_RANK.put((Object)"java.lang.Number", 10);
        RANK_TO_TYPE = new TIntObjectHashMap();
        TYPE_TO_RANK.forEachEntry((fqn, rank) -> {
            RANK_TO_TYPE.put(rank, fqn);
            return true;
        });
        LUB_NUMERIC_TYPES = ContainerUtil.newArrayList((Object[])new PsiType[]{PsiType.BYTE, PsiType.SHORT, PsiType.INT, PsiType.LONG, PsiType.FLOAT, PsiType.DOUBLE});
    }
}

