/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GrSuperReferenceResolver {
    @Nullable(value="null if ref is not 'super' reference")
    public static @Nullable(value="null if ref is not 'super' reference") Collection<GroovyResolveResult> resolveSuperExpression(@NotNull GrReferenceExpression ref) {
        GroovyResolveResult result2;
        PsiElement resolved;
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        if (qualifier == null) {
            PsiClass aClass = PsiUtil.getContextClass(ref);
            if (aClass != null) {
                return GrSuperReferenceResolver.getSuperClass(aClass);
            }
        } else if (qualifier instanceof GrReferenceExpression && (resolved = (result2 = ((GrReferenceExpression)qualifier).advancedResolve()).getElement()) instanceof PsiClass) {
            PsiClass superClass = (PsiClass)resolved;
            GrTypeDefinition scopeClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)ref, GrTypeDefinition.class, (boolean)true);
            if (scopeClass != null && GrTraitUtil.isTrait(superClass) && scopeClass.isInheritor(superClass, false)) {
                PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)scopeClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                return Collections.singletonList(new GroovyResolveResultImpl((PsiElement)superClass, null, null, superClassSubstitutor, true, true));
            }
            if (PsiUtil.hasEnclosingInstanceInScope(superClass, ref, false)) {
                return GrSuperReferenceResolver.getSuperClass(superClass);
            }
        }
        return null;
    }

    @NotNull
    private static Collection<GroovyResolveResult> getSuperClass(@NotNull PsiClass aClass) {
        PsiClass superClass = aClass.getSuperClass();
        if (superClass != null) {
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            return Collections.singletonList(new GroovyResolveResultImpl((PsiElement)superClass, null, null, superClassSubstitutor, true, true));
        }
        return Collections.emptyList();
    }
}

