/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.psi.PsiManager;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;

class TypeDfaState {
    private final Map<VariableDescriptor, DFAType> myVarTypes;

    TypeDfaState() {
        this.myVarTypes = new HashMap<VariableDescriptor, DFAType>();
    }

    TypeDfaState(TypeDfaState another) {
        this.myVarTypes = new HashMap<VariableDescriptor, DFAType>(another.myVarTypes);
    }

    Map<VariableDescriptor, DFAType> getVarTypes() {
        return this.myVarTypes;
    }

    TypeDfaState mergeWith(TypeDfaState another) {
        if (another.myVarTypes.isEmpty()) {
            return this;
        }
        TypeDfaState state = new TypeDfaState(this);
        state.myVarTypes.putAll(another.myVarTypes);
        return state;
    }

    void joinState(TypeDfaState another, PsiManager manager) {
        for (Map.Entry<VariableDescriptor, DFAType> entry : another.myVarTypes.entrySet()) {
            VariableDescriptor descriptor = entry.getKey();
            DFAType t1 = entry.getValue();
            if (!this.myVarTypes.containsKey(descriptor)) continue;
            DFAType t2 = this.myVarTypes.get(descriptor);
            if (t1 != null && t2 != null) {
                this.myVarTypes.put(descriptor, DFAType.create(t1, t2, manager));
                continue;
            }
            this.myVarTypes.put(descriptor, null);
        }
    }

    boolean contentsEqual(TypeDfaState another) {
        return this.myVarTypes.equals(another.myVarTypes);
    }

    @Nullable
    DFAType getVariableType(VariableDescriptor descriptor) {
        return this.myVarTypes.get(descriptor);
    }

    @Contract(value="_ -> new")
    @NotNull
    DFAType getOrCreateVariableType(VariableDescriptor descriptor) {
        DFAType result2 = this.getVariableType(descriptor);
        return result2 == null ? DFAType.create(null) : result2.copy();
    }

    Map<VariableDescriptor, DFAType> getBindings() {
        return new HashMap<VariableDescriptor, DFAType>(this.myVarTypes);
    }

    void putType(VariableDescriptor descriptor, @Nullable DFAType type2) {
        this.myVarTypes.put(descriptor, type2);
    }

    public String toString() {
        return this.myVarTypes.toString();
    }

    public boolean containsVariable(@NotNull VariableDescriptor descriptor) {
        return this.myVarTypes.containsKey(descriptor);
    }

    public void removeBinding(VariableDescriptor descriptor) {
        this.myVarTypes.remove(descriptor);
    }
}

