/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.LazyKt;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.Lazy;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.MixinTypeInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.UtilKt;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.DefinitionMap;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.InitialTypeProvider;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaState;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypesSemilattice;
import org.jetbrains.plugins.groovy.util.GraphKt;

class InferenceCache {
    private final GrControlFlowOwner myScope;
    private final Instruction[] myFlow;
    private final Map<PsiElement, List<Instruction>> myFromByElements;
    private final Lazy<TObjectIntHashMap<VariableDescriptor>> myVarIndexes;
    private final Lazy<List<DefinitionMap>> myDefinitionMaps;
    private final AtomicReference<List<TypeDfaState>> myVarTypes;
    private final Set<Instruction> myTooComplexInstructions = ContainerUtil.newConcurrentSet();

    InferenceCache(@NotNull GrControlFlowOwner scope) {
        this.myScope = scope;
        this.myFlow = scope.getControlFlow();
        this.myVarIndexes = LazyKt.lazyPub(() -> UtilKt.getVarIndexes(this.myScope));
        this.myDefinitionMaps = LazyKt.lazyPub(() -> TypeInferenceHelper.getDefUseMaps(this.myFlow, (TObjectIntHashMap<VariableDescriptor>)((TObjectIntHashMap)this.myVarIndexes.getValue())));
        this.myFromByElements = Arrays.stream(this.myFlow).filter(it -> it.getElement() != null).collect(Collectors.groupingBy(Instruction::getElement));
        ArrayList<TypeDfaState> noTypes = new ArrayList<TypeDfaState>();
        for (int i = 0; i < this.myFlow.length; ++i) {
            noTypes.add(new TypeDfaState());
        }
        this.myVarTypes = new AtomicReference(noTypes);
    }

    boolean isTooComplexToAnalyze() {
        return this.myDefinitionMaps.getValue() == null;
    }

    @Nullable
    PsiType getInferredType(@NotNull VariableDescriptor descriptor, @NotNull Instruction instruction, boolean mixinOnly) {
        DFAType dfaType;
        if (this.myTooComplexInstructions.contains(instruction)) {
            return null;
        }
        List definitionMaps = (List)this.myDefinitionMaps.getValue();
        if (definitionMaps == null) {
            return null;
        }
        TypeDfaState cache2 = this.myVarTypes.get().get(instruction.num());
        if (!cache2.containsVariable(descriptor)) {
            Predicate<Instruction> mixinPredicate = mixinOnly ? e -> e instanceof MixinTypeInstruction : e -> true;
            Couple<Set<Instruction>> interesting = this.collectRequiredInstructions(definitionMaps, instruction, descriptor, mixinPredicate);
            List<TypeDfaState> dfaResult = this.performTypeDfa(this.myScope, this.myFlow, interesting);
            if (dfaResult == null) {
                this.myTooComplexInstructions.addAll((Collection)interesting.first);
            } else {
                Set stored = (Set)interesting.first;
                stored.add(instruction);
                this.cacheDfaResult(dfaResult, stored);
            }
        }
        return (dfaType = this.getCachedInferredType(descriptor, instruction)) == null ? null : dfaType.getResultType();
    }

    @Nullable
    private List<TypeDfaState> performTypeDfa(@NotNull GrControlFlowOwner owner, Instruction @NotNull [] flow, @NotNull Couple<Set<Instruction>> interesting) {
        TypeDfaInstance dfaInstance = new TypeDfaInstance(flow, interesting, this, new InitialTypeProvider(owner));
        TypesSemilattice semilattice = new TypesSemilattice(owner.getManager());
        return new DFAEngine<TypeDfaState>(flow, dfaInstance, semilattice).performDFAWithTimeout();
    }

    @Nullable
    DFAType getCachedInferredType(@NotNull VariableDescriptor descriptor, @NotNull Instruction instruction) {
        return this.myVarTypes.get().get(instruction.num()).getVariableType(descriptor);
    }

    private Couple<Set<Instruction>> collectRequiredInstructions(@NotNull List<DefinitionMap> definitionMaps, @NotNull Instruction instruction, @NotNull VariableDescriptor descriptor, @NotNull Predicate<? super Instruction> predicate2) {
        LinkedHashMap<Pair, Set<Pair<Instruction, VariableDescriptor>>> interesting = new LinkedHashMap<Pair, Set<Pair<Instruction, VariableDescriptor>>>();
        LinkedList<Pair> queue = new LinkedList<Pair>();
        queue.add(Pair.create((Object)instruction, (Object)descriptor));
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.removeFirst();
            if (interesting.containsKey(pair)) continue;
            Set<Pair<Instruction, VariableDescriptor>> dependencies = this.findDependencies(definitionMaps, (Instruction)pair.first, (VariableDescriptor)pair.second);
            interesting.put(pair, dependencies);
            dependencies.forEach(queue::addLast);
        }
        Set interestingInstructions = interesting.keySet().stream().map(it -> (Instruction)it.getFirst()).filter(predicate2).collect(Collectors.toSet());
        Set acyclicInstructions = GraphKt.findNodesOutsideCycles(GraphKt.mapGraph(interesting)).stream().map(it -> (Instruction)it.getFirst()).filter(predicate2).collect(Collectors.toSet());
        return Couple.of(interestingInstructions, acyclicInstructions);
    }

    @NotNull
    private Set<Pair<Instruction, VariableDescriptor>> findDependencies(@NotNull List<DefinitionMap> definitionMaps, @NotNull Instruction instruction, @NotNull VariableDescriptor descriptor) {
        int varIndex;
        DefinitionMap definitionMap = definitionMaps.get(instruction.num());
        int[] definitions = definitionMap.getDefinitions(varIndex = ((TObjectIntHashMap)this.myVarIndexes.getValue()).get((Object)descriptor));
        if (definitions == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Pair<Instruction, VariableDescriptor>> pairs = new LinkedHashSet<Pair<Instruction, VariableDescriptor>>();
        for (int defIndex : definitions) {
            Instruction write = this.myFlow[defIndex];
            if (write != instruction) {
                pairs.add((Pair<Instruction, VariableDescriptor>)Pair.create((Object)write, (Object)descriptor));
            }
            for (ReadWriteVariableInstruction dependency : UtilKt.findReadDependencies(write, (Function1<? super PsiElement, ? extends Collection<? extends Instruction>>)((Function1)it -> this.myFromByElements.getOrDefault(it, Collections.emptyList())))) {
                pairs.add((Pair<Instruction, VariableDescriptor>)Pair.create((Object)dependency, (Object)dependency.getDescriptor()));
            }
        }
        return pairs;
    }

    private void cacheDfaResult(@NotNull List<TypeDfaState> dfaResult, Set<Instruction> storingInstructions) {
        this.myVarTypes.accumulateAndGet(dfaResult, (oldState, newState) -> InferenceCache.addDfaResult(oldState, newState, storingInstructions));
    }

    @NotNull
    private static List<TypeDfaState> addDfaResult(@NotNull List<TypeDfaState> oldTypes, @NotNull List<TypeDfaState> dfaResult, @NotNull Set<Instruction> storingInstructions) {
        ArrayList<TypeDfaState> newTypes = new ArrayList<TypeDfaState>(oldTypes);
        Set interestingInstructionNums = storingInstructions.stream().map(Instruction::num).collect(Collectors.toSet());
        for (int i = 0; i < dfaResult.size(); ++i) {
            if (!interestingInstructionNums.contains(i)) continue;
            newTypes.set(i, ((TypeDfaState)newTypes.get(i)).mergeWith(dfaResult.get(i)));
        }
        return newTypes;
    }
}

