/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow;

import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallEnvironment;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReturnInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.InstructionImpl;

public class AfterCallInstruction
extends InstructionImpl {
    public final CallInstruction myCall;
    private ReturnInstruction myReturnInstruction;

    public AfterCallInstruction(CallInstruction call) {
        super(null);
        this.myCall = call;
    }

    @Override
    public String toString() {
        return super.toString() + "AFTER CALL " + this.myCall.num();
    }

    @Override
    @NotNull
    public Iterable<Instruction> allPredecessors() {
        return Collections.singletonList(this.myReturnInstruction);
    }

    @Override
    @NotNull
    public Iterable<Instruction> predecessors(@NotNull CallEnvironment environment) {
        environment.callStack(this.myReturnInstruction).push(this.myCall);
        return Collections.singletonList(this.myReturnInstruction);
    }

    @Override
    @NotNull
    protected String getElementPresentation() {
        return "";
    }

    public void setReturnInstruction(ReturnInstruction returnInstruction) {
        this.myReturnInstruction = returnInstruction;
    }
}

