/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocElementType;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocLexer;
import org.jetbrains.plugins.groovy.lang.groovydoc.parser.GroovyDocParser;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentImpl;

public interface GroovyDocElementTypes {
    public static final ILazyParseableElementType GROOVY_DOC_COMMENT = new ILazyParseableElementType("GrDocComment"){

        @NotNull
        public Language getLanguage() {
            return GroovyLanguage.INSTANCE;
        }

        public ASTNode parseContents(@NotNull ASTNode chameleon) {
            PsiElement parentElement = chameleon.getTreeParent().getPsi();
            Project project = JavaPsiFacade.getInstance((Project)parentElement.getProject()).getProject();
            PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, (Lexer)new GroovyDocLexer(), this.getLanguage(), (CharSequence)chameleon.getText());
            GroovyDocParser parser = new GroovyDocParser();
            return parser.parse((IElementType)this, builder).getFirstChildNode();
        }

        public ASTNode createNode(CharSequence text) {
            return new GrDocCommentImpl(text);
        }
    };
    public static final GroovyDocElementType GDOC_TAG = new GroovyDocElementType("GroovyDocTag");
    public static final GroovyDocElementType GDOC_INLINED_TAG = new GroovyDocElementType("GroovyDocInlinedTag");
    public static final GroovyDocElementType GDOC_REFERENCE_ELEMENT = new GroovyDocElementType("GroovyDocReferenceElement");
    public static final GroovyDocElementType GDOC_PARAM_REF = new GroovyDocElementType("GroovyDocParameterReference");
    public static final GroovyDocElementType GDOC_METHOD_REF = new GroovyDocElementType("GroovyDocMethodReference");
    public static final GroovyDocElementType GDOC_FIELD_REF = new GroovyDocElementType("GroovyDocFieldReference");
    public static final GroovyDocElementType GDOC_METHOD_PARAMS = new GroovyDocElementType("GroovyDocMethodParameterList");
    public static final GroovyDocElementType GDOC_METHOD_PARAMETER = new GroovyDocElementType("GroovyDocMethodParameter");
}

