/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.weighers;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.completion.GrMainCompletionProvider;
import org.jetbrains.plugins.groovy.lang.completion.GrPropertyForCompletion;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation.GrAnnotationImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class GrKindWeigher
extends CompletionWeigher {
    private static final Set<String> TRASH_CLASSES = new HashSet<String>(10);
    private static final Set<String> PRIORITY_KEYWORDS = ContainerUtil.newHashSet((Object[])new String[]{"return", "instanceof", "in", "private", "protected", "public", "static", "def", "true", "false", "null"});

    public Comparable weigh(@NotNull LookupElement element, @NotNull CompletionLocation location) {
        PsiElement parent2;
        PsiElement qualifier;
        PsiElement position = location.getCompletionParameters().getPosition();
        if (!(position.getContainingFile() instanceof GroovyFileBase)) {
            return null;
        }
        Object o = element.getObject();
        if (o instanceof ResolveResult) {
            o = ((ResolveResult)o).getElement();
        }
        PsiElement psiElement = qualifier = (parent2 = position.getParent()) instanceof GrReferenceElement ? ((GrReferenceElement)parent2).getQualifier() : null;
        if (qualifier == null) {
            if (o instanceof NamedArgumentDescriptor) {
                switch (((NamedArgumentDescriptor)o).getPriority()) {
                    case ALWAYS_ON_TOP: {
                        return NotQualifiedKind.onTop;
                    }
                    case AS_LOCAL_VARIABLE: {
                        return NotQualifiedKind.local;
                    }
                }
                return NotQualifiedKind.unknown;
            }
            if (o instanceof PsiVariable && !(o instanceof PsiField)) {
                return NotQualifiedKind.local;
            }
            PsiTypeLookupItem item = (PsiTypeLookupItem)element.as(PsiTypeLookupItem.CLASS_CONDITION_KEY);
            if (item != null && item.getBracketsCount() > 0) {
                return NotQualifiedKind.arrayType;
            }
            if (GrKindWeigher.isPriorityKeyword(o)) {
                return NotQualifiedKind.local;
            }
            if (GrKindWeigher.isLightElement(o)) {
                return NotQualifiedKind.unknown;
            }
            if (o instanceof PsiClass) {
                PsiElement annoParent;
                PsiElement ownerToUse;
                PsiAnnotation.TargetType[] elementTypeFields;
                GrAnnotation annotation;
                if (((PsiClass)o).isAnnotationType() && GrMainCompletionProvider.AFTER_AT.accepts((Object)position) && (annotation = (GrAnnotation)PsiTreeUtil.getParentOfType((PsiElement)position, GrAnnotation.class)) != null && AnnotationTargetUtil.findAnnotationTarget((PsiClass)((PsiClass)o), (PsiAnnotation.TargetType[])(elementTypeFields = GrAnnotationImpl.getApplicableElementTypeFields(ownerToUse = (annoParent = annotation.getParent()) instanceof PsiModifierList ? annoParent.getParent() : annoParent))) != null) {
                    return NotQualifiedKind.restrictedClass;
                }
                if (GrMainCompletionProvider.IN_CATCH_TYPE.accepts((Object)position) && InheritanceUtil.isInheritor((PsiClass)((PsiClass)o), (String)"java.lang.Throwable")) {
                    return NotQualifiedKind.restrictedClass;
                }
            }
            if (o instanceof PsiMember) {
                PsiClass containingClass = ((PsiMember)o).getContainingClass();
                if (GrKindWeigher.isAccessor((PsiMember)o)) {
                    return NotQualifiedKind.accessor;
                }
                if (o instanceof PsiClass && ((PsiClass)o).getContainingClass() == null || o instanceof PsiPackage) {
                    return NotQualifiedKind.unknown;
                }
                if (o instanceof PsiClass) {
                    return NotQualifiedKind.innerClass;
                }
                if (PsiTreeUtil.isContextAncestor((PsiElement)containingClass, (PsiElement)position, (boolean)false)) {
                    return NotQualifiedKind.currentClassMember;
                }
                return NotQualifiedKind.member;
            }
            return NotQualifiedKind.unknown;
        }
        if (o instanceof PsiEnumConstant) {
            return QualifiedKind.enumConstant;
        }
        if (GrKindWeigher.isLightElement(o)) {
            return QualifiedKind.unknown;
        }
        if (o instanceof PsiMember) {
            if (GrKindWeigher.isTrashMethod((PsiMember)o)) {
                return QualifiedKind.unknown;
            }
            if (GrKindWeigher.isAccessor((PsiMember)o)) {
                return QualifiedKind.accessor;
            }
            if (GrKindWeigher.isQualifierClassMember((PsiMember)o, qualifier)) {
                return QualifiedKind.currentClassMember;
            }
            if (o instanceof PsiClass && ((PsiClass)o).getContainingClass() == null || o instanceof PsiPackage) {
                return QualifiedKind.unknown;
            }
            if (o instanceof PsiClass) {
                return QualifiedKind.innerClass;
            }
            return QualifiedKind.member;
        }
        return QualifiedKind.unknown;
    }

    private static boolean isPriorityKeyword(Object o) {
        return PRIORITY_KEYWORDS.contains(o);
    }

    private static boolean isLightElement(Object o) {
        return o instanceof LightElement && !(o instanceof GrPropertyForCompletion) && !(o instanceof GrAccessorMethod);
    }

    private static boolean isTrashMethod(PsiMember o) {
        PsiClass containingClass = o.getContainingClass();
        return containingClass != null && TRASH_CLASSES.contains(containingClass.getQualifiedName());
    }

    private static boolean isAccessor(PsiMember member) {
        return member instanceof PsiMethod && (GroovyPropertyUtils.isSimplePropertyAccessor((PsiMethod)member) || "setProperty".equals(((PsiMethod)member).getName()));
    }

    private static boolean isQualifierClassMember(PsiMember member, PsiElement qualifier) {
        if (!(qualifier instanceof GrExpression)) {
            return false;
        }
        PsiType type2 = ((GrExpression)qualifier).getType();
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        PsiClass psiClass = ((PsiClassType)type2).resolve();
        if (psiClass == null) {
            return false;
        }
        return qualifier.getManager().areElementsEquivalent((PsiElement)member.getContainingClass(), (PsiElement)psiClass);
    }

    static {
        TRASH_CLASSES.add("java.lang.Class");
        TRASH_CLASSES.add("java.lang.Object");
        TRASH_CLASSES.add("groovy.lang.GroovyObjectSupport");
    }

    private static enum QualifiedKind {
        innerClass,
        unknown,
        accessor,
        member,
        currentClassMember,
        enumConstant;

    }

    private static enum NotQualifiedKind {
        arrayType,
        innerClass,
        unknown,
        accessor,
        member,
        currentClassMember,
        restrictedClass,
        local,
        onTop;

    }
}

