/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.ModifierChooser;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.lang.ASTNode;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.completion.GroovySmartCompletionContributor;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocInlinedTag;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GrDoWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.formatter.GrControlStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrInterfaceDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTraitTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAnnotationMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GroovyCompletionData {
    public static final String[] BUILT_IN_TYPES = new String[]{"boolean", "byte", "char", "short", "int", "float", "long", "double", "void"};
    public static final String[] MODIFIERS = new String[]{"private", "public", "protected", "transient", "abstract", "native", "volatile", "strictfp", "static"};
    public static final ElementPattern<PsiElement> IN_CAST_TYPE_ELEMENT = StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("(")).withParent((ElementPattern)PsiJavaPatterns.psiElement((Class[])new Class[]{GrParenthesizedExpression.class, GrTypeCastExpression.class}))), PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withElementType(GroovyTokenTypes.kAS)).withParent(GrSafeCastExpression.class))});
    static final String[] INLINED_DOC_TAGS = new String[]{"code", "docRoot", "inheritDoc", "link", "linkplain", "literal"};
    static final String[] DOC_TAGS = new String[]{"author", "deprecated", "exception", "param", "return", "see", "serial", "serialData", "serialField", "since", "throws", "version"};
    private static final ElementPattern<PsiElement> SKIP_CONDITION = StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().whitespaceCommentEmptyOrError(), PlatformPatterns.psiElement((IElementType)GroovyElementTypes.NL)});
    private static final ElementPattern<PsiElement> WHILE_KEYWORD_POSITION = StandardPatterns.or((ElementPattern[])new ElementPattern[]{((PsiElementPattern.Capture)PlatformPatterns.psiElement().withSuperParent(2, GrDoWhileStatement.class)).afterLeafSkipping(SKIP_CONDITION, (ElementPattern)PlatformPatterns.psiElement((IElementType)GroovyElementTypes.T_RBRACE)), ((PsiElementPattern.Capture)PlatformPatterns.psiElement().withSuperParent(4, GrDoWhileStatement.class)).withSuperParent(3, GrApplicationStatement.class)});

    public static void addGroovyKeywords(CompletionParameters parameters2, CompletionResultSet result2) {
        String[] extendsImplements;
        PsiElement position = parameters2.getPosition();
        PsiElement parent2 = position.getParent();
        if (parent2 instanceof GrLiteral) {
            return;
        }
        for (String keyword : extendsImplements = GroovyCompletionData.addExtendsImplements(position)) {
            result2.addElement(GroovyCompletionData.keyword(keyword, TailType.HUMBLE_SPACE_BEFORE_WORD));
        }
        if (extendsImplements.length > 0) {
            return;
        }
        if (parent2 instanceof GrExpression && parent2.getParent() instanceof GrAnnotationNameValuePair) {
            GroovyCompletionData.addKeywords(result2, false, "true", "false", "null");
            return;
        }
        if (GroovyCompletionData.afterAtInType(position)) {
            result2.addElement(GroovyCompletionData.keyword("interface", TailType.HUMBLE_SPACE_BEFORE_WORD));
        }
        if (!((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf(new String[]{".", ".&", "@", "*.", "?."})).accepts((Object)position)) {
            if (GroovyCompletionData.afterAbstractMethod(position, false, true)) {
                result2.addElement(GroovyCompletionData.keyword("throws", TailType.HUMBLE_SPACE_BEFORE_WORD));
                if (GroovyCompletionData.afterAbstractMethod(position, false, false)) {
                    return;
                }
            }
            if (GroovyCompletionData.suggestPackage(position)) {
                result2.addElement(GroovyCompletionData.keyword("package", TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
            if (GroovyCompletionData.suggestImport(position)) {
                result2.addElement(GroovyCompletionData.keyword("import", TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
            GroovyCompletionData.addTypeDefinitionKeywords(result2, position);
            if (GroovyCompletionData.isAfterAnnotationMethodIdentifier(position)) {
                result2.addElement(GroovyCompletionData.keyword("default", TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
            GroovyCompletionData.addExtendsForTypeParams(position, result2);
            GroovyCompletionData.registerControlCompletion(position, result2);
            if (parent2 instanceof GrExpression || GroovyCompletionData.isInfixOperatorPosition(position)) {
                GroovyCompletionData.addKeywords(result2, false, "true", "false", "null", "super", "this");
                result2.addElement(GroovyCompletionData.keyword("new", TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
            if (GroovyCompletionData.isAfterForParameter(position)) {
                result2.addElement(GroovyCompletionData.keyword("in", TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
            if (GroovyCompletionData.isInfixOperatorPosition(position)) {
                GroovyCompletionData.addKeywords(result2, true, "as", "in", "instanceof");
            }
            if (GroovyCompletionData.suggestPrimitiveTypes(position)) {
                boolean addSpace = !IN_CAST_TYPE_ELEMENT.accepts((Object)position) && !GroovySmartCompletionContributor.AFTER_NEW.accepts((Object)position) && !GroovyCompletionData.isInExpression(position);
                GroovyCompletionData.addKeywords(result2, addSpace, BUILT_IN_TYPES);
            }
            if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(GrReferenceExpression.class).inside(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(GrWhileStatement.class), PsiJavaPatterns.psiElement(GrForStatement.class)}))).accepts((Object)parent2)) {
                GroovyCompletionData.addKeywords(result2, false, "break", "continue");
            } else if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(GrReferenceExpression.class).inside(GrCaseSection.class)).accepts((Object)parent2)) {
                GroovyCompletionData.addKeywords(result2, false, "break");
            }
            if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withSuperParent(2, GrImportStatement.class)).accepts((Object)position)) {
                if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"import"})).accepts((Object)position)) {
                    GroovyCompletionData.addKeywords(result2, true, "static");
                }
            } else {
                if (GroovyCompletionData.suggestModifiers(position)) {
                    GroovyCompletionData.addModifiers(position, result2);
                }
                if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(MODIFIERS)).accepts((Object)position) || GroovyCompletionUtil.isInTypeDefinitionBody(position) && GroovyCompletionUtil.isNewStatement(position, true)) {
                    GroovyCompletionData.addKeywords(result2, true, "synchronized");
                }
                if (GroovyCompletionData.suggestFinalDef(position) || ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("(")).withParent(GrForStatement.class))).accepts((Object)position)) {
                    GroovyCompletionData.addKeywords(result2, true, "final", "def");
                }
            }
        }
    }

    private static boolean isAfterAnnotationMethodIdentifier(@NotNull PsiElement position) {
        GrTypeDefinition containingClass;
        PsiElement parent2 = position.getParent();
        if (parent2 instanceof GrTypeDefinitionBody && (containingClass = (GrTypeDefinition)parent2.getParent()).isAnnotationType()) {
            PsiElement sibling = PsiUtil.skipWhitespacesAndComments(position.getPrevSibling(), false);
            if (sibling instanceof PsiErrorElement) {
                sibling = PsiUtil.skipWhitespacesAndComments(sibling.getPrevSibling(), false);
            }
            return sibling instanceof GrAnnotationMethod && ((GrAnnotationMethod)sibling).getDefaultValue() == null;
        }
        return false;
    }

    private static boolean isInExpression(PsiElement position) {
        PsiElement actual = position.getParent();
        PsiElement parent2 = actual.getParent();
        return parent2 instanceof GrArgumentList || parent2 instanceof GrBinaryExpression;
    }

    private static void addExtendsForTypeParams(PsiElement position, CompletionResultSet result2) {
        if (GroovyCompletionUtil.isWildcardCompletion(position)) {
            GroovyCompletionData.addKeywords(result2, true, "extends", "super");
        }
    }

    private static boolean isAfterForParameter(PsiElement position) {
        TreeElementPattern forParameter = PsiJavaPatterns.psiElement().withParents(new Class[]{GrVariable.class, GrVariableDeclaration.class, GrTraditionalForClause.class, GrForStatement.class});
        return ((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(GrReferenceExpression.class)).afterLeaf((ElementPattern)forParameter)).accepts((Object)position) || forParameter.accepts((Object)position) && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)PsiJavaPatterns.psiElement((IElementType)GroovyTokenTypes.mIDENT))).accepts((Object)position);
    }

    public static void addModifiers(PsiElement position, CompletionResultSet result2) {
        PsiClass scope = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)position, PsiClass.class);
        PsiModifierList modifierList = ModifierChooser.findModifierList((PsiElement)position);
        GroovyCompletionData.addKeywords(result2, true, ModifierChooser.addMemberModifiers((PsiModifierList)modifierList, (scope != null && scope.isInterface() ? 1 : 0) != 0, (PsiElement)position));
    }

    private static void addTypeDefinitionKeywords(CompletionResultSet result2, PsiElement position) {
        if (GroovyCompletionData.suggestClassInterfaceEnum(position)) {
            GroovyCompletionData.addKeywords(result2, true, "class", "interface", "enum", GroovyTokenTypes.kTRAIT.toString());
        }
    }

    private static String @NotNull [] addExtendsImplements(PsiElement context) {
        PsiElement[] children;
        boolean impl;
        if (context.getParent() == null) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        Object elem = context.getParent();
        boolean ext = !(elem instanceof GrExtendsClause);
        boolean bl = impl = !(elem instanceof GrImplementsClause);
        if (elem instanceof GrTypeDefinitionBody) {
            elem = PsiUtil.skipWhitespacesAndComments(context.getPrevSibling(), false);
        } else if (elem instanceof GrReferenceExpression && PsiUtil.skipWhitespacesAndComments(elem.getPrevSibling(), false) instanceof GrTypeDefinition) {
            elem = PsiUtil.skipWhitespacesAndComments(elem.getPrevSibling(), false);
        } else {
            PsiElement parent2 = elem.getParent();
            if (parent2 != null) {
                elem = parent2 instanceof PsiFile ? null : PsiUtil.skipWhitespacesAndComments(parent2.getPrevSibling(), false);
            }
        }
        if (!(ext &= elem instanceof GrInterfaceDefinition || elem instanceof GrClassDefinition || elem instanceof GrTraitTypeDefinition) && !(impl &= elem instanceof GrEnumTypeDefinition || elem instanceof GrClassDefinition || elem instanceof GrTraitTypeDefinition)) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        for (PsiElement child : children = elem.getChildren()) {
            ext &= !(child instanceof GrExtendsClause) || ((GrExtendsClause)child).getKeyword() == null;
            if ((!(child instanceof GrImplementsClause) || ((GrImplementsClause)child).getKeyword() == null) && !(child instanceof GrTypeDefinitionBody)) continue;
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        if (ext && impl) {
            return new String[]{"extends", "implements"};
        }
        return new String[]{ext ? "extends" : "implements"};
    }

    public static void addKeywords(CompletionResultSet result2, boolean space, String ... keywords) {
        for (String s : keywords) {
            result2.addElement(GroovyCompletionData.keyword(s, space ? TailType.HUMBLE_SPACE_BEFORE_WORD : TailType.NONE));
        }
    }

    private static LookupElement keyword(String keyword, @NotNull TailType tail) {
        LookupElementBuilder element = LookupElementBuilder.create((String)keyword).bold();
        return tail != TailType.NONE ? new JavaKeywordCompletion.OverridableSpace((LookupElement)element, tail) : element;
    }

    private static void registerControlCompletion(PsiElement context, CompletionResultSet result2) {
        if (GroovyCompletionData.isControlStructure(context)) {
            result2.addElement(GroovyCompletionData.keyword("try", TailTypes.TRY_LBRACE));
            result2.addElement(GroovyCompletionData.keyword("while", TailTypes.WHILE_LPARENTH));
            result2.addElement(GroovyCompletionData.keyword("switch", TailTypes.SWITCH_LPARENTH));
            result2.addElement(GroovyCompletionData.keyword("for", TailTypes.FOR_LPARENTH));
            result2.addElement(GroovyCompletionData.keyword("throw", TailType.HUMBLE_SPACE_BEFORE_WORD));
            result2.addElement(GroovyCompletionData.keyword("assert", TailType.HUMBLE_SPACE_BEFORE_WORD));
            result2.addElement(GroovyCompletionData.keyword("synchronized", TailTypes.SYNCHRONIZED_LPARENTH));
            result2.addElement(GroovyCompletionData.keyword("return", GroovyCompletionData.hasReturnValue(context) ? TailType.HUMBLE_SPACE_BEFORE_WORD : TailType.NONE));
        }
        if (GroovyCompletionData.inCaseSection(context)) {
            result2.addElement(GroovyCompletionData.keyword("case", TailType.HUMBLE_SPACE_BEFORE_WORD));
            result2.addElement(GroovyCompletionData.keyword("default", TailType.CASE_COLON));
        }
        if (GroovyCompletionData.afterTry(context)) {
            result2.addElement(GroovyCompletionData.keyword("catch", TailTypes.CATCH_LPARENTH));
            result2.addElement(GroovyCompletionData.keyword("finally", TailTypes.FINALLY_LBRACE));
        }
        if (GroovyCompletionData.afterIfOrElse(context)) {
            result2.addElement(GroovyCompletionData.keyword("else", TailType.HUMBLE_SPACE_BEFORE_WORD));
        }
        if (WHILE_KEYWORD_POSITION.accepts((Object)context)) {
            result2.addElement(GroovyCompletionData.keyword("while", TailTypes.WHILE_LPARENTH));
        }
        if (GroovyCompletionData.isCommandCallWithOneArg(context)) {
            result2.addElement(GroovyCompletionData.keyword("assert", TailType.HUMBLE_SPACE_BEFORE_WORD));
            if (GroovyCompletionData.hasReturnValue(context)) {
                result2.addElement(GroovyCompletionData.keyword("return", TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
        }
    }

    private static boolean isCommandCallWithOneArg(PsiElement context) {
        return context.getParent() instanceof GrReferenceExpression && context.getParent().getParent() instanceof GrApplicationStatement && ((GrApplicationStatement)context.getParent().getParent()).getExpressionArguments().length == 1 && !PsiImplUtil.hasNamedArguments(((GrApplicationStatement)context.getParent().getParent()).getArgumentList());
    }

    private static boolean hasReturnValue(PsiElement context) {
        GrControlFlowOwner flowOwner = ControlFlowUtils.findControlFlowOwner(context);
        if (flowOwner instanceof GrClosableBlock) {
            return true;
        }
        if (flowOwner instanceof GroovyFile) {
            return true;
        }
        if (flowOwner == null) {
            return true;
        }
        PsiElement parent2 = flowOwner.getParent();
        if (parent2 instanceof GrMethod) {
            return !PsiType.VOID.equals((Object)((GrMethod)parent2).getReturnType());
        }
        return !(parent2 instanceof GrClassInitializer);
    }

    public static void addGroovyDocKeywords(CompletionParameters parameters2, CompletionResultSet result2) {
        PsiElement position = parameters2.getPosition();
        if (((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)GroovyDocTokenTypes.mGDOC_TAG_NAME).andNot((ElementPattern)PlatformPatterns.psiElement().afterLeaf(new String[]{"."}))).accepts((Object)position)) {
            String[] tags;
            for (String docTag : tags = position.getParent() instanceof GrDocInlinedTag ? INLINED_DOC_TAGS : DOC_TAGS) {
                result2.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)docTag), (TailType)TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
        }
    }

    private static boolean suggestPackage(PsiElement context) {
        GroovyFile groovyFile;
        PsiElement parent2;
        if (context.getParent() != null && !(context.getParent() instanceof PsiErrorElement) && context.getParent().getParent() instanceof GroovyFile && ((GroovyFile)context.getParent().getParent()).getPackageDefinition() == null) {
            if (context.getParent() instanceof GrReferenceExpression) {
                return true;
            }
            return context.getParent() instanceof GrApplicationStatement && ((GrApplicationStatement)context.getParent()).getExpressionArguments()[0] instanceof GrReferenceExpression;
        }
        if (context.getTextRange().getStartOffset() == 0 && !(context instanceof OuterLanguageElement)) {
            return true;
        }
        PsiElement leaf = GroovyCompletionUtil.getLeafByOffset(context.getTextRange().getStartOffset() - 1, context);
        if (leaf != null && (parent2 = leaf.getParent()) instanceof GroovyFile && (groovyFile = (GroovyFile)parent2).getPackageDefinition() == null) {
            return GroovyCompletionUtil.isNewStatement(context, false);
        }
        return false;
    }

    private static boolean suggestImport(PsiElement context) {
        PsiElement parent2;
        if (context.getParent() != null && !(context.getParent() instanceof PsiErrorElement) && GroovyCompletionUtil.isNewStatement(context, false) && context.getParent().getParent() instanceof GroovyFile) {
            return true;
        }
        PsiElement leaf = GroovyCompletionUtil.getLeafByOffset(context.getTextRange().getStartOffset() - 1, context);
        if (leaf != null && (parent2 = leaf.getParent()) instanceof GroovyFile) {
            return GroovyCompletionUtil.isNewStatement(context, false);
        }
        return context.getTextRange().getStartOffset() == 0 && !(context instanceof OuterLanguageElement);
    }

    public static boolean suggestClassInterfaceEnum(PsiElement context) {
        PsiElement decl;
        PsiElement nextNonSpace = PsiUtil.getNextNonSpace(context);
        if (nextNonSpace instanceof PsiErrorElement) {
            nextNonSpace = PsiUtil.getNextNonSpace(nextNonSpace);
        }
        if (GroovyCompletionData.afterAbstractMethod(context, true, false) && nextNonSpace != null && nextNonSpace.getText().startsWith("{") || GroovyCompletionData.addExtendsImplements(context).length > 0) {
            return false;
        }
        PsiElement parent2 = context.getParent();
        if (parent2 instanceof GrTypeDefinitionBody) {
            return true;
        }
        if (parent2 instanceof GrReferenceExpression) {
            if (parent2.getParent() instanceof GroovyFile) {
                return true;
            }
            if ((parent2.getParent() instanceof GrApplicationStatement || parent2.getParent() instanceof GrCall) && parent2.getParent().getParent() instanceof GroovyFile) {
                return true;
            }
        }
        if (parent2 instanceof GrVariable && context == ((GrVariable)parent2).getNameIdentifierGroovy() && (decl = parent2.getParent()) instanceof GrVariableDeclaration && !((GrVariableDeclaration)decl).isTuple() && ((GrVariableDeclaration)decl).getTypeElementGroovy() == null && (decl.getParent() instanceof GrTypeDefinitionBody || decl.getParent() instanceof GroovyFile)) {
            return true;
        }
        PsiElement leaf = GroovyCompletionUtil.getLeafByOffset(context.getTextRange().getStartOffset() - 1, context);
        if (leaf != null) {
            PsiElement prev = leaf;
            if ((prev = PsiImplUtil.realPrevious(prev)) instanceof GrModifierList && prev.getParent() != null && prev.getParent().getParent() instanceof GroovyFile) {
                return true;
            }
            if (leaf.getParent() instanceof GroovyFile) {
                return GroovyCompletionUtil.isNewStatement(context, false);
            }
        }
        return false;
    }

    private static boolean afterAtInType(PsiElement context) {
        PsiElement previous = PsiImplUtil.realPrevious(PsiTreeUtil.prevLeaf((PsiElement)context));
        return previous != null && GroovyTokenTypes.mAT.equals(previous.getNode().getElementType()) && (context.getParent() != null && context.getParent().getParent() instanceof GroovyFile || context.getParent() instanceof GrCodeReferenceElement && context.getParent().getParent() instanceof GrAnnotation);
    }

    private static boolean isControlStructure(PsiElement context) {
        PsiElement leaf;
        int offset = context.getTextRange().getStartOffset();
        PsiElement prevSibling = context.getPrevSibling();
        if (context.getParent() instanceof GrReferenceElement && prevSibling != null && prevSibling.getNode() != null) {
            ASTNode node = prevSibling.getNode();
            return !TokenSets.DOTS.contains(node.getElementType());
        }
        if (GroovyCompletionUtil.isNewStatement(context, true) && (leaf = GroovyCompletionUtil.getLeafByOffset(offset - 1, context)) != null && (leaf.getParent() instanceof GrStatementOwner || leaf.getParent() instanceof GrLabeledStatement)) {
            return true;
        }
        if (context.getParent() != null) {
            PsiElement superParent;
            PsiElement parent2 = context.getParent();
            if (parent2 instanceof GrExpression && parent2.getParent() instanceof GroovyFile) {
                return true;
            }
            return parent2 instanceof GrReferenceExpression && ((superParent = parent2.getParent()) instanceof GrStatementOwner || superParent instanceof GrLabeledStatement || superParent instanceof GrControlStatement || superParent instanceof GrMethodCall);
        }
        return false;
    }

    private static boolean inCaseSection(PsiElement context) {
        if (context.getParent() instanceof GrReferenceExpression && context.getParent().getParent() instanceof GrCaseSection) {
            return true;
        }
        GrSwitchStatement switchStatement = (GrSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)context, GrSwitchStatement.class, (boolean)true, (Class[])new Class[]{GrCodeBlock.class});
        if (switchStatement == null) {
            return false;
        }
        GrExpression condition = switchStatement.getCondition();
        return condition == null || !PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)context, (boolean)false);
    }

    private static boolean afterTry(PsiElement context) {
        GrTryCatchStatement tryStatement;
        if (context != null && GroovyCompletionUtil.nearestLeftSibling(context) instanceof GrTryCatchStatement) {
            tryStatement = (GrTryCatchStatement)GroovyCompletionUtil.nearestLeftSibling(context);
            if (tryStatement == null) {
                return false;
            }
            if (tryStatement.getFinallyClause() == null) {
                return true;
            }
        }
        if (context != null && GroovyCompletionUtil.nearestLeftSibling(context) instanceof PsiErrorElement && GroovyCompletionUtil.nearestLeftSibling(context).getPrevSibling() instanceof GrTryCatchStatement) {
            tryStatement = (GrTryCatchStatement)GroovyCompletionUtil.nearestLeftSibling(context).getPrevSibling();
            if (tryStatement == null) {
                return false;
            }
            if (tryStatement.getFinallyClause() == null) {
                return true;
            }
        }
        if (context != null && (context.getParent() instanceof GrReferenceExpression || context.getParent() instanceof PsiErrorElement) && GroovyCompletionUtil.nearestLeftSibling(context.getParent()) instanceof GrTryCatchStatement) {
            tryStatement = (GrTryCatchStatement)GroovyCompletionUtil.nearestLeftSibling(context.getParent());
            if (tryStatement == null) {
                return false;
            }
            if (tryStatement.getFinallyClause() == null) {
                return true;
            }
        }
        if (context != null && context.getParent() instanceof GrReferenceExpression && context.getParent().getParent() instanceof GrMethodCall && GroovyCompletionUtil.nearestLeftSibling(context.getParent().getParent()) instanceof GrTryCatchStatement) {
            tryStatement = (GrTryCatchStatement)GroovyCompletionUtil.nearestLeftSibling(context.getParent().getParent());
            if (tryStatement == null) {
                return false;
            }
            if (tryStatement.getFinallyClause() == null) {
                return true;
            }
        }
        return false;
    }

    private static boolean afterIfOrElse(PsiElement context) {
        GrIfStatement statement;
        if (context.getParent() != null && GroovyCompletionUtil.nearestLeftSibling(context.getParent()) instanceof GrIfStatement) {
            return true;
        }
        if (context.getParent() != null && GroovyCompletionUtil.nearestLeftSibling(context.getParent()) instanceof PsiErrorElement && GroovyCompletionUtil.nearestLeftSibling(GroovyCompletionUtil.nearestLeftSibling(context.getParent())) instanceof GrIfStatement) {
            return true;
        }
        if (context.getParent() != null && GroovyCompletionUtil.nearestLeftSibling(context) != null && GroovyCompletionUtil.nearestLeftSibling(context).getPrevSibling() instanceof GrIfStatement && (statement = (GrIfStatement)GroovyCompletionUtil.nearestLeftSibling(context).getPrevSibling()).getElseBranch() == null) {
            return true;
        }
        return context.getParent() != null && context.getParent().getParent() instanceof GrCommandArgumentList && context.getParent().getParent().getParent().getParent() instanceof GrIfStatement && (statement = (GrIfStatement)context.getParent().getParent().getParent().getParent()).getElseBranch() == null;
    }

    private static boolean afterAbstractMethod(PsiElement context, boolean acceptAnnotationMethods, boolean skipNLs) {
        PsiElement candidate;
        if (GroovyCompletionUtil.isInTypeDefinitionBody(context)) {
            PsiElement run = context;
            while (!(run.getParent() instanceof GrTypeDefinitionBody)) {
                run = run.getParent();
                assert (run != null);
            }
            candidate = PsiUtil.skipWhitespacesAndComments(run.getPrevSibling(), false, skipNLs);
        } else {
            candidate = PsiUtil.skipWhitespacesAndComments(PsiTreeUtil.prevLeaf((PsiElement)context), false);
        }
        if (candidate instanceof PsiErrorElement) {
            candidate = candidate.getPrevSibling();
        }
        return candidate instanceof GrMethod && ((GrMethod)candidate).getBlock() == null && (acceptAnnotationMethods || !(candidate instanceof GrAnnotationMethod));
    }

    private static boolean suggestPrimitiveTypes(PsiElement context) {
        PsiElement prevSibling;
        if (GroovyCompletionData.isInfixOperatorPosition(context)) {
            return false;
        }
        if (GroovyCompletionData.isAfterForParameter(context)) {
            return false;
        }
        PsiElement parent2 = context.getParent();
        if (parent2 == null) {
            return false;
        }
        PsiElement previous = PsiImplUtil.realPrevious(parent2.getPrevSibling());
        if (parent2 instanceof GrReferenceElement && parent2.getParent() instanceof GrArgumentList && ((prevSibling = context.getPrevSibling()) != null && prevSibling.getNode() != null ? !TokenSets.DOTS.contains(prevSibling.getNode().getElementType()) : previous == null || !GroovyTokenTypes.mAT.equals(previous.getNode().getElementType()))) {
            return true;
        }
        if (GroovyCompletionUtil.isTupleVarNameWithoutTypeDeclared(context)) {
            return true;
        }
        if (previous != null && GroovyTokenTypes.mAT.equals(previous.getNode().getElementType())) {
            return false;
        }
        if (GroovyCompletionUtil.asSimpleVariable(context) || GroovyCompletionUtil.asTypedMethod(context) || GroovyCompletionUtil.asVariableInBlock(context) || GroovyCompletionData.asVariableAfterModifiers(context)) {
            return true;
        }
        if (parent2 instanceof GrParameter && ((GrParameter)parent2).getTypeElementGroovy() == null || parent2 instanceof GrReferenceElement && !(parent2.getParent() instanceof GrImportStatement) && !(parent2.getParent() instanceof GrPackageDefinition) && !(parent2.getParent() instanceof GrArgumentList)) {
            prevSibling = context.getPrevSibling();
            if (parent2 instanceof GrReferenceElement && prevSibling != null && prevSibling.getNode() != null) {
                ASTNode node = prevSibling.getNode();
                return !TokenSets.DOTS.contains(node.getElementType());
            }
            return true;
        }
        if (PsiImplUtil.realPrevious(parent2.getPrevSibling()) instanceof GrModifierList) {
            return true;
        }
        if (PsiImplUtil.realPrevious(context.getPrevSibling()) instanceof GrModifierList) {
            return true;
        }
        return parent2 instanceof GrExpression && parent2.getParent() instanceof GroovyFile && GroovyCompletionUtil.isNewStatement(context, false);
    }

    private static boolean asVariableAfterModifiers(PsiElement context) {
        PsiElement decl;
        PsiElement parent2 = context.getParent();
        return parent2 instanceof GrVariable && context == ((GrVariable)parent2).getNameIdentifierGroovy() && (decl = parent2.getParent()) instanceof GrVariableDeclaration && !((GrVariableDeclaration)decl).isTuple() && ((GrVariableDeclaration)decl).getTypeElementGroovy() == null;
    }

    private static boolean isInfixOperatorPosition(PsiElement context) {
        if (context.getParent() != null && context.getParent() instanceof GrReferenceExpression && context.getParent().getParent() != null && context.getParent().getParent() instanceof GrCommandArgumentList) {
            return true;
        }
        if (GroovyCompletionUtil.nearestLeftSibling(context) instanceof PsiErrorElement && GroovyCompletionUtil.endsWithExpression(GroovyCompletionUtil.nearestLeftSibling(context).getPrevSibling())) {
            return true;
        }
        if (context.getParent() instanceof GrReferenceExpression && GroovyCompletionUtil.nearestLeftLeaf(context) instanceof PsiErrorElement && GroovyCompletionUtil.endsWithExpression(GroovyCompletionUtil.nearestLeftLeaf(context).getPrevSibling())) {
            return true;
        }
        return context.getParent() instanceof PsiErrorElement && GroovyCompletionUtil.endsWithExpression(GroovyCompletionUtil.nearestLeftSibling(context.getParent()));
    }

    private static boolean suggestModifiers(PsiElement context) {
        GrVariable variable;
        PsiElement parent2;
        if (GroovyCompletionUtil.asSimpleVariable(context) || GroovyCompletionUtil.asTypedMethod(context) || GroovyCompletionUtil.isNewStatementInScript(context)) {
            return true;
        }
        if (GroovyCompletionUtil.isFirstElementAfterPossibleModifiersInVariableDeclaration(context, false) && !((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"def"})).accepts((Object)context)) {
            return true;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(MODIFIERS)).accepts((Object)context) || ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"synchronized"})).accepts((Object)context)) {
            return true;
        }
        PsiElement contextParent = context.getParent();
        if (contextParent instanceof GrReferenceElement && contextParent.getParent() instanceof GrTypeElement && ((parent2 = contextParent.getParent().getParent()) instanceof GrVariableDeclaration && (parent2.getParent() instanceof GrTypeDefinitionBody || parent2.getParent() instanceof GroovyFile) || parent2 instanceof GrMethod)) {
            return true;
        }
        if (contextParent instanceof GrField && (variable = (GrVariable)contextParent).getTypeElementGroovy() == null) {
            return true;
        }
        if (contextParent instanceof GrExpression && contextParent.getParent() instanceof GroovyFile && GroovyCompletionUtil.isNewStatement(context, false)) {
            return true;
        }
        if (context.getTextRange().getStartOffset() == 0 && !(context instanceof OuterLanguageElement)) {
            return true;
        }
        return contextParent instanceof GrExpression && contextParent.getParent() instanceof GrApplicationStatement && contextParent.getParent().getParent() instanceof GroovyFile && GroovyCompletionUtil.isNewStatement(context, false);
    }

    public static boolean suggestFinalDef(PsiElement context) {
        if (GroovyCompletionUtil.asSimpleVariable(context) || GroovyCompletionUtil.asTypedMethod(context) || GroovyCompletionUtil.asVariableInBlock(context) || GroovyCompletionUtil.isNewStatementInScript(context) && !GroovyCompletionUtil.isReferenceElementInNewExpr(context) || GroovyCompletionUtil.isTypelessParameter(context) || GroovyCompletionUtil.isCodeReferenceElementApplicableToModifierCompletion(context)) {
            return true;
        }
        if (PsiImplUtil.realPrevious(context.getParent().getPrevSibling()) instanceof GrModifierList) {
            return true;
        }
        if (PsiImplUtil.realPrevious(context.getPrevSibling()) instanceof GrModifierList) {
            return true;
        }
        return context.getParent() instanceof GrExpression && context.getParent().getParent() instanceof GroovyFile && GroovyCompletionUtil.isNewStatement(context, false);
    }
}

