/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.completion.ClosureCompleter;
import org.jetbrains.plugins.groovy.lang.completion.closureParameters.ClosureParameterInfo;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;

public class EachWithIndexClosureCompleter
extends ClosureCompleter {
    @Override
    @Nullable
    protected List<ClosureParameterInfo> getParameterInfos(InsertionContext context, PsiMethod method, PsiSubstitutor substitutor, PsiElement place) {
        PsiClass containingClass;
        String name = method.getName();
        if (!"eachWithIndex".equals(name)) {
            return null;
        }
        if (method instanceof GrGdkMethod) {
            method = ((GrGdkMethod)method).getStaticMethod();
        }
        if ((containingClass = method.getContainingClass()) == null) {
            return null;
        }
        String qname = containingClass.getQualifiedName();
        if (!"org.codehaus.groovy.runtime.DefaultGroovyMethods".equals(qname)) {
            return null;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != 2) {
            return null;
        }
        PsiType type2 = parameters2[0].getType();
        PsiType collection = substitutor.substitute(type2);
        PsiType iterable = EachWithIndexClosureCompleter.getIteratedType(place, collection);
        if (iterable != null) {
            return Arrays.asList(new ClosureParameterInfo(iterable.getCanonicalText(), "entry"), new ClosureParameterInfo("int", "i"));
        }
        if (InheritanceUtil.isInheritor((PsiType)collection, (String)"java.util.Map")) {
            PsiType[] typeParams = ((PsiClassType)collection).getParameters();
            Project project = context.getProject();
            PsiClass entry = JavaPsiFacade.getInstance((Project)project).findClass("java.util.Map.Entry", place.getResolveScope());
            if (entry == null) {
                return null;
            }
            PsiClassType entryType = JavaPsiFacade.getElementFactory((Project)project).createType(entry, typeParams);
            return Arrays.asList(new ClosureParameterInfo(entryType.getCanonicalText(), "entry"), new ClosureParameterInfo("int", "i"));
        }
        return Arrays.asList(new ClosureParameterInfo(collection.getCanonicalText(), "entry"), new ClosureParameterInfo("int", "i"));
    }

    private static PsiType getIteratedType(PsiElement parent2, PsiType collection) {
        GrExpression qualifier;
        if (parent2 instanceof GrReferenceExpression && (qualifier = (GrExpression)((GrReferenceExpression)parent2).getQualifier()) != null) {
            return ClosureParameterEnhancer.findTypeForIteration(qualifier, parent2);
        }
        PsiType iterable = PsiUtil.extractIterableTypeParameter((PsiType)collection, (boolean)true);
        if (iterable != null && parent2 instanceof GrExpression) {
            return PsiImplUtil.normalizeWildcardTypeByPosition(iterable, (GrExpression)parent2);
        }
        return iterable;
    }
}

