/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import icons.JetgroovyIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.ext.newify.NewifyMemberContributor;
import org.jetbrains.plugins.groovy.lang.completion.AnnotationAttributeCompletionResultProcessor;
import org.jetbrains.plugins.groovy.lang.completion.GrPropertyForCompletion;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ClosureMissingMethodContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ReferencesKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessorImpl;
import org.jetbrains.plugins.groovy.lang.resolve.processors.SubstitutorComputer;

public class CompleteReferenceExpression {
    private static final Logger LOG = Logger.getInstance(CompleteReferenceExpression.class);
    private final PrefixMatcher myMatcher;
    private final Consumer<LookupElement> myConsumer;
    private final GrReferenceExpressionImpl myRefExpr;
    private final CompletionParameters myParameters;
    private final CompleteReferenceProcessor myProcessor;

    private CompleteReferenceExpression(@NotNull PrefixMatcher matcher, @NotNull Consumer<LookupElement> consumer, @NotNull GrReferenceExpressionImpl refExpr, @NotNull CompletionParameters parameters2) {
        this.myMatcher = matcher;
        this.myConsumer = consumer;
        this.myParameters = parameters2;
        this.myRefExpr = refExpr;
        this.myProcessor = new CompleteReferenceProcessor();
    }

    public static void processVariants(@NotNull PrefixMatcher matcher, @NotNull Consumer<LookupElement> consumer, @NotNull GrReferenceExpressionImpl refExpr, @NotNull CompletionParameters parameters2) {
        new CompleteReferenceExpression(matcher, consumer, refExpr, parameters2).processVariantsImpl();
    }

    private void processVariantsImpl() {
        this.processRefInAnnotationImpl();
        this.getVariantsImpl();
        GroovyResolveResult[] candidates = this.myProcessor.getCandidates();
        List<LookupElement> results = GroovyCompletionUtil.getCompletionVariants(candidates, JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)this.myRefExpr), this.myMatcher, (PsiElement)this.myRefExpr);
        if (this.myProcessor.isEmpty() && results.isEmpty()) {
            results = GroovyCompletionUtil.getCompletionVariants(this.myProcessor.getInapplicableResults(), JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)this.myRefExpr), this.myMatcher, (PsiElement)this.myRefExpr);
        }
        for (LookupElement o : results) {
            this.myConsumer.consume((Object)o);
        }
    }

    public static void processRefInAnnotation(@NotNull GrReferenceExpression refExpr, @NotNull PrefixMatcher matcher, @NotNull Consumer<LookupElement> consumer, @NotNull CompletionParameters parameters2) {
        new CompleteReferenceExpression(matcher, consumer, (GrReferenceExpressionImpl)refExpr, parameters2).processRefInAnnotationImpl();
    }

    private void processRefInAnnotationImpl() {
        if (this.myRefExpr.getParent() instanceof GrAnnotationNameValuePair && ((GrAnnotationNameValuePair)this.myRefExpr.getParent()).getNameIdentifierGroovy() == null) {
            PsiElement parent2 = this.myRefExpr.getParent().getParent();
            if (!(parent2 instanceof GrAnnotation)) {
                parent2 = parent2.getParent();
            }
            if (parent2 instanceof GrAnnotation) {
                new AnnotationAttributeCompletionResultProcessor((GrAnnotation)parent2).process(this.myConsumer, this.myMatcher);
            }
        }
    }

    private void processIfJavaLangClass(@Nullable PsiType type2) {
        if (!(type2 instanceof PsiClassType)) {
            return;
        }
        PsiClass psiClass = ((PsiClassType)type2).resolve();
        if (psiClass == null || !"java.lang.Class".equals(psiClass.getQualifiedName())) {
            return;
        }
        PsiType[] params = ((PsiClassType)type2).getParameters();
        if (params.length != 1) {
            return;
        }
        this.getVariantsFromQualifierType(params[0], this.myRefExpr.getProject());
    }

    private void getVariantsImpl() {
        GrExpression qualifier = this.myRefExpr.getQualifierExpression();
        if (qualifier == null) {
            ResolveUtil.treeWalkUp(this.myRefExpr, this.myProcessor, true);
            ClosureMissingMethodContributor.processMethodsFromClosures(this.myRefExpr, this.myProcessor);
            this.getBindings();
        } else if (this.myRefExpr.getDotTokenType() != GroovyTokenTypes.mSPREAD_DOT) {
            if (qualifier instanceof GrReferenceExpression && ("class".equals(((GrReferenceExpression)qualifier).getReferenceName()) || PsiUtil.isThisReference(qualifier) && !PsiUtil.isInstanceThisRef(qualifier) || ((GrReferenceExpression)qualifier).resolve() instanceof PsiClass)) {
                this.processIfJavaLangClass(qualifier.getType());
            }
            this.getVariantsFromQualifier(qualifier);
        } else {
            this.getVariantsFromQualifierForSpreadOperator(qualifier);
        }
        ResolveUtil.processCategoryMembers(this.myRefExpr, this.myProcessor, ResolveState.initial());
    }

    private void getBindings() {
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.myRefExpr, PsiClass.class);
        if (containingClass != null) {
            return;
        }
        final PsiFile file = FileContextUtil.getContextFile((PsiElement)this.myRefExpr);
        if (file instanceof GroovyFile) {
            ((GroovyFile)file).accept(new GroovyRecursiveElementVisitor(){

                @Override
                public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
                    super.visitAssignmentExpression(expression);
                    GrExpression value = expression.getLValue();
                    if (value instanceof GrReferenceExpression && !((GrReferenceExpression)value).isQualified()) {
                        PsiElement resolved = ((GrReferenceExpression)value).resolve();
                        if (resolved instanceof GrBindingVariable) {
                            CompleteReferenceExpression.this.myProcessor.execute(resolved, ResolveState.initial());
                        } else if (resolved == null) {
                            CompleteReferenceExpression.this.myProcessor.execute(new GrBindingVariable((GroovyFile)file, ((GrReferenceExpression)value).getReferenceName()), ResolveState.initial());
                        }
                    }
                }

                @Override
                public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
                }
            });
        }
    }

    private void getVariantsFromQualifierForSpreadOperator(@NotNull GrExpression qualifier) {
        PsiType spreadType = ClosureParameterEnhancer.findTypeForIteration(qualifier, (PsiElement)this.myRefExpr);
        if (spreadType != null) {
            this.getVariantsFromQualifierType(spreadType, this.myRefExpr.getProject());
        }
    }

    @NotNull
    public static LookupElementBuilder createPropertyLookupElement(@NotNull String name, @Nullable PsiType type2) {
        LookupElementBuilder res = LookupElementBuilder.create((String)name).withIcon(JetgroovyIcons.Groovy.Property);
        if (type2 != null) {
            res = res.withTypeText(type2.getPresentableText());
        }
        return res;
    }

    @Nullable
    public static LookupElementBuilder createPropertyLookupElement(@NotNull PsiMethod accessor, @Nullable GroovyResolveResult resolveResult2, @Nullable PrefixMatcher matcher) {
        String propName;
        boolean getter = GroovyPropertyUtils.isSimplePropertyGetter(accessor, null);
        if (getter) {
            propName = GroovyPropertyUtils.getPropertyNameByGetter(accessor);
        } else if (GroovyPropertyUtils.isSimplePropertySetter(accessor, null)) {
            propName = GroovyPropertyUtils.getPropertyNameBySetter(accessor);
        } else {
            return null;
        }
        assert (propName != null);
        if (!PsiUtil.isValidReferenceName(propName)) {
            propName = "'" + propName + "'";
        }
        if (matcher != null && !matcher.prefixMatches(propName)) {
            return null;
        }
        PsiType propType = getter ? PsiUtil.getSmartReturnType(accessor) : accessor.getParameterList().getParameters()[0].getType();
        PsiType substituted = resolveResult2 != null ? resolveResult2.getSubstitutor().substitute(propType) : propType;
        LookupElementBuilder builder = LookupElementBuilder.create((Object)CompleteReferenceExpression.generatePropertyElement(propName, accessor, propType), (String)propName).withIcon(JetgroovyIcons.Groovy.Property);
        if (substituted != null) {
            builder = builder.withTypeText(substituted.getPresentableText());
        }
        return builder;
    }

    @NotNull
    private static PsiElement generatePropertyElement(@NotNull String name, @NotNull PsiMethod method, @Nullable PsiType type2) {
        PsiType nonNullType = type2 == null ? TypesUtil.getJavaLangObject((PsiElement)method) : type2;
        return new GrPropertyForCompletion(method, name, nonNullType);
    }

    private void getVariantsFromQualifier(@NotNull GrExpression qualifier) {
        Project project = qualifier.getProject();
        PsiType qualifierType = TypesUtil.boxPrimitiveType(qualifier.getType(), qualifier.getManager(), qualifier.getResolveScope());
        ResolveState state = ResolveState.initial();
        if (qualifierType == null || PsiType.VOID.equals((Object)qualifierType)) {
            if (qualifier instanceof GrReferenceExpression) {
                PsiPackage aPackage = ReferencesKt.resolvePackageFqn((GrReferenceElement)((Object)qualifier));
                if (aPackage != null) {
                    aPackage.processDeclarations((PsiScopeProcessor)this.myProcessor, state, null, (PsiElement)this.myRefExpr);
                    return;
                }
                PsiElement resolved = ((GrReferenceExpression)qualifier).resolve();
                if (resolved instanceof PsiVariable) {
                    resolved.processDeclarations((PsiScopeProcessor)this.myProcessor, state, null, (PsiElement)this.myRefExpr);
                    return;
                }
            }
            this.getVariantsFromQualifierType((PsiType)TypesUtil.getJavaLangObject(qualifier), project);
        } else if (qualifierType instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)qualifierType).getConjuncts()) {
                this.getVariantsFromQualifierType(conjunct, project);
            }
        } else if (qualifierType instanceof GrTraitType) {
            PsiType[] conjuncts = ((GrTraitType)qualifierType).getConjuncts();
            for (int i = conjuncts.length - 1; i >= 0; --i) {
                this.getVariantsFromQualifierType(conjuncts[i], project);
            }
        } else {
            GlobalSearchScope scope;
            PsiClass javaLangClass;
            PsiElement resolved;
            this.getVariantsFromQualifierType(qualifierType, project);
            if (qualifier instanceof GrReferenceExpression && !PsiUtil.isSuperReference(qualifier) && !PsiUtil.isInstanceThisRef(qualifier) && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass && (javaLangClass = PsiUtil.getJavaLangClass(resolved, scope = this.myRefExpr.getResolveScope())) != null) {
                PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                PsiTypeParameter[] typeParameters = javaLangClass.getTypeParameters();
                if (typeParameters.length == 1) {
                    substitutor = substitutor.put(typeParameters[0], qualifierType);
                }
                PsiClassType javaLangClassType = JavaPsiFacade.getElementFactory((Project)this.myRefExpr.getProject()).createType(javaLangClass, substitutor);
                ResolveUtil.processAllDeclarations((PsiType)javaLangClassType, (PsiScopeProcessor)this.myProcessor, state, (PsiElement)this.myRefExpr);
            }
        }
    }

    private void getVariantsFromQualifierType(@NotNull PsiType qualifierType, @NotNull Project project) {
        ResolveState state = ResolveState.initial();
        if (qualifierType instanceof PsiClassType) {
            PsiClassType.ClassResolveResult result2 = ((PsiClassType)qualifierType).resolveGenerics();
            PsiClass qualifierClass = result2.getElement();
            if (qualifierClass != null) {
                qualifierClass.processDeclarations((PsiScopeProcessor)this.myProcessor, state.put(PsiSubstitutor.KEY, (Object)result2.getSubstitutor()), null, (PsiElement)this.myRefExpr);
            }
        } else if (qualifierType instanceof PsiArrayType) {
            GrTypeDefinition arrayClass = GroovyPsiManager.getInstance(project).getArrayClass(((PsiArrayType)qualifierType).getComponentType());
            if (arrayClass != null && !arrayClass.processDeclarations(this.myProcessor, state, null, this.myRefExpr)) {
                return;
            }
        } else if (qualifierType instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)qualifierType).getConjuncts()) {
                this.getVariantsFromQualifierType(conjunct, project);
            }
            return;
        }
        ResolveUtil.processNonCodeMembers(qualifierType, this.myProcessor, this.myRefExpr, state);
    }

    @NotNull
    private Set<String> addAllRestrictedProperties() {
        if (this.myRefExpr.getQualifier() != null) {
            return Collections.emptySet();
        }
        HashSet<String> propertyNames = new HashSet<String>();
        GrTypeDefinition containingClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)this.myRefExpr, GrTypeDefinition.class);
        while (containingClass != null) {
            for (GrField field : containingClass.getFields()) {
                propertyNames.add(field.getName());
            }
            containingClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)containingClass, GrTypeDefinition.class);
        }
        return propertyNames;
    }

    private boolean isMap() {
        PsiType qType = PsiImplUtil.getQualifierType(this.myRefExpr);
        return InheritanceUtil.isInheritor((PsiType)qType, (String)"java.util.Map");
    }

    private class CompleteReferenceProcessor
    extends ResolverProcessorImpl
    implements Consumer<Object> {
        private final Consumer<LookupElement> myConsumer;
        private final boolean mySkipPackages;
        private final PsiClass myEventListener;
        private final boolean myMethodPointerOperator;
        private final boolean myFieldPointerOperator;
        private final boolean myIsMap;
        private final SubstitutorComputer mySubstitutorComputer;
        private final Collection<String> myPreferredFieldNames;
        private final Set<String> myPropertyNames;
        private final Set<String> myLocalVars;
        private final Set<GrMethod> myProcessedMethodWithOptionalParams;
        private List<GroovyResolveResult> myInapplicable;
        private boolean myIsEmpty;

        protected CompleteReferenceProcessor() {
            super(null, EnumSet.allOf(ElementClassHint.DeclarationKind.class), CompleteReferenceExpression.this.myRefExpr, PsiType.EMPTY_ARRAY);
            this.myPropertyNames = new HashSet<String>();
            this.myLocalVars = new HashSet<String>();
            this.myProcessedMethodWithOptionalParams = new HashSet<GrMethod>();
            this.myIsEmpty = true;
            this.myConsumer = element -> {
                this.myIsEmpty = false;
                CompleteReferenceExpression.this.myConsumer.consume(element);
            };
            this.myPreferredFieldNames = CompleteReferenceExpression.this.addAllRestrictedProperties();
            this.mySkipPackages = this.shouldSkipPackages();
            this.myEventListener = JavaPsiFacade.getInstance((Project)CompleteReferenceExpression.this.myRefExpr.getProject()).findClass("java.util.EventListener", CompleteReferenceExpression.this.myRefExpr.getResolveScope());
            this.myPropertyNames.addAll(this.myPreferredFieldNames);
            this.myFieldPointerOperator = CompleteReferenceExpression.this.myRefExpr.hasAt();
            this.myMethodPointerOperator = CompleteReferenceExpression.this.myRefExpr.getDotTokenType() == GroovyTokenTypes.mMEMBER_POINTER;
            this.myIsMap = CompleteReferenceExpression.this.isMap();
            PsiType thisType = PsiImplUtil.getQualifierType(CompleteReferenceExpression.this.myRefExpr);
            this.mySubstitutorComputer = new SubstitutorComputer(thisType, PsiType.EMPTY_ARRAY, PsiType.EMPTY_ARRAY, (PsiElement)CompleteReferenceExpression.this.myRefExpr, CompleteReferenceExpression.this.myRefExpr.getParent());
        }

        public boolean isEmpty() {
            return this.myIsEmpty;
        }

        private boolean shouldSkipPackages() {
            if (CompleteReferenceExpression.this.myRefExpr.getQualifierExpression() != null) {
                return false;
            }
            PsiElement parent2 = CompleteReferenceExpression.this.myRefExpr.getParent();
            return parent2 == null || parent2.getLanguage().isKindOf((Language)GroovyLanguage.INSTANCE);
        }

        @Override
        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor() && !(element instanceof NewifyMemberContributor.NewifiedConstructor)) {
                return true;
            }
            if (element instanceof PsiNamedElement) {
                PsiNamedElement namedElement = (PsiNamedElement)element;
                boolean isAccessible = this.isAccessible(namedElement);
                PsiElement resolveContext = (PsiElement)state.get(ClassHint.RESOLVE_CONTEXT);
                SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
                boolean isStaticsOK = this.isStaticsOK(namedElement, resolveContext, CompleteReferenceExpression.this.myParameters.getInvocationCount() <= 1);
                PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
                if (substitutor == null) {
                    substitutor = PsiSubstitutor.EMPTY;
                }
                if (element instanceof PsiMethod) {
                    substitutor = this.mySubstitutorComputer.obtainSubstitutor(substitutor, (PsiMethod)element, resolveContext);
                }
                this.consume(new GroovyResolveResultImpl((PsiElement)namedElement, resolveContext, spreadState, substitutor, isAccessible, isStaticsOK));
            }
            return true;
        }

        public void consume(Object o) {
            if (!(o instanceof GroovyResolveResult)) {
                LOG.error(o);
                return;
            }
            GroovyResolveResult result2 = (GroovyResolveResult)o;
            if (!result2.isStaticsOK()) {
                if (this.myInapplicable == null) {
                    this.myInapplicable = new ArrayList<GroovyResolveResult>();
                }
                this.myInapplicable.add(result2);
                return;
            }
            if (!result2.isAccessible() && CompleteReferenceExpression.this.myParameters.getInvocationCount() < 2) {
                return;
            }
            if (this.mySkipPackages && result2.getElement() instanceof PsiPackage) {
                return;
            }
            PsiElement element = result2.getElement();
            if (element instanceof PsiVariable && !CompleteReferenceExpression.this.myMatcher.prefixMatches(((PsiVariable)element).getName())) {
                return;
            }
            if (element instanceof GrReflectedMethod) {
                GrMethod base = ((GrReflectedMethod)element).getBaseMethod();
                if (!this.myProcessedMethodWithOptionalParams.add(base)) {
                    return;
                }
                result2 = PsiImplUtil.reflectedToBase(result2, base, (GrReflectedMethod)element);
                element = base;
            }
            if (this.myFieldPointerOperator && !(element instanceof PsiVariable)) {
                return;
            }
            if (this.myMethodPointerOperator && !(element instanceof PsiMethod)) {
                return;
            }
            this.addCandidate(result2);
            if (!this.myFieldPointerOperator && !this.myMethodPointerOperator) {
                if (element instanceof PsiMethod) {
                    this.processProperty((PsiMethod)element, result2);
                } else if (element instanceof GrField && ((GrField)element).isProperty()) {
                    this.processPropertyFromField((GrField)element, result2);
                }
            }
            if (element instanceof GrVariable && !(element instanceof GrField)) {
                this.myLocalVars.add(((GrVariable)element).getName());
            }
        }

        private void processPropertyFromField(@NotNull GrField field, @NotNull GroovyResolveResult resolveResult2) {
            if (field.getGetters().length != 0 || field.getSetter() != null || !this.myPropertyNames.add(field.getName()) || this.myIsMap) {
                return;
            }
            for (LookupElement lookupElement : GroovyCompletionUtil.createLookupElements(resolveResult2, false, CompleteReferenceExpression.this.myMatcher, null)) {
                this.myConsumer.consume((Object)((LookupElementBuilder)lookupElement).withIcon(JetgroovyIcons.Groovy.Property));
            }
        }

        private void processProperty(@NotNull PsiMethod method, @NotNull GroovyResolveResult resolveResult2) {
            if (this.myIsMap) {
                return;
            }
            LookupElementBuilder lookup = CompleteReferenceExpression.createPropertyLookupElement(method, resolveResult2, CompleteReferenceExpression.this.myMatcher);
            if (lookup != null) {
                if (this.myPropertyNames.add(lookup.getLookupString())) {
                    this.myConsumer.consume((Object)lookup);
                }
            } else if (this.myEventListener != null) {
                this.processListenerProperties(method);
            }
        }

        private void processListenerProperties(@NotNull PsiMethod method) {
            if (!method.getName().startsWith("add") || method.getParameterList().getParametersCount() != 1) {
                return;
            }
            PsiParameter parameter = method.getParameterList().getParameters()[0];
            PsiType type2 = parameter.getType();
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type2;
            PsiClass listenerClass = classType.resolve();
            if (listenerClass == null) {
                return;
            }
            PsiMethod[] listenerMethods = listenerClass.getMethods();
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)listenerClass, (PsiClass)this.myEventListener, (boolean)true)) {
                return;
            }
            for (PsiMethod listenerMethod : listenerMethods) {
                String name = listenerMethod.getName();
                if (!this.myPropertyNames.add(name)) continue;
                LookupElementBuilder builder = LookupElementBuilder.create((Object)CompleteReferenceExpression.generatePropertyElement(name, listenerMethod, null), (String)name).withIcon(JetgroovyIcons.Groovy.Property);
                this.myConsumer.consume((Object)builder);
            }
        }

        @Override
        public GroovyResolveResult @NotNull [] getCandidates() {
            if (!this.hasCandidates()) {
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            GroovyResolveResult[] results = ResolveUtil.filterSameSignatureCandidates(this.getCandidatesInternal());
            ArrayList<GroovyResolveResult> list = new ArrayList<GroovyResolveResult>(results.length);
            this.myPropertyNames.removeAll(this.myPreferredFieldNames);
            HashSet<String> usedFields = new HashSet<String>();
            for (GroovyResolveResult result2 : results) {
                PsiElement element = result2.getElement();
                if (element instanceof PsiField) {
                    String name = ((PsiField)element).getName();
                    if (this.myPropertyNames.contains(name) || this.myLocalVars.contains(name) || usedFields.contains(name)) continue;
                    usedFields.add(name);
                }
                list.add(result2);
            }
            return list.toArray(GroovyResolveResult.EMPTY_ARRAY);
        }

        @NotNull
        private List<GroovyResolveResult> getInapplicableResults() {
            if (this.myInapplicable == null) {
                return Collections.emptyList();
            }
            return this.myInapplicable;
        }
    }
}

