/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.other;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;

public class GrSortMapKeysIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        GrNamedArgument[] namedArgs;
        GrListOrMap map2;
        PsiElement pparent;
        PsiElement parent2 = element.getParent();
        if (parent2 instanceof GrArgumentLabel && (pparent = parent2.getParent().getParent()) instanceof GrListOrMap && !ErrorUtil.containsError(pparent) && (map2 = (GrListOrMap)pparent).getInitializers().length == 0 && GrSortMapKeysIntention.isLiteralKeys(namedArgs = map2.getNamedArguments())) {
            GrListOrMap newMap = GrSortMapKeysIntention.constructNewMap(namedArgs, project);
            map2.replace(newMap);
        }
    }

    @NotNull
    private static GrListOrMap constructNewMap(GrNamedArgument @NotNull [] args, Project project) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Arrays.sort(args, (o1, o2) -> {
            String l1 = o1.getLabelName();
            String l2 = o2.getLabelName();
            assert (l1 != null && l2 != null);
            return l1.compareTo(l2);
        });
        for (GrNamedArgument arg : args) {
            builder.append(arg.getText()).append(",\n");
        }
        builder.replace(builder.length() - 2, builder.length(), "]");
        return (GrListOrMap)GroovyPsiElementFactory.getInstance(project).createExpressionFromText(builder);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                PsiElement parent2 = element.getParent();
                if (!(parent2 instanceof GrArgumentLabel)) {
                    return false;
                }
                if (((GrArgumentLabel)parent2).getNameElement() != element) {
                    return false;
                }
                PsiElement grandParent = parent2.getParent();
                if (grandParent == null) {
                    return false;
                }
                PsiElement grandGrandParent = grandParent.getParent();
                if (!(grandGrandParent instanceof GrListOrMap)) {
                    return false;
                }
                GrListOrMap map2 = (GrListOrMap)grandGrandParent;
                return !ErrorUtil.containsError(map2) && map2.getInitializers().length == 0 && GrSortMapKeysIntention.isLiteralKeys(map2.getNamedArguments());
            }
        };
    }

    private static boolean isLiteralKeys(GrNamedArgument[] args) {
        return ContainerUtil.and((Object[])args, it -> it.getLabel() != null);
    }
}

