/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;

class ConjunctionPredicate
implements PsiElementPredicate {
    ConjunctionPredicate() {
    }

    @Override
    public boolean satisfiedBy(@NotNull PsiElement element) {
        if (!(element instanceof GrBinaryExpression)) {
            return false;
        }
        GrBinaryExpression expression = (GrBinaryExpression)element;
        IElementType tokenType = expression.getOperationTokenType();
        if (tokenType == null) {
            return false;
        }
        if (!tokenType.equals(GroovyTokenTypes.mLAND) && !tokenType.equals(GroovyTokenTypes.mLOR)) {
            return false;
        }
        return !ErrorUtil.containsError(element);
    }
}

