/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ext.spock;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.ext.spock.DataVariablesKt;
import org.jetbrains.plugins.groovy.ext.spock.SpockConstants;
import org.jetbrains.plugins.groovy.ext.spock.SpockVariableDescriptor;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public final class SpockUtils {
    public static final String SPEC_CLASS_NAME = "spock.lang.Specification";

    private SpockUtils() {
    }

    public static Map<String, SpockVariableDescriptor> getVariableMap(@NotNull GrMethod method) {
        GrMethod originalMethod;
        PsiFile containingFile = method.getContainingFile();
        if (containingFile != containingFile.getOriginalFile()) {
            int methodOffset = method.getTextOffset();
            PsiElement originalPlace = containingFile.getOriginalFile().findElementAt(methodOffset);
            originalMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)originalPlace, GrMethod.class);
            assert (originalMethod != null) : containingFile.getOriginalFile().getText().substring(Math.max(0, methodOffset - 50), Math.min(methodOffset + 50, containingFile.getOriginalFile().getText().length()));
        } else {
            originalMethod = method;
        }
        return (Map)CachedValuesManager.getCachedValue((PsiElement)originalMethod, () -> CachedValueProvider.Result.create(DataVariablesKt.createVariableMap(originalMethod), (Object[])new Object[]{originalMethod}));
    }

    @Nullable
    public static String getNameByReference(@Nullable PsiElement expression) {
        if (!(expression instanceof GrReferenceExpression)) {
            return null;
        }
        PsiElement firstChild = expression.getFirstChild();
        if (firstChild != expression.getLastChild() || !PsiImplUtil.isLeafElementOfType((PsiElement)firstChild, (IElementType)GroovyTokenTypes.mIDENT)) {
            return null;
        }
        GrReferenceExpression ref = (GrReferenceExpression)expression;
        if (ref.isQualified()) {
            return null;
        }
        return ref.getReferenceName();
    }

    public static boolean isTestMethod(PsiElement element) {
        if (!(element instanceof GrMethod)) {
            return false;
        }
        GrMethod method = (GrMethod)element;
        PsiClass clazz = method.getContainingClass();
        if (!SpockUtils.isSpecification(clazz)) {
            return false;
        }
        if (SpockUtils.isFixtureMethod(method)) {
            return false;
        }
        return SpockUtils.isFeatureMethod(method);
    }

    public static boolean isSpecification(@Nullable PsiClass clazz) {
        return clazz instanceof GrTypeDefinition && InheritanceUtil.isInheritor((PsiClass)clazz, (String)SPEC_CLASS_NAME);
    }

    public static boolean isFixtureMethod(@NotNull GrMethod method) {
        if (method.hasModifierProperty("static")) {
            return false;
        }
        return SpockConstants.FIXTURE_METHOD_NAMES.contains(method.getName());
    }

    public static boolean isFeatureMethod(@NotNull GrMethod method) {
        if (method.hasModifierProperty("static")) {
            return false;
        }
        GrOpenBlock block = method.getBlock();
        if (block == null) {
            return false;
        }
        for (GrStatement statement : block.getStatements()) {
            String label;
            if (!(statement instanceof GrLabeledStatement) || !SpockConstants.FEATURE_METHOD_LABELS.contains(label = ((GrLabeledStatement)statement).getName())) continue;
            return true;
        }
        return false;
    }
}

