/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.selection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyStatementSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(@NotNull PsiElement e) {
        return e instanceof GrExpression && PsiUtil.isExpressionStatement(e) || e instanceof GrStatement && !(e instanceof GrExpression) || e.getNode().getElementType() == GroovyTokenTypes.mSEMI;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        PsiElement last;
        TextRange originalRange;
        PsiElement first;
        if (e instanceof GrStatement) {
            first = e;
            PsiElement next = e.getNextSibling();
            if ((next = GroovyStatementSelectioner.skipWhitespacesForward(next)) != null && next.getNode().getElementType() == GroovyTokenTypes.mSEMI) {
                originalRange = new TextRange(e.getTextRange().getStartOffset(), next.getTextRange().getEndOffset());
                last = next;
            } else {
                originalRange = e.getTextRange();
                last = e;
            }
        } else {
            last = e;
            PsiElement prev = e.getPrevSibling();
            if ((prev = GroovyStatementSelectioner.skipWhitespaceBack(prev)) instanceof GrStatement) {
                originalRange = new TextRange(prev.getTextRange().getStartOffset(), e.getTextRange().getEndOffset());
                first = prev;
            } else {
                originalRange = e.getTextRange();
                first = e;
            }
        }
        List ranges = ExtendWordSelectionHandlerBase.expandToWholeLine((CharSequence)editorText, (TextRange)originalRange);
        TextRange blockRange = GroovyStatementSelectioner.inferBlockRange(first, last);
        if (!blockRange.equals((Object)originalRange)) {
            ranges.addAll(ExtendWordSelectionHandlerBase.expandToWholeLine((CharSequence)editorText, (TextRange)blockRange, (boolean)true));
        }
        return ranges;
    }

    private static TextRange inferBlockRange(PsiElement first, PsiElement last) {
        while (true) {
            PsiElement prev = first.getPrevSibling();
            if (GroovyStatementSelectioner.isOneLineFeed(prev = GroovyStatementSelectioner.skipWhitespaceBack(prev))) {
                prev = prev.getPrevSibling();
            }
            if (((prev = GroovyStatementSelectioner.skipWhitespaceBack(prev)) == null || prev.getNode().getElementType() != GroovyTokenTypes.mSEMI) && !(prev instanceof GrStatement)) break;
            first = prev;
        }
        while (true) {
            PsiElement next = last.getNextSibling();
            if (GroovyStatementSelectioner.isOneLineFeed(next = GroovyStatementSelectioner.skipWhitespacesForward(next))) {
                next = next.getNextSibling();
            }
            if (((next = GroovyStatementSelectioner.skipWhitespacesForward(next)) == null || next.getNode().getElementType() != GroovyTokenTypes.mSEMI) && !(next instanceof GrStatement)) break;
            last = next;
        }
        return new TextRange(first.getTextRange().getStartOffset(), last.getTextRange().getEndOffset());
    }

    private static PsiElement skipWhitespacesForward(PsiElement next) {
        while (GroovyStatementSelectioner.isSpaceWithoutLineFeed(next)) {
            next = next.getNextSibling();
        }
        return next;
    }

    private static PsiElement skipWhitespaceBack(PsiElement prev) {
        while (GroovyStatementSelectioner.isSpaceWithoutLineFeed(prev)) {
            prev = prev.getPrevSibling();
        }
        return prev;
    }

    private static boolean isOneLineFeed(PsiElement e) {
        if (e == null) {
            return false;
        }
        if (!PsiImplUtil.isWhiteSpaceOrNls(e)) {
            return false;
        }
        String text = e.getText();
        int i = text.indexOf(10);
        return i >= 0 && i == text.lastIndexOf(10);
    }

    private static boolean isSpaceWithoutLineFeed(PsiElement e) {
        return e instanceof PsiWhiteSpace && e.getText().indexOf(10) == -1;
    }
}

