/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.selection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class GroovyArgListSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(@NotNull PsiElement e) {
        return e instanceof GrArgumentList || e.getParent() instanceof GrReferenceExpression && e.getParent().getParent() instanceof GrCall;
    }

    public List<TextRange> select(@NotNull PsiElement element, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        PsiElement parent2;
        GrArgumentList args;
        TextRange range;
        List result2 = super.select(element, editorText, cursorOffset, editor);
        if (element instanceof GrArgumentList && (range = (args = (GrArgumentList)element).getTextRange()).contains(cursorOffset)) {
            PsiElement leftParen = args.getLeftParen();
            PsiElement rightParen = args.getRightParen();
            if (leftParen != null) {
                int leftOffset = leftParen.getTextOffset();
                if (rightParen != null) {
                    if (leftOffset + 1 < rightParen.getTextOffset()) {
                        int rightOffset = rightParen.getTextRange().getEndOffset();
                        range = new TextRange(leftParen.getTextRange().getStartOffset() + 1, rightOffset - 1);
                        result2.add(range);
                    }
                } else {
                    range = new TextRange(leftParen.getTextRange().getStartOffset() + 1, element.getTextRange().getEndOffset());
                    result2.add(range);
                }
            }
        }
        if ((parent2 = element.getParent()) instanceof GrReferenceExpression) {
            GrArgumentList argumentList = ((GrCall)parent2.getParent()).getArgumentList();
            PsiElement refName = ((GrReferenceExpression)parent2).getReferenceNameElement();
            if (argumentList != null && refName == element) {
                result2.add(new TextRange(refName.getTextRange().getStartOffset(), argumentList.getTextRange().getEndOffset()));
            }
        }
        return result2;
    }
}

