/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.actions.joinLines;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.editor.actions.joinLines.GrJoinLinesHandlerBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class GrJoinStatementsHandler
extends GrJoinLinesHandlerBase {
    @Override
    public int tryJoinStatements(@NotNull GrStatement first, @NotNull GrStatement second) {
        PsiElement semi = PsiImplUtil.findTailingSemicolon(first);
        Document document = PsiDocumentManager.getInstance((Project)first.getProject()).getDocument(first.getContainingFile());
        if (document == null) {
            return -1;
        }
        int endOffset = second.getTextRange().getStartOffset();
        if (semi != null) {
            int offset = semi.getTextRange().getEndOffset();
            document.replaceString(offset, endOffset, (CharSequence)" ");
            return offset + 1;
        }
        int offset = first.getTextRange().getEndOffset();
        document.replaceString(offset, endOffset, (CharSequence)"; ");
        return offset + 2;
    }
}

