/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor;

import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyTokenSets;

public class GroovyQuoteHandler
implements MultiCharQuoteHandler {
    public boolean isClosingQuote(HighlighterIterator iterator2, int offset) {
        IElementType tokenType = iterator2.getTokenType();
        if (tokenType == GroovyTokenTypes.mGSTRING_END) {
            return true;
        }
        if (GroovyTokenSets.STRING_LITERALS.contains(tokenType)) {
            int start = iterator2.getStart();
            int end = iterator2.getEnd();
            return end - start >= 1 && offset == end - 1 || end - start >= 5 && offset >= end - 3;
        }
        if (tokenType == GroovyTokenTypes.mREGEX_END) {
            int start = iterator2.getStart();
            int end = iterator2.getEnd();
            return end - start >= 1 && offset == end - 1;
        }
        return false;
    }

    public boolean isOpeningQuote(HighlighterIterator iterator2, int offset) {
        IElementType tokenType = iterator2.getTokenType();
        if (tokenType == GroovyTokenTypes.mGSTRING_BEGIN || tokenType == GroovyTokenTypes.mREGEX_BEGIN) {
            return true;
        }
        if (GroovyTokenSets.STRING_LITERALS.contains(tokenType)) {
            int start = iterator2.getStart();
            return offset == start;
        }
        return false;
    }

    public boolean hasNonClosedLiteral(Editor editor, HighlighterIterator iterator2, int offset) {
        IElementType tokenType = iterator2.getTokenType();
        if (GroovyTokenSets.STRING_LITERALS.contains(tokenType) || tokenType == GroovyTokenTypes.mGSTRING_BEGIN || tokenType == GroovyTokenTypes.mGSTRING_CONTENT) {
            Document document = iterator2.getDocument();
            if (document == null) {
                return false;
            }
            String literal = document.getText().substring(iterator2.getStart(), offset + 1);
            if ("'''".equals(literal) || "\"\"\"".equals(literal) || "'".equals(literal) || "\"".equals(literal)) {
                return true;
            }
        }
        return !GroovyTokenSets.STRING_LITERALS.contains(tokenType) && tokenType != GroovyTokenTypes.mGSTRING_CONTENT && tokenType != GroovyTokenTypes.mGSTRING_END;
    }

    public boolean isInsideLiteral(HighlighterIterator iterator2) {
        return GroovyTokenSets.STRING_LITERALS.contains(iterator2.getTokenType());
    }

    public CharSequence getClosingQuote(@NotNull HighlighterIterator iterator2, int offset) {
        String quote;
        Document document;
        if (offset >= 3) {
            document = iterator2.getDocument();
            if (document == null) {
                return null;
            }
            quote = document.getText(new TextRange(offset - 3, offset));
            if ("'''".equals(quote)) {
                return quote;
            }
            if ("\"\"\"".equals(quote)) {
                return quote;
            }
        }
        if (offset >= 2) {
            document = iterator2.getDocument();
            if (document == null) {
                return null;
            }
            quote = document.getText(new TextRange(offset - 2, offset));
            if ("$/".equals(quote)) {
                return "/$";
            }
        }
        return null;
    }
}

