/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.dsl.DslActivationStatus;
import org.jetbrains.plugins.groovy.dsl.GdslUtil;
import org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.util.GrFileIndexUtil;

public class GroovyDslAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        String error;
        if (!(psiElement instanceof GroovyFile)) {
            return;
        }
        GroovyFile groovyFile = (GroovyFile)psiElement;
        if (!GrFileIndexUtil.isGroovySourceFile(groovyFile)) {
            return;
        }
        VirtualFile vfile = groovyFile.getVirtualFile();
        if (!GdslUtil.GDSL_FILTER.value((Object)vfile)) {
            return;
        }
        DslActivationStatus.Status status = GroovyDslFileIndex.getStatus(vfile);
        if (status == DslActivationStatus.Status.ACTIVE) {
            return;
        }
        String message = status == DslActivationStatus.Status.MODIFIED ? "DSL descriptor file has been changed and isn't currently executed." : "DSL descriptor file has been disabled due to a processing error.";
        AnnotationBuilder builder = holder.newAnnotation(HighlightSeverity.WARNING, message).fileLevel().withFix((IntentionAction)new ActivateFix(vfile));
        if (status == DslActivationStatus.Status.ERROR && (error = GroovyDslFileIndex.getError(vfile)) != null) {
            builder = builder.withFix(GroovyQuickFixFactory.getInstance().createInvestigateFix(error));
        }
        builder.create();
    }

    private static class ActivateFix
    implements IntentionAction {
        private final VirtualFile myVfile;

        ActivateFix(VirtualFile vfile) {
            this.myVfile = vfile;
        }

        @NotNull
        public String getText() {
            return "Activate back";
        }

        @NotNull
        public String getFamilyName() {
            return "Activate DSL Descriptor";
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            FileDocumentManager.getInstance().saveAllDocuments();
            GroovyDslFileIndex.activate(this.myVfile);
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }

        public boolean startInWriteAction() {
            return false;
        }
    }
}

