/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.Factor;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.GroovyDslExecutor;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;

public class FactorTree
extends UserDataHolderBase {
    private static final Key<CachedValue<Map>> GDSL_MEMBER_CACHE = Key.create((String)"GDSL_MEMBER_CACHE");
    private static final Key<Boolean> CONTAINS_TYPE = Key.create((String)"CONTAINS_TYPE");
    private final CachedValueProvider<Map> myProvider;
    private final CachedValue<Map> myTopLevelCache;
    private final GroovyDslExecutor myExecutor;

    public FactorTree(Project project, GroovyDslExecutor executor) {
        this.myExecutor = executor;
        this.myProvider = () -> new CachedValueProvider.Result(new ConcurrentHashMap(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        this.myTopLevelCache = CachedValuesManager.getManager((Project)project).createCachedValue(this.myProvider, false);
    }

    public void cache(GroovyClassDescriptor descriptor, CustomMembersHolder holder) {
        Map current = null;
        for (Factor factor : descriptor.affectingFactors) {
            ConcurrentHashMap next;
            Object key;
            switch (factor) {
                case placeElement: {
                    key = descriptor.getPlace();
                    break;
                }
                case placeFile: {
                    key = descriptor.getPlaceFile();
                    break;
                }
                case qualifierType: {
                    key = descriptor.getPsiType().getCanonicalText(false);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown variant: " + (Object)((Object)factor));
                }
            }
            if (current == null) {
                if (key instanceof UserDataHolder) {
                    Project project = descriptor.getProject();
                    current = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)key, GDSL_MEMBER_CACHE, this.myProvider, false);
                    continue;
                }
                current = (Map)this.myTopLevelCache.getValue();
            }
            if ((next = (ConcurrentHashMap)current.get(key)) == null) {
                next = new ConcurrentHashMap();
                current.put(key, next);
                if (key instanceof String) {
                    current.put(CONTAINS_TYPE, true);
                }
            }
            current = next;
        }
        if (current == null) {
            current = (Map)this.myTopLevelCache.getValue();
        }
        current.put(this.myExecutor, holder);
    }

    @Nullable
    public CustomMembersHolder retrieve(PsiElement place, PsiFile placeFile, NotNullLazyValue<String> qualifierType) {
        return this.retrieveImpl(place, placeFile, qualifierType, (Map)this.myTopLevelCache.getValue(), true);
    }

    @Nullable
    private CustomMembersHolder retrieveImpl(@NotNull PsiElement place, @NotNull PsiFile placeFile, @NotNull NotNullLazyValue<String> qualifierType, @Nullable Map current, boolean topLevel) {
        if (current == null) {
            return null;
        }
        CustomMembersHolder result2 = (CustomMembersHolder)current.get(this.myExecutor);
        if (result2 != null) {
            return result2;
        }
        if (current.containsKey(CONTAINS_TYPE) && (result2 = this.retrieveImpl(place, placeFile, qualifierType, (Map)current.get(qualifierType.getValue()), false)) != null) {
            return result2;
        }
        result2 = this.retrieveImpl(place, placeFile, qualifierType, FactorTree.getFromMapOrUserData((UserDataHolder)placeFile, current, topLevel), false);
        if (result2 != null) {
            return result2;
        }
        return this.retrieveImpl(place, placeFile, qualifierType, FactorTree.getFromMapOrUserData((UserDataHolder)place, current, topLevel), false);
    }

    private static Map getFromMapOrUserData(UserDataHolder holder, Map map2, boolean fromUserData) {
        if (fromUserData) {
            CachedValue cache2 = (CachedValue)holder.getUserData(GDSL_MEMBER_CACHE);
            return cache2 != null && cache2.hasUpToDateValue() ? (Map)cache2.getValue() : null;
        }
        return (Map)map2.get(holder);
    }
}

