/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.bundled.BundledGroovy;
import org.jetbrains.plugins.groovy.console.GroovyConsoleUtilKt;
import org.jetbrains.plugins.groovy.util.ModuleChooserUtil;

public final class GroovyConsoleUtil {
    @NotNull
    public static String getDisplayGroovyVersion(@NotNull Module module) {
        String sdkVersion = GroovyConsoleUtilKt.sdkVersionIfHasNeededDependenciesToRunConsole(module);
        return sdkVersion == null ? "Bundled Groovy " + BundledGroovy.getBundledGroovyVersion() : "Groovy " + sdkVersion;
    }

    public static void selectModuleAndRun(Project project, Consumer<Module> consumer) {
        ModuleChooserUtil.selectModule(project, GroovyConsoleUtilKt.getApplicableModules(project), (Function<Module, String>)((Function)GroovyConsoleUtil::getDisplayGroovyVersion), consumer);
    }

    @NotNull
    public static String getTitle(@NotNull Module module) {
        return ModuleChooserUtil.formatModuleVersion(module, GroovyConsoleUtil.getDisplayGroovyVersion(module));
    }
}

