/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.libraries.AddCustomLibraryDialog;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.ui.EditorNotificationPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GroovyFrameworkConfigNotification;
import org.jetbrains.plugins.groovy.config.GroovyLibraryDescription;

public class DefaultGroovyFrameworkConfigNotification
extends GroovyFrameworkConfigNotification {
    @Override
    public boolean hasFrameworkStructure(@NotNull Module module) {
        return true;
    }

    @Override
    public boolean hasFrameworkLibrary(@NotNull Module module) {
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass("groovy.lang.GroovyObject", module.getModuleWithDependenciesAndLibrariesScope(true)) != null;
    }

    public EditorNotificationPanel createConfigureNotificationPanel(@NotNull Module module) {
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.setText(GroovyBundle.message("groovy.library.is.not.configured.for.module", module.getName()));
        panel.createActionLabel(GroovyBundle.message("configure.groovy.library", new Object[0]), () -> AddCustomLibraryDialog.createDialog((CustomLibraryDescription)new GroovyLibraryDescription(), (Module)module, null).show());
        return panel;
    }
}

