/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.validity;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;

public class GroovyUnreachableStatementInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Unreachable statement #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitClosure(@NotNull GrClosableBlock closure) {
            super.visitClosure(closure);
            GrStatement[] statements2 = closure.getStatements();
            for (int i = 0; i < statements2.length - 1; ++i) {
                this.checkPair(statements2[i], statements2[i + 1]);
            }
        }

        @Override
        public void visitOpenBlock(@NotNull GrOpenBlock block) {
            super.visitOpenBlock(block);
            GrStatement[] statements2 = block.getStatements();
            for (int i = 0; i < statements2.length - 1; ++i) {
                this.checkPair(statements2[i], statements2[i + 1]);
            }
        }

        private void checkPair(GrStatement prev, GrStatement statement) {
            if (!ControlFlowUtils.statementMayCompleteNormally(prev)) {
                this.registerError(statement);
            }
        }
    }
}

