/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrCastFix;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrChangeVariableType;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyTypeCheckVisitorHelper;
import org.jetbrains.plugins.groovy.codeInspection.type.PrecisionUtil;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.BinaryExpressionHighlighter;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.CallReferenceHighlighter;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.GrConstructorInvocationHighlighter;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.GrEnumConstantHighlighter;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.GrNewExpressionHighlighter;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.LiteralConstructorReferenceHighlighter;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.MethodCallReferenceHighlighter;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentProvider;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentUtilKt;
import org.jetbrains.plugins.groovy.highlighting.HighlightSink;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTuple;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParamsEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyIndexPropertyUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyConstructorReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReference;

public class GroovyTypeCheckVisitor
extends BaseInspectionVisitor {
    private final HighlightSink myHighlightSink = new HighlightSink(){

        @Override
        public void registerProblem(@NotNull PsiElement highlightElement, @NotNull ProblemHighlightType highlightType, @NotNull String message, LocalQuickFix ... fixes) {
            GroovyTypeCheckVisitor.this.registerError(highlightElement, message, fixes, highlightType);
        }
    };

    private boolean checkForImplicitEnumAssigning(@Nullable PsiType expectedType, @NotNull GrExpression expression, @NotNull GroovyPsiElement elementToHighlight) {
        if (!(expectedType instanceof PsiClassType)) {
            return false;
        }
        if (!GroovyConfigUtils.getInstance().isVersionAtLeast(elementToHighlight, "1.8")) {
            return false;
        }
        PsiClass resolved = ((PsiClassType)expectedType).resolve();
        if (resolved == null || !resolved.isEnum()) {
            return false;
        }
        PsiType type2 = expression.getType();
        if (type2 == null) {
            return false;
        }
        if (!type2.equalsToText("groovy.lang.GString") && !type2.equalsToText("java.lang.String")) {
            return false;
        }
        Object result2 = GroovyConstantExpressionEvaluator.evaluate(expression);
        if (!(result2 instanceof String)) {
            this.registerError((PsiElement)elementToHighlight, ProblemHighlightType.WEAK_WARNING, new Object[]{GroovyBundle.message("cannot.assign.string.to.enum.0", expectedType.getPresentableText())});
        } else {
            PsiField field = resolved.findFieldByName((String)result2, true);
            if (!(field instanceof PsiEnumConstant)) {
                this.registerError((PsiElement)elementToHighlight, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new Object[]{GroovyBundle.message("cannot.find.enum.constant.0.in.enum.1", result2, expectedType.getPresentableText())});
            }
        }
        return true;
    }

    @Override
    public void visitMethodCall(@NotNull GrMethodCall call) {
        super.visitMethodCall(call);
        if (PsiUtilKt.isFake(call)) {
            return;
        }
        GrArgumentList argumentList = call.getArgumentList();
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(argumentList)) {
            return;
        }
        GroovyMethodCallReference callReference = call.getCallReference();
        if (callReference == null) {
            return;
        }
        GroovyPsiElement highlightElement = argumentList.getTextLength() == 0 ? call : argumentList;
        MethodCallReferenceHighlighter highlighter = new MethodCallReferenceHighlighter(callReference, highlightElement, this.myHighlightSink);
        if (highlighter.highlightMethodApplicability()) {
            return;
        }
        this.checkNamedArgumentsType(call);
    }

    private void checkNamedArgumentsType(@NotNull GrCall call) {
        GrNamedArgument[] namedArguments = PsiUtil.getFirstMapNamedArguments(call);
        if (namedArguments.length == 0) {
            return;
        }
        Map<String, NamedArgumentDescriptor> map2 = GroovyNamedArgumentProvider.getNamedArgumentsFromAllProviders(call, null, false);
        if (map2 == null) {
            return;
        }
        this.checkNamedArguments(call, namedArguments, map2);
    }

    private void checkNamedArguments(GroovyPsiElement context, GrNamedArgument[] namedArguments, Map<String, NamedArgumentDescriptor> map2) {
        for (GrNamedArgument namedArgument : namedArguments) {
            PsiType expressionType;
            GrExpression namedArgumentExpression;
            String labelName = namedArgument.getLabelName();
            NamedArgumentDescriptor descriptor = map2.get(labelName);
            if (descriptor == null || (namedArgumentExpression = namedArgument.getExpression()) == null || GroovyTypeCheckVisitorHelper.hasTupleInitializer(namedArgumentExpression) || PsiUtil.isRawClassMemberAccess(namedArgumentExpression) || (expressionType = TypesUtil.boxPrimitiveType(namedArgumentExpression.getType(), context.getManager(), context.getResolveScope())) == null || descriptor.checkType(expressionType, context)) continue;
            this.registerError((PsiElement)namedArgumentExpression, ProblemHighlightType.GENERIC_ERROR, new Object[]{"Type of argument '" + labelName + "' can not be '" + expressionType.getPresentableText() + "'"});
        }
    }

    private void processAssignment(@NotNull PsiType expectedType, @NotNull GrExpression expression, @NotNull PsiElement toHighlight, @NotNull PsiElement context) {
        this.checkPossibleLooseOfPrecision(expectedType, expression, toHighlight);
        this.processAssignment(expectedType, expression, toHighlight, "cannot.assign", context, GrTypeConverter.Position.ASSIGNMENT);
    }

    private void processAssignment(@NotNull PsiType expectedType, @NotNull GrExpression expression, @NotNull PsiElement toHighlight, @NotNull @PropertyKey(resourceBundle="messages.GroovyBundle") String messageKey, @NotNull PsiElement context, @NotNull GrTypeConverter.Position position) {
        if (GroovyTypeCheckVisitorHelper.hasTupleInitializer(expression)) {
            return;
        }
        if (PsiUtil.isRawClassMemberAccess(expression)) {
            return;
        }
        if (this.checkForImplicitEnumAssigning(expectedType, expression, expression)) {
            return;
        }
        PsiType actualType = expression.getType();
        if (actualType == null) {
            return;
        }
        ConversionResult result2 = TypesUtil.canAssign(expectedType, actualType, context, position);
        if (result2 == ConversionResult.OK) {
            return;
        }
        ArrayList<GroovyFix> fixes = new ArrayList<GroovyFix>();
        fixes.add(new GrCastFix(expectedType, expression));
        String varName = GroovyTypeCheckVisitorHelper.getLValueVarName(toHighlight);
        if (varName != null) {
            fixes.add(new GrChangeVariableType(actualType, varName));
        }
        String message = GroovyBundle.message(messageKey, actualType.getPresentableText(), expectedType.getPresentableText());
        this.registerError(toHighlight, message, fixes.toArray(LocalQuickFix.EMPTY_ARRAY), result2 == ConversionResult.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    private void processAssignment(@NotNull PsiType lType, @Nullable PsiType rType, @NotNull GroovyPsiElement context, @NotNull PsiElement elementToHighlight) {
        if (rType == null) {
            return;
        }
        ConversionResult result2 = TypesUtil.canAssign(lType, rType, context, GrTypeConverter.Position.ASSIGNMENT);
        this.processResult(result2, elementToHighlight, lType, rType, LocalQuickFix.EMPTY_ARRAY);
    }

    protected void processAssignmentWithinMultipleAssignment(@Nullable PsiType targetType, @Nullable PsiType actualType, @NotNull PsiElement elementToHighlight) {
        if (targetType == null || actualType == null) {
            return;
        }
        ConversionResult result2 = TypesUtil.canAssignWithinMultipleAssignment(targetType, actualType);
        if (result2 == ConversionResult.OK) {
            return;
        }
        this.registerError(elementToHighlight, GroovyBundle.message("cannot.assign", actualType.getPresentableText(), targetType.getPresentableText()), LocalQuickFix.EMPTY_ARRAY, result2 == ConversionResult.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @Override
    public void visitTupleAssignmentExpression(@NotNull GrTupleAssignmentExpression expression) {
        super.visitTupleAssignmentExpression(expression);
        GrExpression initializer = expression.getRValue();
        if (initializer == null) {
            return;
        }
        GrTuple tupleExpression = expression.getLValue();
        GrReferenceExpression[] lValues = tupleExpression.getExpressions();
        if (initializer instanceof GrListOrMap) {
            GrExpression[] initializers = ((GrListOrMap)initializer).getInitializers();
            for (int i = 0; i < lValues.length; ++i) {
                GrReferenceExpression lValue = lValues[i];
                if (initializers.length > i) {
                    GrExpression rValue = initializers[i];
                    this.processAssignmentWithinMultipleAssignment(lValue.getType(), rValue.getType(), rValue);
                    continue;
                }
                break;
            }
        } else {
            PsiType type2 = initializer.getType();
            PsiType rType = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)type2, (boolean)false);
            for (GrReferenceExpression lValue : lValues) {
                PsiType lType = lValue.getNominalType();
                if (PsiImplUtil.isSpreadAssignment(lValue)) {
                    PsiType argType = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)lType, (boolean)false);
                    if (argType != null && rType != null) {
                        this.processAssignment(argType, rType, tupleExpression, GroovyTypeCheckVisitorHelper.getExpressionPartToHighlight(lValue));
                    }
                    return;
                }
                if (lValue instanceof GrReferenceExpression && lValue.resolve() instanceof GrReferenceExpression) {
                    return;
                }
                if (lType == null || rType == null) continue;
                this.processAssignment(lType, rType, tupleExpression, GroovyTypeCheckVisitorHelper.getExpressionPartToHighlight(lValue));
            }
        }
    }

    private void processResult(@NotNull ConversionResult result2, @NotNull PsiElement elementToHighlight, @NotNull PsiType lType, @NotNull PsiType rType, LocalQuickFix @NotNull [] fixes) {
        if (result2 == ConversionResult.OK) {
            return;
        }
        this.registerError(elementToHighlight, GroovyBundle.message("cannot.assign", rType.getPresentableText(), lType.getPresentableText()), fixes, result2 == ConversionResult.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void processReturnValue(@NotNull GrExpression expression, @NotNull PsiElement context, @NotNull PsiElement elementToHighlight) {
        if (GroovyTypeCheckVisitorHelper.hasTupleInitializer(expression)) {
            return;
        }
        PsiType returnType2 = PsiImplUtil.inferReturnType(expression);
        if (returnType2 == null || PsiType.VOID.equals((Object)returnType2)) {
            return;
        }
        this.processAssignment(returnType2, expression, elementToHighlight, "cannot.return.type", context, GrTypeConverter.Position.RETURN_VALUE);
    }

    @Override
    protected void registerError(@NotNull PsiElement location, @NotNull String description, LocalQuickFix @Nullable [] fixes, ProblemHighlightType highlightType) {
        if (PsiUtil.isCompileStatic(location)) {
            if (highlightType != ProblemHighlightType.GENERIC_ERROR) {
                super.registerError(location, description, fixes, highlightType);
            }
        } else if (highlightType == ProblemHighlightType.GENERIC_ERROR) {
            super.registerError(location, description, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        } else {
            super.registerError(location, description, fixes, highlightType);
        }
    }

    @Override
    public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
        GrExpression value = returnStatement.getReturnValue();
        if (value != null) {
            this.processReturnValue(value, returnStatement, returnStatement.getReturnWord());
        }
    }

    @Override
    public void visitThrowStatement(@NotNull GrThrowStatement throwStatement) {
        GrExpression exception = throwStatement.getException();
        if (exception == null) {
            return;
        }
        PsiElement throwWord = throwStatement.getFirstChild();
        this.processAssignment((PsiType)PsiType.getJavaLangThrowable((PsiManager)throwStatement.getManager(), (GlobalSearchScope)throwStatement.getResolveScope()), exception, throwWord, throwWord);
    }

    @Override
    public void visitExpression(@NotNull GrExpression expression) {
        if (ControlFlowUtils.isImplicitReturnStatement(expression)) {
            this.processReturnValue(expression, expression, expression);
        }
    }

    @Override
    public void visitNewExpression(@NotNull GrNewExpression newExpression) {
        super.visitNewExpression(newExpression);
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(newExpression) || GroovyTypeCheckVisitorHelper.hasErrorElements(newExpression.getArgumentList())) {
            return;
        }
        GroovyConstructorReference reference = newExpression.getConstructorReference();
        if (reference == null) {
            return;
        }
        if (new GrNewExpressionHighlighter(newExpression, reference, this.myHighlightSink).highlight()) {
            return;
        }
        this.checkNamedArgumentsType(newExpression);
    }

    @Override
    public void visitEnumConstant(@NotNull GrEnumConstant enumConstant) {
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(enumConstant) || GroovyTypeCheckVisitorHelper.hasErrorElements(enumConstant.getArgumentList())) {
            return;
        }
        if (new GrEnumConstantHighlighter(enumConstant, this.myHighlightSink).highlight()) {
            return;
        }
        this.checkNamedArgumentsType(enumConstant);
    }

    @Override
    public void visitConstructorInvocation(@NotNull GrConstructorInvocation invocation) {
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(invocation) || GroovyTypeCheckVisitorHelper.hasErrorElements(invocation.getArgumentList())) {
            return;
        }
        if (new GrConstructorInvocationHighlighter(invocation, this.myHighlightSink).highlight()) {
            return;
        }
        this.checkNamedArgumentsType(invocation);
    }

    @Override
    public void visitAssignmentExpression(@NotNull GrAssignmentExpression assignment) {
        PsiType targetType;
        super.visitAssignmentExpression(assignment);
        if (assignment.isOperatorAssignment()) {
            return;
        }
        GrExpression lValue = assignment.getLValue();
        if (!PsiUtil.mightBeLValue(lValue)) {
            return;
        }
        GrExpression rValue = assignment.getRValue();
        if (rValue == null) {
            return;
        }
        if (lValue instanceof GrReferenceExpression && ((GrReferenceExpression)lValue).resolve() instanceof GrReferenceExpression) {
            return;
        }
        PsiType lValueNominalType = lValue.getNominalType();
        PsiType psiType = targetType = PsiImplUtil.isSpreadAssignment(lValue) ? com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)lValueNominalType, (boolean)false) : lValueNominalType;
        if (targetType == null) {
            return;
        }
        this.processAssignment(targetType, rValue, (PsiElement)lValue, (PsiElement)assignment);
    }

    void checkPossibleLooseOfPrecision(@NotNull PsiType targetType, @NotNull GrExpression expression, @NotNull PsiElement toHighlight) {
        PsiType actualType = expression.getType();
        if (actualType == null) {
            return;
        }
        if (!PrecisionUtil.isPossibleLooseOfPrecision(targetType, actualType, expression)) {
            return;
        }
        this.registerError(toHighlight, GroovyBundle.message("loss.of.precision", actualType.getPresentableText(), targetType.getPresentableText()), new LocalQuickFix[]{new GrCastFix(targetType, expression, false)}, ProblemHighlightType.GENERIC_ERROR);
    }

    @Override
    public void visitBinaryExpression(@NotNull GrBinaryExpression binary) {
        super.visitBinaryExpression(binary);
        GroovyCallReference reference = binary.getReference();
        if (reference == null) {
            return;
        }
        new BinaryExpressionHighlighter(binary, reference, this.myHighlightSink).highlight();
    }

    @Override
    public void visitCastExpression(@NotNull GrTypeCastExpression expression) {
        super.visitCastExpression(expression);
        GrExpression operand = expression.getOperand();
        if (operand == null) {
            return;
        }
        PsiType actualType = operand.getType();
        if (actualType == null) {
            return;
        }
        if (expression.getCastTypeElement() == null) {
            return;
        }
        PsiType expectedType = expression.getCastTypeElement().getType();
        ConversionResult result2 = TypesUtil.canCast(expectedType, actualType, expression);
        if (result2 == ConversionResult.OK) {
            return;
        }
        ProblemHighlightType highlightType = result2 == ConversionResult.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        String message = GroovyBundle.message("cannot.cast", actualType.getPresentableText(), expectedType.getPresentableText());
        this.registerError((PsiElement)expression, highlightType, new Object[]{message});
    }

    @Override
    public void visitIndexProperty(@NotNull GrIndexProperty expression) {
        GroovyMethodCallReference lValueReference;
        super.visitIndexProperty(expression);
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(expression)) {
            return;
        }
        if (GroovyIndexPropertyUtil.isClassLiteral(expression)) {
            return;
        }
        if (GroovyIndexPropertyUtil.isSimpleArrayAccess(expression)) {
            return;
        }
        GrArgumentList argumentList = expression.getArgumentList();
        GroovyMethodCallReference rValueReference = expression.getRValueReference();
        if (rValueReference != null) {
            new MethodCallReferenceHighlighter(rValueReference, argumentList, this.myHighlightSink).highlightMethodApplicability();
        }
        if ((lValueReference = expression.getLValueReference()) != null) {
            new MethodCallReferenceHighlighter(lValueReference, argumentList, this.myHighlightSink).highlightMethodApplicability();
        }
    }

    @Override
    public void visitMethod(@NotNull GrMethod method) {
        PsiTypeParameter[] parameters2 = method.getTypeParameters();
        HashMap<PsiTypeParameter, PsiWildcardType> map2 = new HashMap<PsiTypeParameter, PsiWildcardType>();
        for (PsiTypeParameter parameter : parameters2) {
            PsiClassType[] types = parameter.getSuperTypes();
            PsiType bound = PsiIntersectionType.createIntersection((PsiType[])types);
            PsiWildcardType wildcardType = PsiWildcardType.createExtends((PsiManager)method.getManager(), (PsiType)bound);
            map2.put(parameter, wildcardType);
        }
        PsiSubstitutor substitutor = PsiSubstitutor.createSubstitutor(map2);
        for (GrParameter parameter : method.getParameterList().getParameters()) {
            GrExpression initializer = parameter.getInitializerGroovy();
            if (initializer == null) continue;
            PsiType targetType = parameter.getType();
            this.processAssignment(substitutor.substitute(targetType), initializer, parameter.getNameIdentifierGroovy(), (PsiElement)parameter);
        }
    }

    @Override
    public void visitParameterList(@NotNull GrParameterList parameterList) {
        PsiElement parent2 = parameterList.getParent();
        if (!(parent2 instanceof GrFunctionalExpression)) {
            return;
        }
        Object[] parameters2 = parameterList.getParameters();
        if (parameters2.length > 0) {
            List<PsiType[]> signatures2 = ClosureParamsEnhancer.findFittingSignatures((GrFunctionalExpression)parent2);
            List paramTypes = ContainerUtil.map((Object[])parameters2, parameter -> parameter.getType());
            if (signatures2.size() > 1) {
                PsiType[] fittingSignature = (PsiType[])ContainerUtil.find(signatures2, types -> {
                    for (int i = 0; i < ((PsiType[])types).length; ++i) {
                        if (TypesUtil.isAssignableByMethodCallConversion((PsiType)paramTypes.get(i), types[i], parameterList)) continue;
                        return false;
                    }
                    return true;
                });
                if (fittingSignature == null) {
                    this.registerError((PsiElement)parameterList, GroovyInspectionBundle.message("no.applicable.signature.found", new Object[0]), null, ProblemHighlightType.GENERIC_ERROR);
                }
            } else if (signatures2.size() == 1) {
                PsiType[] types2 = signatures2.get(0);
                for (int i = 0; i < types2.length; ++i) {
                    GrTypeElement typeElement = parameters2[i].getTypeElementGroovy();
                    if (typeElement == null) continue;
                    PsiType expected = types2[i];
                    PsiType actual = (PsiType)paramTypes.get(i);
                    if (TypesUtil.isAssignableByMethodCallConversion(actual, expected, parameterList)) continue;
                    this.registerError((PsiElement)typeElement, GroovyInspectionBundle.message("expected.type.0", expected.getCanonicalText(false), actual.getCanonicalText(false)), null, ProblemHighlightType.GENERIC_ERROR);
                }
            }
        }
    }

    @Override
    public void visitForInClause(@NotNull GrForInClause forInClause) {
        GrVariable variable = forInClause.getDeclaredVariable();
        GrExpression iterated = forInClause.getIteratedExpression();
        if (variable == null || iterated == null) {
            return;
        }
        PsiType iteratedType = ClosureParameterEnhancer.findTypeForIteration(iterated, (PsiElement)forInClause);
        if (iteratedType == null) {
            return;
        }
        PsiType targetType = variable.getType();
        ConversionResult result2 = TypesUtil.canAssign(targetType, iteratedType, forInClause, GrTypeConverter.Position.ASSIGNMENT);
        LocalQuickFix[] fixes = new LocalQuickFix[]{new GrCastFix((PsiType)TypesUtil.createListType(iterated, targetType), iterated)};
        this.processResult(result2, variable, targetType, iteratedType, fixes);
    }

    @Override
    public void visitVariable(@NotNull GrVariable variable) {
        GrExpression initializer;
        PsiType varType = variable.getType();
        PsiElement parent2 = variable.getParent();
        if (variable instanceof GrParameter && ((GrParameter)variable).getDeclarationScope() instanceof GrMethod || parent2 instanceof GrForInClause) {
            return;
        }
        if (parent2 instanceof GrVariableDeclaration && ((GrVariableDeclaration)parent2).isTuple()) {
            GrVariableDeclaration tuple = (GrVariableDeclaration)parent2;
            GrExpression initializer2 = tuple.getTupleInitializer();
            if (initializer2 == null) {
                return;
            }
            if (!(initializer2 instanceof GrListOrMap) && !PsiUtil.isCompileStatic(variable)) {
                PsiType type2 = initializer2.getType();
                if (type2 == null) {
                    return;
                }
                PsiType valueType = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)type2, (boolean)false);
                this.processAssignment(varType, valueType, tuple, variable.getNameIdentifierGroovy());
                return;
            }
        }
        if ((initializer = variable.getInitializerGroovy()) == null) {
            return;
        }
        this.processAssignment(varType, initializer, variable.getNameIdentifierGroovy(), (PsiElement)variable);
    }

    @Override
    public void visitListOrMap(@NotNull GrListOrMap listOrMap) {
        LiteralConstructorReferenceHighlighter highlighter;
        super.visitListOrMap(listOrMap);
        GroovyConstructorReference constructorReference = listOrMap.getConstructorReference();
        if (constructorReference != null && ((CallReferenceHighlighter)(highlighter = new LiteralConstructorReferenceHighlighter(constructorReference, listOrMap, this.myHighlightSink))).highlightMethodApplicability()) {
            return;
        }
        Map<String, NamedArgumentDescriptor> descriptors = NamedArgumentUtilKt.getDescriptors(listOrMap);
        if (descriptors.isEmpty()) {
            return;
        }
        GrNamedArgument[] namedArguments = listOrMap.getNamedArguments();
        if (namedArguments.length == 0) {
            return;
        }
        this.checkNamedArguments(listOrMap, namedArguments, descriptors);
    }

    @Override
    protected void registerError(@NotNull PsiElement location, ProblemHighlightType highlightType, Object ... args) {
        this.registerError(location, (String)args[0], LocalQuickFix.EMPTY_ARRAY, highlightType);
    }
}

