/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.resources;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PointersKt;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class TypeCustomizerInspection
extends BaseInspection {
    private static final HashSet<String> CUSTOMIZER_EVENT_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"setup", "finish", "unresolvedVariable", "unresolvedProperty", "unresolvedAttribute", "beforeMethodCall", "afterMethodCall", "onMethodSelection", "methodNotFound", "beforeVisitMethod", "afterVisitMethod", "beforeVisitClass", "afterVisitClass", "incompatibleAssignment"});

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitFile(@NotNull GroovyFileBase file) {
                CompilerConfiguration configuration = CompilerConfiguration.getInstance((Project)file.getProject());
                if (configuration != null && !configuration.isResourceFile(file.getVirtualFile()) && TypeCustomizerInspection.fileSeemsToBeTypeCustomizer(file)) {
                    LocalQuickFix[] fixes = new LocalQuickFix[]{new AddToResourceFix(file)};
                    String message = GroovyInspectionBundle.message("type.customizer.is.not.marked.as.a.resource.file", new Object[0]);
                    this.registerError((PsiElement)file, message, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }
        };
    }

    public static boolean fileSeemsToBeTypeCustomizer(@NotNull PsiFile file) {
        if (file instanceof GroovyFile && ((GroovyFile)file).isScript()) {
            for (GrStatement statement : ((GroovyFile)file).getStatements()) {
                GrExpression invoked;
                if (!(statement instanceof GrMethodCall) || !((invoked = ((GrMethodCall)statement).getInvokedExpression()) instanceof GrReferenceExpression) || ((GrReferenceExpression)invoked).isQualified() || !TypeCustomizerInspection.isCustomizerEvent(((GrReferenceExpression)invoked).getReferenceName())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCustomizerEvent(@Nullable String name) {
        return CUSTOMIZER_EVENT_NAMES.contains(name);
    }

    private static class AddToResourceFix
    implements LocalQuickFix {
        @NotNull
        private final SmartPsiElementPointer<PsiFile> myFilePointer;

        AddToResourceFix(@NotNull PsiFile file) {
            this.myFilePointer = PointersKt.createSmartPointer((PsiElement)file);
        }

        @NotNull
        public String getName() {
            return GroovyInspectionBundle.message("add.to.resources", new Object[0]);
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            return GroovyInspectionBundle.message("add.type.customizer.to.resources", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiFile file = (PsiFile)this.myFilePointer.getElement();
            if (file == null) {
                return;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            VirtualFile contentRoot = fileIndex.getContentRootForFile(virtualFile);
            if (contentRoot == null) {
                return;
            }
            VirtualFile sourceRoot = fileIndex.getSourceRootForFile(virtualFile);
            if (sourceRoot == null) {
                String path = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)contentRoot, (char)'/');
                CompilerConfiguration.getInstance((Project)project).addResourceFilePattern(path);
            } else {
                String path = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)sourceRoot, (char)'/');
                String sourceRootPath = VfsUtilCore.getRelativePath((VirtualFile)sourceRoot, (VirtualFile)contentRoot, (char)'/');
                CompilerConfiguration.getInstance((Project)project).addResourceFilePattern(sourceRootPath + ':' + path);
            }
            DaemonCodeAnalyzer.getInstance((Project)project).restart(file);
        }
    }
}

