/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.naming.ConventionInspection;
import org.jetbrains.plugins.groovy.codeInspection.utils.LibraryUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyInstanceMethodNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 4;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @Override
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        return GroovyQuickFixFactory.getInstance().createRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            return "Instance method name '#ref' is too short";
        }
        if (className.length() > this.getMaxLength()) {
            return "Instance method name '#ref' is too long";
        }
        return "Instance method name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
    }

    @Override
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 4;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitMethod(@NotNull GrMethod grMethod) {
            super.visitMethod(grMethod);
            if (grMethod.hasModifierProperty("static") || grMethod.isConstructor()) {
                return;
            }
            String name = grMethod.getName();
            if (GroovyInstanceMethodNamingConventionInspection.this.isValid(name)) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethod(grMethod)) {
                return;
            }
            this.registerMethodError(grMethod, name);
        }
    }
}

