/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control.finalVar;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.VariableDescriptorFactory;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.Semilattice;

public final class VariableInitializationChecker {
    private static boolean isVariableDefinitelyInitialized(@NotNull GrVariable var, Instruction @NotNull [] controlFlow) {
        DFAEngine<Data> engine = new DFAEngine<Data>(controlFlow, new MyDfaInstance(VariableDescriptorFactory.createDescriptor(var)), new MySemilattice());
        List<Data> result2 = engine.performDFAWithTimeout();
        if (result2 == null) {
            return false;
        }
        return (Boolean)result2.get(controlFlow.length - 1).get();
    }

    public static boolean isVariableDefinitelyInitializedCached(@NotNull GrVariable var, @NotNull GroovyPsiElement context, Instruction @NotNull [] controlFlow) {
        Map map2 = (Map)CachedValuesManager.getCachedValue((PsiElement)var, () -> CachedValueProvider.Result.create(new HashMap(), (Object[])new Object[]{var}));
        Boolean cached = (Boolean)map2.get(context);
        if (cached != null) {
            return cached;
        }
        boolean result2 = VariableInitializationChecker.isVariableDefinitelyInitialized(var, controlFlow);
        map2.put(context, result2);
        return result2;
    }

    private static class Data
    extends Ref<Boolean> {
        Data(Boolean value) {
            super((Object)value);
        }
    }

    private static class MySemilattice
    implements Semilattice<Data> {
        private MySemilattice() {
        }

        @Override
        @NotNull
        public Data initial() {
            return new Data(false);
        }

        @Override
        @NotNull
        public Data join(@NotNull List<? extends Data> ins) {
            if (ins.isEmpty()) {
                return new Data(false);
            }
            boolean b = true;
            for (Data data : ins) {
                b &= ((Boolean)data.get()).booleanValue();
            }
            return new Data(b);
        }

        @Override
        public boolean eq(@NotNull Data e1, @NotNull Data e2) {
            return ((Boolean)e1.get()).booleanValue() == ((Boolean)e2.get()).booleanValue();
        }
    }

    private static class MyDfaInstance
    implements DfaInstance<Data> {
        private final VariableDescriptor myVar;

        MyDfaInstance(VariableDescriptor var) {
            this.myVar = var;
        }

        @Override
        public void fun(@NotNull Data e, @NotNull Instruction instruction) {
            if (instruction instanceof ReadWriteVariableInstruction && ((ReadWriteVariableInstruction)instruction).getDescriptor().equals(this.myVar)) {
                e.set(true);
            }
        }
    }
}

