/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control.finalVar;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.VariableDescriptorFactory;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.Semilattice;

public final class InvalidWriteAccessSearcher {
    @Nullable
    public static List<ReadWriteVariableInstruction> findInvalidWriteAccess(Instruction @NotNull [] flow, @NotNull Set<? extends GrVariable> variables, @NotNull Set<? extends GrVariable> alreadyInitialized) {
        DFAEngine<MyData> engine = new DFAEngine<MyData>(flow, new MyDFAInstance(), new MySemilattice());
        List<MyData> dfaResult = engine.performDFAWithTimeout();
        if (dfaResult == null) {
            return null;
        }
        ArrayList<ReadWriteVariableInstruction> result2 = new ArrayList<ReadWriteVariableInstruction>();
        Set descriptors = variables.stream().map(VariableDescriptorFactory::createDescriptor).collect(Collectors.toSet());
        Set initializedDescriptors = alreadyInitialized.stream().map(VariableDescriptorFactory::createDescriptor).collect(Collectors.toSet());
        for (int i = 0; i < flow.length; ++i) {
            Instruction instruction = flow[i];
            if (!(instruction instanceof ReadWriteVariableInstruction) || !((ReadWriteVariableInstruction)instruction).isWrite()) continue;
            MyData initialized = dfaResult.get(i);
            VariableDescriptor descriptor = ((ReadWriteVariableInstruction)instruction).getDescriptor();
            if (!descriptors.contains(descriptor)) continue;
            if (initializedDescriptors.contains(descriptor)) {
                if (!initialized.isInitialized(descriptor)) continue;
                result2.add((ReadWriteVariableInstruction)instruction);
                continue;
            }
            if (!initialized.isOverInitialized(descriptor)) continue;
            result2.add((ReadWriteVariableInstruction)instruction);
        }
        return result2;
    }

    private static class MyData {
        private final Set<VariableDescriptor> myInitialized = new HashSet<VariableDescriptor>();
        private final Set<VariableDescriptor> myOverInitialized = new HashSet<VariableDescriptor>();

        MyData(List<? extends MyData> ins) {
            for (MyData myData : ins) {
                this.myInitialized.addAll(myData.myInitialized);
                this.myOverInitialized.addAll(myData.myOverInitialized);
            }
        }

        MyData() {
        }

        public void add(VariableDescriptor var) {
            if (!this.myInitialized.add(var)) {
                this.myOverInitialized.add(var);
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof MyData && this.myInitialized.equals(((MyData)obj).myInitialized) && this.myOverInitialized.equals(((MyData)obj).myOverInitialized);
        }

        public boolean isOverInitialized(VariableDescriptor var) {
            return this.myOverInitialized.contains(var);
        }

        public boolean isInitialized(VariableDescriptor var) {
            return this.myInitialized.contains(var);
        }
    }

    private static class MySemilattice
    implements Semilattice<MyData> {
        private MySemilattice() {
        }

        @Override
        @NotNull
        public MyData initial() {
            return new MyData();
        }

        @Override
        @NotNull
        public MyData join(@NotNull List<? extends MyData> ins) {
            return new MyData(ins);
        }
    }

    private static class MyDFAInstance
    implements DfaInstance<MyData> {
        private MyDFAInstance() {
        }

        @Override
        public void fun(@NotNull MyData e, @NotNull Instruction instruction) {
            if (instruction instanceof ReadWriteVariableInstruction && ((ReadWriteVariableInstruction)instruction).isWrite()) {
                e.add(((ReadWriteVariableInstruction)instruction).getDescriptor());
            }
        }
    }
}

