/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;

public class GroovyInfiniteLoopStatementInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "<code>#ref</code> statement cannot complete without throwing an exception #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitWhileStatement(@NotNull GrWhileStatement whileStatement) {
            super.visitWhileStatement(whileStatement);
            if (ControlFlowUtils.statementMayCompleteNormally(whileStatement)) {
                return;
            }
            if (ControlFlowUtils.statementContainsReturn(whileStatement)) {
                return;
            }
            this.registerStatementError(whileStatement, new Object[0]);
        }
    }
}

