/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PointersKt;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.bugs.AddMethodFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class AddClassToExtendsFix
extends GroovyFix {
    private final SmartPsiElementPointer<GrTypeDefinition> myPsiClassPointer;
    private final String myInterfaceName;

    public AddClassToExtendsFix(@NotNull GrTypeDefinition psiClass, @NotNull String interfaceName) {
        this.myPsiClassPointer = PointersKt.createSmartPointer((PsiElement)psiClass);
        this.myInterfaceName = interfaceName;
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
        boolean addTypeParam;
        GrTypeDefinition psiClass = (GrTypeDefinition)this.myPsiClassPointer.getElement();
        if (psiClass == null) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        PsiClass comparable = JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Comparable", psiClass.getResolveScope());
        boolean bl = addTypeParam = comparable != null && comparable.getTypeParameters().length == 1;
        if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.lang.Comparable")) {
            GroovyPsiElement anchor;
            GrReferenceList list;
            if (psiClass.isInterface()) {
                list = psiClass.getExtendsClause();
                if (list == null) {
                    list = factory.createExtendsClause();
                    anchor = psiClass.getImplementsClause();
                    if (anchor == null) {
                        anchor = psiClass.getBody();
                    }
                    if (anchor == null) {
                        return;
                    }
                    list = (GrReferenceList)psiClass.addBefore(list, anchor);
                    psiClass.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", anchor.getNode());
                    psiClass.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", list.getNode());
                }
            } else {
                list = psiClass.getImplementsClause();
                if (list == null) {
                    list = factory.createImplementsClause();
                    anchor = psiClass.getBody();
                    if (anchor == null) {
                        return;
                    }
                    list = (GrReferenceList)psiClass.addBefore(list, anchor);
                    psiClass.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", list.getNode());
                    psiClass.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", anchor.getNode());
                }
            }
            GrCodeReferenceElement _ref = factory.createCodeReference(this.myInterfaceName + (addTypeParam ? "<" + AddMethodFix.generateTypeText(psiClass) + ">" : ""));
            GrCodeReferenceElement ref = (GrCodeReferenceElement)list.add(_ref);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)ref);
        }
        if (comparable != null && !psiClass.isInterface()) {
            PsiMethod baseMethod = comparable.getMethods()[0];
            OverrideImplementUtil.overrideOrImplement((PsiClass)psiClass, (PsiMethod)baseMethod);
        }
    }

    @NotNull
    public String getName() {
        return GroovyInspectionBundle.message("implement.class", this.myInterfaceName);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Implement";
    }
}

