/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInsight.CodeInsightWorkspaceSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.local.GroovyPostHighlightingPass;
import org.jetbrains.plugins.groovy.editor.GroovyImportOptimizer;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;

public final class GroovyOptimizeImportsFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(GroovyPostHighlightingPass.class);
    private final boolean onTheFly;

    public GroovyOptimizeImportsFix(boolean onTheFly) {
        this.onTheFly = onTheFly;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        Runnable optimize = new GroovyImportOptimizer().processFile(file);
        GroovyOptimizeImportsFix.invokeOnTheFlyImportOptimizer(optimize, file, editor);
    }

    @NotNull
    public String getText() {
        return GroovyInspectionBundle.message("optimize.all.imports", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return GroovyInspectionBundle.message("optimize.imports", new Object[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return file instanceof GroovyFile && (!this.onTheFly || this.timeToOptimizeImports((GroovyFile)file, editor));
    }

    private boolean timeToOptimizeImports(GroovyFile myFile, Editor editor) {
        DaemonCodeAnalyzerImpl codeAnalyzer;
        GrImportStatement[] imports2;
        VirtualFile vfile;
        if (!CodeInsightWorkspaceSettings.getInstance((Project)myFile.getProject()).isOptimizeImportsOnTheFly()) {
            return false;
        }
        if (this.onTheFly && editor != null && (vfile = myFile.getVirtualFile()) != null && ProjectRootManager.getInstance((Project)myFile.getProject()).getFileIndex().isInSource(vfile) && (imports2 = myFile.getImportStatements()).length > 0) {
            int offset = editor.getCaretModel().getOffset();
            if (imports2[0].getTextRange().getStartOffset() <= offset && offset <= imports2[imports2.length - 1].getTextRange().getEndOffset()) {
                return false;
            }
        }
        if (!(codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)myFile.getProject())).isHighlightingAvailable((PsiFile)myFile)) {
            return false;
        }
        if (!codeAnalyzer.isErrorAnalyzingFinished((PsiFile)myFile)) {
            return false;
        }
        Document myDocument = PsiDocumentManager.getInstance((Project)myFile.getProject()).getDocument((PsiFile)myFile);
        boolean errors = GroovyOptimizeImportsFix.containsErrorsPreventingOptimize(myFile, myDocument);
        return !errors && DaemonListeners.canChangeFileSilently((PsiFileSystemItem)myFile);
    }

    private static boolean containsErrorsPreventingOptimize(GroovyFile myFile, Document myDocument) {
        TextRange ignoreRange;
        GrImportStatement[] imports2 = myFile.getImportStatements();
        if (imports2.length != 0) {
            int start = imports2[0].getTextRange().getStartOffset();
            int end = imports2[imports2.length - 1].getTextRange().getEndOffset();
            ignoreRange = new TextRange(start, end);
        } else {
            ignoreRange = TextRange.EMPTY_RANGE;
        }
        return !DaemonCodeAnalyzerEx.processHighlights((Document)myDocument, (Project)myFile.getProject(), (HighlightSeverity)HighlightSeverity.ERROR, (int)0, (int)myDocument.getTextLength(), error -> {
            int infoEnd;
            int infoStart = error.getActualStartOffset();
            return ignoreRange.containsRange(infoStart, infoEnd = error.getActualEndOffset()) && error.type.equals(HighlightInfoType.WRONG_REF);
        });
    }

    public static void invokeOnTheFlyImportOptimizer(@NotNull Runnable runnable, @NotNull PsiFile file, @NotNull Editor editor) {
        long stamp = editor.getDocument().getModificationStamp();
        Project project = file.getProject();
        ApplicationManager.getApplication().invokeLater(() -> {
            String afterText;
            if (project.isDisposed() || editor.isDisposed() || editor.getDocument().getModificationStamp() != stamp) {
                return;
            }
            if (UndoManager.getInstance((Project)project).isUndoOrRedoInProgress()) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            String beforeText = file.getText();
            long oldStamp = editor.getDocument().getModificationStamp();
            DocumentUtil.writeInRunUndoTransparentAction((Runnable)runnable);
            if (oldStamp != editor.getDocument().getModificationStamp() && Comparing.strEqual((String)beforeText, (String)(afterText = file.getText()))) {
                String path = file.getViewProvider().getVirtualFile().getPath();
                LOG.error("Import optimizer  hasn't optimized any imports", new Attachment[]{new Attachment(path, afterText)});
            }
        });
    }
}

