/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.elements;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.CreateConstructorRequest;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.JvmPsiUtilKt;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.TemplatesKt;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;
import org.jetbrains.plugins.groovy.template.expressions.ParameterNameExpression;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0002R\u0016\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/ConstructorMethodRenderer;", "", "project", "Lcom/intellij/openapi/project/Project;", "targetClass", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "request", "Lcom/intellij/lang/jvm/actions/CreateConstructorRequest;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;Lcom/intellij/lang/jvm/actions/CreateConstructorRequest;)V", "factory", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElementFactory;", "Lorg/jetbrains/annotations/NotNull;", "getFactory", "()Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElementFactory;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRequest", "()Lcom/intellij/lang/jvm/actions/CreateConstructorRequest;", "getTargetClass", "()Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "execute", "", "insertConstructor", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "method", "renderConstructor", "setupTemplate", "intellij.groovy"})
final class ConstructorMethodRenderer {
    @NotNull
    private final GroovyPsiElementFactory factory;
    @NotNull
    private final Project project;
    @NotNull
    private final GrTypeDefinition targetClass;
    @NotNull
    private final CreateConstructorRequest request;

    @NotNull
    public final GroovyPsiElementFactory getFactory() {
        return this.factory;
    }

    public final void execute() {
        GrMethod constructor = this.renderConstructor();
        constructor = this.insertConstructor(constructor);
        GrMethod grMethod = (GrMethod)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)constructor);
        if (grMethod == null) {
            return;
        }
        constructor = grMethod;
        this.setupTemplate(constructor);
    }

    private final void setupTemplate(GrMethod method) {
        List parameters2 = this.request.getExpectedParameters();
        Collection $this$toTypedArray$iv = TemplatesKt.setupParameters(method, parameters2);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ChooseTypeExpression[] chooseTypeExpressionArray = thisCollection$iv.toArray(new ChooseTypeExpression[0]);
        if (chooseTypeExpressionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ChooseTypeExpression[] typeExpressions = chooseTypeExpressionArray;
        Collection $this$toTypedArray$iv2 = TemplatesKt.setupNameExpressions(parameters2, this.project);
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        ParameterNameExpression[] parameterNameExpressionArray = thisCollection$iv2.toArray(new ParameterNameExpression[0]);
        if (parameterNameExpressionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ParameterNameExpression[] nameExpressions = parameterNameExpressionArray;
        IntentionUtils.createTemplateForMethod(typeExpressions, nameExpressions, method, this.targetClass, null, true, null);
    }

    private final GrMethod renderConstructor() {
        GrMethod constructor = this.factory.createConstructor();
        List modifiersToRender = CollectionsKt.toMutableList((Collection)this.request.getModifiers());
        Collection collection = modifiersToRender;
        JvmModifier jvmModifier = JvmModifier.PUBLIC;
        boolean bl = false;
        collection.remove(jvmModifier);
        for (JvmModifier modifier : modifiersToRender) {
            constructor.getModifierList().setModifierProperty(JvmPsiUtilKt.toPsiModifier(modifier), true);
        }
        for (AnnotationRequest annotation : this.request.getAnnotations()) {
            constructor.getModifierList().addAnnotation(annotation.getQualifiedName());
        }
        return constructor;
    }

    private final GrMethod insertConstructor(GrMethod method) {
        PsiElement psiElement = this.targetClass.add(method);
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod");
        }
        return (GrMethod)psiElement;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final GrTypeDefinition getTargetClass() {
        return this.targetClass;
    }

    @NotNull
    public final CreateConstructorRequest getRequest() {
        return this.request;
    }

    public ConstructorMethodRenderer(@NotNull Project project, @NotNull GrTypeDefinition targetClass, @NotNull CreateConstructorRequest request) {
        this.project = project;
        this.targetClass = targetClass;
        this.request = request;
        this.factory = GroovyPsiElementFactory.getInstance(this.project);
    }
}

