/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/ReplaceDotFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "oldDot", "Lcom/intellij/psi/tree/IElementType;", "newDot", "(Lcom/intellij/psi/tree/IElementType;Lcom/intellij/psi/tree/IElementType;)V", "myName", "", "Lorg/jetbrains/annotations/NotNull;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "intellij.groovy.psi"})
public final class ReplaceDotFix
implements LocalQuickFix {
    private final String myName;
    private final IElementType newDot;

    @NotNull
    public String getFamilyName() {
        return this.myName;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement psiElement = descriptor.getPsiElement();
        if (psiElement == null || (psiElement = psiElement.getNode()) == null) {
            return;
        }
        PsiElement oldNode = psiElement;
        LeafElement newNode = ASTFactory.leaf((IElementType)this.newDot, (CharSequence)this.newDot.toString());
        CodeEditUtil.setNodeGenerated((ASTNode)((ASTNode)newNode), (boolean)true);
        oldNode.getTreeParent().replaceChild((ASTNode)oldNode, (ASTNode)newNode);
    }

    public ReplaceDotFix(@NotNull IElementType oldDot, @NotNull IElementType newDot) {
        this.newDot = newDot;
        this.myName = GroovyIntentionsBundle.message("replace.something.with", oldDot, this.newDot);
    }
}

