/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.ConvertLambdaToClosureAction;
import org.jetbrains.plugins.groovy.annotator.intentions.ReplaceDotFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GrArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.GrDoWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.GrExpressionList;
import org.jetbrains.plugins.groovy.lang.psi.api.GrInExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GrTryResourceList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnAmbiguousClosureContainer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010:\u001a\u00020\u00062\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u00062\u0006\u0010>\u001a\u00020?H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotatorPre30;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "checkAmbiguousCodeBlockInDefinition", "", "typeDefinitionBody", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinitionBody;", "error", "typeArgumentList", "Lcom/intellij/psi/PsiElement;", "msg", "", "followsError", "", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "isClosureAmbiguous", "mayBeAnonymousBody", "visitArrayInitializer", "arrayInitializer", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrArrayInitializer;", "visitAssignmentExpression", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrAssignmentExpression;", "visitBinaryExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrBinaryExpression;", "visitBlockStatement", "blockStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrBlockStatement;", "visitClosure", "visitCodeReferenceElement", "refElement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/types/GrCodeReferenceElement;", "visitDoWhileStatement", "statement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrDoWhileStatement;", "visitExpressionList", "expressionList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrExpressionList;", "visitInExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrInExpression;", "visitIndexProperty", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrIndexProperty;", "visitInstanceofExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrInstanceOfExpression;", "visitLambdaExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrLambdaExpression;", "visitModifierList", "modifierList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/GrModifierList;", "visitReferenceExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "visitTryResourceList", "resourceList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrTryResourceList;", "visitTypeDefinitionBody", "visitTypeElement", "typeElement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/types/GrTypeElement;", "visitVariableDeclaration", "variableDeclaration", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariableDeclaration;", "intellij.groovy.psi"})
public final class GroovyAnnotatorPre30
extends GroovyElementVisitor {
    private final AnnotationHolder holder;

    private final void error(PsiElement typeArgumentList, String msg) {
        this.holder.newAnnotation(HighlightSeverity.ERROR, msg).range(typeArgumentList).create();
    }

    @Override
    public void visitModifierList(@NotNull GrModifierList modifierList) {
        PsiElement psiElement = modifierList.getModifier("default");
        if (psiElement == null) {
            return;
        }
        PsiElement modifier = psiElement;
        this.error(modifier, GroovyBundle.message("default.modifier.in.old.versions", new Object[0]));
    }

    @Override
    public void visitDoWhileStatement(@NotNull GrDoWhileStatement statement) {
        super.visitDoWhileStatement(statement);
        this.error(statement.getDoKeyword(), GroovyBundle.message("unsupported.do.while.statement", new Object[0]));
    }

    @Override
    public void visitVariableDeclaration(@NotNull GrVariableDeclaration variableDeclaration) {
        super.visitVariableDeclaration(variableDeclaration);
        if (variableDeclaration.getParent() instanceof GrTraditionalForClause) {
            if (variableDeclaration.isTuple()) {
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.tuple.declaration.in.for", new Object[0])).create();
            } else if (variableDeclaration.getVariables().length > 1) {
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.multiple.variables.in.for", new Object[0])).create();
            }
        }
    }

    @Override
    public void visitExpressionList(@NotNull GrExpressionList expressionList) {
        super.visitExpressionList(expressionList);
        if (expressionList.getExpressions().size() > 1) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.expression.list.in.for.update", new Object[0])).create();
        }
    }

    @Override
    public void visitTryResourceList(@NotNull GrTryResourceList resourceList) {
        super.visitTryResourceList(resourceList);
        this.error(resourceList.getFirstChild(), GroovyBundle.message("unsupported.resource.list", new Object[0]));
    }

    @Override
    public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
        super.visitBinaryExpression(expression);
        PsiElement operator = expression.getOperationToken();
        IElementType tokenType = operator.getNode().getElementType();
        if (tokenType == GroovyElementTypes.T_ID || tokenType == GroovyElementTypes.T_NID) {
            this.error(operator, GroovyBundle.message("operator.is.not.supported.in", tokenType));
        }
    }

    @Override
    public void visitInExpression(@NotNull GrInExpression expression) {
        super.visitInExpression(expression);
        PsiElement negation = expression.getNegationToken();
        if (negation != null) {
            this.error(negation, GroovyBundle.message("unsupported.negated.in", new Object[0]));
        }
    }

    @Override
    public void visitInstanceofExpression(@NotNull GrInstanceOfExpression expression) {
        super.visitInstanceofExpression(expression);
        PsiElement negation = expression.getNegationToken();
        if (negation != null) {
            this.error(negation, GroovyBundle.message("unsupported.negated.instanceof", new Object[0]));
        }
    }

    @Override
    public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
        super.visitAssignmentExpression(expression);
        PsiElement operator = expression.getOperationToken();
        if (operator.getNode().getElementType() == GroovyElementTypes.T_ELVIS_ASSIGN) {
            this.error(operator, GroovyBundle.message("unsupported.elvis.assignment", new Object[0]));
        }
    }

    @Override
    public void visitIndexProperty(@NotNull GrIndexProperty expression) {
        super.visitIndexProperty(expression);
        PsiElement safeAccessToken = expression.getSafeAccessToken();
        if (safeAccessToken != null) {
            this.error(safeAccessToken, GroovyBundle.message("unsupported.safe.index.access", new Object[0]));
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression expression) {
        super.visitReferenceExpression(expression);
        PsiElement psiElement = expression.getDotToken();
        if (psiElement == null) {
            return;
        }
        PsiElement dot = psiElement;
        IElementType tokenType = dot.getNode().getElementType();
        if (tokenType == GroovyElementTypes.T_METHOD_REFERENCE) {
            ReplaceDotFix fix = new ReplaceDotFix(tokenType, GroovyElementTypes.T_METHOD_CLOSURE);
            String message = GroovyBundle.message("operator.is.not.supported.in", tokenType);
            ProblemDescriptor descriptor = InspectionManager.getInstance((Project)expression.getProject()).createProblemDescriptor(dot, dot, message, ProblemHighlightType.ERROR, true, new LocalQuickFix[0]);
            this.holder.newAnnotation(HighlightSeverity.ERROR, message).range(dot).newLocalQuickFix((LocalQuickFix)fix, descriptor).registerFix().create();
        }
    }

    @Override
    public void visitArrayInitializer(@NotNull GrArrayInitializer arrayInitializer) {
        super.visitArrayInitializer(arrayInitializer);
        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.array.initializers", new Object[0])).create();
    }

    @Override
    public void visitLambdaExpression(@NotNull GrLambdaExpression expression) {
        super.visitLambdaExpression(expression);
        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.lambda", new Object[0])).range(expression.getArrow()).withFix((IntentionAction)new ConvertLambdaToClosureAction(expression)).create();
    }

    @Override
    public void visitTypeDefinitionBody(@NotNull GrTypeDefinitionBody typeDefinitionBody) {
        super.visitTypeDefinitionBody(typeDefinitionBody);
        this.checkAmbiguousCodeBlockInDefinition(typeDefinitionBody);
    }

    private final void checkAmbiguousCodeBlockInDefinition(GrTypeDefinitionBody typeDefinitionBody) {
        PsiElement psiElement = typeDefinitionBody.getParent();
        if (!(psiElement instanceof GrAnonymousClassDefinition)) {
            psiElement = null;
        }
        GrAnonymousClassDefinition grAnonymousClassDefinition = (GrAnonymousClassDefinition)psiElement;
        if (grAnonymousClassDefinition == null) {
            return;
        }
        GrAnonymousClassDefinition parent2 = grAnonymousClassDefinition;
        PsiElement prev = typeDefinitionBody.getPrevSibling();
        if (!PsiUtil.isLineFeed(prev)) {
            return;
        }
        PsiElement psiElement2 = parent2.getParent();
        if (!(psiElement2 instanceof GrNewExpression)) {
            psiElement2 = null;
        }
        GrNewExpression grNewExpression = (GrNewExpression)psiElement2;
        if (grNewExpression == null) {
            return;
        }
        GrNewExpression newExpression = grNewExpression;
        GrStatementOwner statementOwner = (GrStatementOwner)PsiTreeUtil.getParentOfType((PsiElement)newExpression, GrStatementOwner.class);
        GrParenthesizedExpression parenthesizedExpression = (GrParenthesizedExpression)PsiTreeUtil.getParentOfType((PsiElement)newExpression, GrParenthesizedExpression.class);
        if (parenthesizedExpression != null && PsiTreeUtil.isAncestor((PsiElement)statementOwner, (PsiElement)parenthesizedExpression, (boolean)true)) {
            return;
        }
        GrArgumentList argumentList = (GrArgumentList)PsiTreeUtil.getParentOfType((PsiElement)newExpression, GrArgumentList.class);
        if (argumentList != null && !(argumentList instanceof GrCommandArgumentList) && PsiTreeUtil.isAncestor((PsiElement)statementOwner, (PsiElement)argumentList, (boolean)true)) {
            return;
        }
        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("ambiguous.code.block", new Object[0])).create();
    }

    @Override
    public void visitBlockStatement(@NotNull GrBlockStatement blockStatement) {
        super.visitBlockStatement(blockStatement);
        if (blockStatement.getParent() instanceof GrStatementOwner) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("ambiguous.code.block", new Object[0])).create();
        }
    }

    @Override
    public void visitClosure(@NotNull GrClosableBlock closure) {
        super.visitClosure(closure);
        if (!closure.hasParametersSection() && !this.followsError(closure) && this.isClosureAmbiguous(closure)) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("ambiguous.code.block", new Object[0])).create();
        }
    }

    private final boolean followsError(GrClosableBlock closure) {
        PsiElement prev = closure.getPrevSibling();
        return prev instanceof PsiErrorElement || prev instanceof PsiWhiteSpace && prev.getPrevSibling() instanceof PsiErrorElement;
    }

    private final boolean isClosureAmbiguous(GrClosableBlock closure) {
        if (this.mayBeAnonymousBody(closure)) {
            return true;
        }
        PsiElement place = closure;
        PsiElement parent2;
        while ((parent2 = place.getParent()) != null && !(parent2 instanceof GrUnAmbiguousClosureContainer)) {
            if (PsiUtil.isExpressionStatement(place)) {
                return true;
            }
            if (parent2.getFirstChild() != place) {
                return false;
            }
            place = parent2;
        }
        return false;
    }

    private final boolean mayBeAnonymousBody(GrClosableBlock closure) {
        PsiElement psiElement = closure.getParent();
        if (!(psiElement instanceof GrMethodCallExpression)) {
            psiElement = null;
        }
        GrMethodCallExpression grMethodCallExpression = (GrMethodCallExpression)psiElement;
        if (grMethodCallExpression == null) {
            return false;
        }
        GrMethodCallExpression parent2 = grMethodCallExpression;
        if (!(parent2.getInvokedExpression() instanceof GrNewExpression)) {
            return false;
        }
        GrClosableBlock[] grClosableBlockArray = parent2.getClosureArguments();
        if (!ArrayUtil.contains((Object)closure, (Object[])Arrays.copyOf(grClosableBlockArray, grClosableBlockArray.length))) {
            return false;
        }
        for (PsiElement run = parent2.getParent(); run != null; run = run.getParent()) {
            if (run instanceof GrParenthesizedExpression) {
                return false;
            }
            if (!(run instanceof GrReturnStatement) && !(run instanceof GrAssertStatement) && !(run instanceof GrThrowStatement) && !(run instanceof GrCommandArgumentList)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitTypeElement(@NotNull GrTypeElement typeElement) {
        GrAnnotation[] $this$forEach$iv = typeElement.getAnnotations();
        boolean $i$f$forEach = false;
        GrAnnotation[] grAnnotationArray = $this$forEach$iv;
        int n = grAnnotationArray.length;
        for (int i = 0; i < n; ++i) {
            GrAnnotation element$iv;
            GrAnnotation it = element$iv = grAnnotationArray[i];
            boolean bl = false;
            this.error(it, GroovyBundle.message("unsupported.type.annotations", new Object[0]));
        }
    }

    @Override
    public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
        GrAnnotation[] $this$forEach$iv = refElement.getAnnotations();
        boolean $i$f$forEach = false;
        GrAnnotation[] grAnnotationArray = $this$forEach$iv;
        int n = grAnnotationArray.length;
        for (int i = 0; i < n; ++i) {
            GrAnnotation element$iv;
            GrAnnotation it = element$iv = grAnnotationArray[i];
            boolean bl = false;
            this.error(it, GroovyBundle.message("unsupported.type.annotations", new Object[0]));
        }
    }

    public GroovyAnnotatorPre30(@NotNull AnnotationHolder holder) {
        this.holder = holder;
    }
}

