/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageOptions;
import com.intellij.coverage.JavaCoverageOptionsProvider;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.IdeBorderFactory;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class JavaCoverageOptions
extends CoverageOptions {
    private final JavaCoverageOptionsProvider myCoverageOptionsProvider;
    private JavaCoverageOptionsEditor myEditor;

    JavaCoverageOptions(@NotNull Project project) {
        this.myCoverageOptionsProvider = JavaCoverageOptionsProvider.getInstance(project);
    }

    public JComponent createComponent() {
        this.myEditor = new JavaCoverageOptionsEditor();
        return this.myEditor.getComponent();
    }

    public boolean isModified() {
        return this.myEditor.isModified(this.myCoverageOptionsProvider);
    }

    public void apply() {
        this.myEditor.apply(this.myCoverageOptionsProvider);
    }

    public void reset() {
        this.myEditor.reset(this.myCoverageOptionsProvider);
    }

    public void disposeUIResources() {
        this.myEditor = null;
    }

    private static class JavaCoverageOptionsEditor {
        private final JPanel myPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        private final JCheckBox myImplicitCheckBox = new JCheckBox(JavaCoverageBundle.message("settings.coverage.java.ignore.implicitly.declared.default.constructors", new Object[0]), true);
        private final JCheckBox myEmptyCheckBox = new JCheckBox(JavaCoverageBundle.message("settings.coverage.java.ignore.empty.private.constructors.of.utility.classes", new Object[0]), true);

        JavaCoverageOptionsEditor() {
            this.myPanel.setBorder(IdeBorderFactory.createTitledBorder((String)JavaCoverageBundle.message("settings.coverage.java.java.coverage", new Object[0])));
            this.myPanel.add(this.myImplicitCheckBox);
            this.myPanel.add(this.myEmptyCheckBox);
        }

        public JPanel getComponent() {
            return this.myPanel;
        }

        public boolean isModified(JavaCoverageOptionsProvider provider) {
            return this.myImplicitCheckBox.isSelected() != provider.ignoreImplicitConstructors() || this.myEmptyCheckBox.isSelected() != provider.ignoreEmptyPrivateConstructors();
        }

        public void apply(JavaCoverageOptionsProvider provider) {
            provider.setIgnoreImplicitConstructors(this.myImplicitCheckBox.isSelected());
            provider.setIgnoreEmptyPrivateConstructors(this.myEmptyCheckBox.isSelected());
        }

        public void reset(JavaCoverageOptionsProvider provider) {
            this.myImplicitCheckBox.setSelected(provider.ignoreImplicitConstructors());
            this.myEmptyCheckBox.setSelected(provider.ignoreEmptyPrivateConstructors());
        }
    }
}

