/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.highlighter.DomSupportEnabled;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.event.PomModelListener;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.ModelMergerImpl;
import com.intellij.util.xml.StableElement;
import com.intellij.util.xml.TypeChooserManager;
import com.intellij.util.xml.events.DomEvent;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomCreator;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.MockDomFileDescription;
import com.intellij.util.xml.impl.StableInvocationHandler;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cglib.proxy.AdvancedProxy;
import net.sf.cglib.proxy.InvocationHandler;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DomManagerImpl
extends DomManager {
    private static final Key<Object> MOCK = Key.create((String)"MockElement");
    static final Key<WeakReference<DomFileElementImpl<?>>> CACHED_FILE_ELEMENT = Key.create((String)"CACHED_FILE_ELEMENT");
    static final Key<DomFileDescription<?>> MOCK_DESCRIPTION = Key.create((String)"MockDescription");
    private static final Key<CachedValue<DomFileElementImpl<?>>> FILE_ELEMENT_KEY = Key.create((String)"DomFileElement");
    private static final Key<CachedValue<DomFileElementImpl<?>>> FILE_ELEMENT_KEY_FOR_INDEX = Key.create((String)"DomFileElementForIndex");
    private static final Key<CachedValue<DomInvocationHandler>> HANDLER_KEY = Key.create((String)"DomInvocationHandler");
    private static final Key<CachedValue<DomInvocationHandler>> HANDLER_KEY_FOR_INDEX = Key.create((String)"DomInvocationHandlerForIndex");
    private final EventDispatcher<DomEventListener> myListeners = EventDispatcher.create(DomEventListener.class);
    private final Project myProject;
    private final DomApplicationComponent myApplicationComponent;
    private boolean myChanging;
    private boolean myBulkChange;

    public DomManagerImpl(Project project) {
        super(project);
        this.myProject = project;
        this.myApplicationComponent = DomApplicationComponent.getInstance();
        final PomModel pomModel = PomManager.getModel((Project)project);
        pomModel.addModelListener(new PomModelListener(){

            public void modelChanged(@NotNull PomModelEvent event) {
                DomFileElementImpl element;
                PsiFile file;
                if (DomManagerImpl.this.myChanging) {
                    return;
                }
                TreeChangeEvent changeSet = (TreeChangeEvent)event.getChangeSet(pomModel.getModelAspect(TreeAspect.class));
                if (changeSet != null && (file = changeSet.getRootElement().getPsi().getContainingFile()) instanceof XmlFile && (element = DomManagerImpl.getCachedFileElement((XmlFile)file)) != null) {
                    DomManagerImpl.this.fireEvent(new DomEvent(element, false));
                }
            }

            public boolean isAspectChangeInteresting(@NotNull PomModelAspect aspect) {
                return aspect instanceof TreeAspect;
            }
        }, (Disposable)project);
        VirtualFileManager.getInstance().addAsyncFileListener(new AsyncFileListener(){

            @Nullable
            public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
                final ArrayList domEvents = new ArrayList();
                for (VFileEvent vFileEvent : events) {
                    if (!this.shouldFireDomEvents(vFileEvent)) continue;
                    ProgressManager.checkCanceled();
                    domEvents.addAll(DomManagerImpl.this.calcDomChangeEvents(vFileEvent.getFile()));
                }
                return domEvents.isEmpty() ? null : new AsyncFileListener.ChangeApplier(){

                    public void afterVfsChange() {
                        DomManagerImpl.this.fireEvents(domEvents);
                    }
                };
            }

            private boolean shouldFireDomEvents(VFileEvent event) {
                if (event instanceof VFileContentChangeEvent) {
                    return !event.isFromSave();
                }
                if (event instanceof VFilePropertyChangeEvent) {
                    return "name".equals(((VFilePropertyChangeEvent)event).getPropertyName()) && !((VFilePropertyChangeEvent)event).getFile().isDirectory();
                }
                return event instanceof VFileMoveEvent || event instanceof VFileDeleteEvent;
            }
        }, (Disposable)this.myProject);
    }

    public long getPsiModificationCount() {
        return PsiManager.getInstance((Project)this.getProject()).getModificationTracker().getModificationCount();
    }

    private List<DomEvent> calcDomChangeEvents(VirtualFile file) {
        if (!(file instanceof NewVirtualFile) || this.myProject.isDisposed()) {
            return Collections.emptyList();
        }
        final FileManager fileManager = PsiManagerEx.getInstanceEx((Project)this.myProject).getFileManager();
        final ArrayList<DomEvent> events = new ArrayList<DomEvent>();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (!file.isDirectory() && FileTypeRegistry.getInstance().isFileOfType(file, (FileType)StdFileTypes.XML)) {
                    DomFileElementImpl domElement;
                    PsiFile psiFile = fileManager.getCachedPsiFile(file);
                    DomFileElementImpl domFileElementImpl = domElement = psiFile instanceof XmlFile ? DomManagerImpl.getCachedFileElement((XmlFile)psiFile) : null;
                    if (domElement != null) {
                        events.add(new DomEvent(domElement, false));
                    }
                }
                return true;
            }

            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
                return ((NewVirtualFile)file).getCachedChildren();
            }
        });
        return events;
    }

    boolean isInsideAtomicChange() {
        return this.myBulkChange;
    }

    public static DomManagerImpl getDomManager(Project project) {
        return (DomManagerImpl)DomManager.getDomManager((Project)project);
    }

    public void addDomEventListener(DomEventListener listener, Disposable parentDisposable) {
        this.myListeners.addListener((EventListener)listener, parentDisposable);
    }

    public final ConverterManager getConverterManager() {
        return (ConverterManager)ServiceManager.getService(ConverterManager.class);
    }

    public final ModelMerger createModelMerger() {
        return new ModelMergerImpl();
    }

    final void fireEvent(@NotNull DomEvent event) {
        if (this.isInsideAtomicChange()) {
            return;
        }
        this.clearCache();
        ((DomEventListener)this.myListeners.getMulticaster()).eventOccured(event);
    }

    private void fireEvents(@NotNull Collection<? extends DomEvent> events) {
        for (DomEvent domEvent : events) {
            this.fireEvent(domEvent);
        }
    }

    public final DomGenericInfo getGenericInfo(Type type) {
        return this.myApplicationComponent.getStaticGenericInfo(type);
    }

    @Nullable
    public static DomInvocationHandler getDomInvocationHandler(DomElement proxy) {
        if (proxy instanceof DomFileElement) {
            return null;
        }
        if (proxy instanceof DomInvocationHandler) {
            return (DomInvocationHandler)proxy;
        }
        InvocationHandler handler = AdvancedProxy.getInvocationHandler((Object)proxy);
        if (handler instanceof StableInvocationHandler) {
            DomElement element = (DomElement)((StableInvocationHandler)handler).getWrappedElement();
            return element == null ? null : DomManagerImpl.getDomInvocationHandler(element);
        }
        if (handler instanceof DomInvocationHandler) {
            return (DomInvocationHandler)handler;
        }
        return null;
    }

    @NotNull
    public static DomInvocationHandler getNotNullHandler(DomElement proxy) {
        DomInvocationHandler handler = DomManagerImpl.getDomInvocationHandler(proxy);
        if (handler == null) {
            throw new AssertionError((Object)("null handler for " + proxy));
        }
        return handler;
    }

    public static StableInvocationHandler<?> getStableInvocationHandler(Object proxy) {
        return (StableInvocationHandler)AdvancedProxy.getInvocationHandler((Object)proxy);
    }

    public DomApplicationComponent getApplicationComponent() {
        return this.myApplicationComponent;
    }

    public final Project getProject() {
        return this.myProject;
    }

    @NotNull
    public final <T extends DomElement> DomFileElementImpl<T> getFileElement(XmlFile file, Class<T> aClass, String rootTagName) {
        if (file.getUserData(MOCK_DESCRIPTION) == null) {
            file.putUserData(MOCK_DESCRIPTION, new MockDomFileDescription<T>(aClass, rootTagName, file.getViewProvider().getVirtualFile()));
            this.clearCache();
        }
        DomFileElement fileElement = this.getFileElement(file);
        assert (fileElement != null);
        return fileElement;
    }

    public final Set<DomFileDescription<?>> getFileDescriptions(String rootTagName) {
        return this.myApplicationComponent.getFileDescriptions(rootTagName);
    }

    public final Set<DomFileDescription<?>> getAcceptingOtherRootTagNameDescriptions() {
        return this.myApplicationComponent.getAcceptingOtherRootTagNameDescriptions();
    }

    @NotNull
    @NonNls
    public final String getComponentName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    final void runChange(Runnable change) {
        boolean b = this.setChanging(true);
        try {
            change.run();
        }
        finally {
            this.setChanging(b);
        }
    }

    final boolean setChanging(boolean changing) {
        boolean oldChanging = this.myChanging;
        if (changing) assert (!oldChanging);
        this.myChanging = changing;
        return oldChanging;
    }

    @Nullable
    public final <T extends DomElement> DomFileElementImpl<T> getFileElement(@Nullable XmlFile file) {
        if (file == null || !(file.getFileType() instanceof DomSupportEnabled)) {
            return null;
        }
        return (DomFileElementImpl)CachedValuesManager.getCachedValue((PsiElement)file, DomManagerImpl.chooseKey(FILE_ELEMENT_KEY, FILE_ELEMENT_KEY_FOR_INDEX), () -> CachedValueProvider.Result.create(DomCreator.createFileElement(file), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this}));
    }

    private static <T> T chooseKey(T base, T forIndex) {
        return FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() != null ? forIndex : base;
    }

    @Nullable
    static <T extends DomElement> DomFileElementImpl<T> getCachedFileElement(@NotNull XmlFile file) {
        return (DomFileElementImpl)SoftReference.dereference((Reference)((Reference)file.getUserData(CACHED_FILE_ELEMENT)));
    }

    @Nullable
    public final <T extends DomElement> DomFileElementImpl<T> getFileElement(XmlFile file, Class<T> domClass) {
        DomFileDescription description = this.getDomFileDescription(file);
        if (description != null && this.myApplicationComponent.assignabilityCache.isAssignable(domClass, description.getRootElementClass())) {
            return this.getFileElement(file);
        }
        return null;
    }

    @Nullable
    public final DomElement getDomElement(XmlTag element) {
        if (this.myChanging) {
            return null;
        }
        DomInvocationHandler handler = this.getDomHandler((XmlElement)element);
        return handler != null ? handler.getProxy() : null;
    }

    @Nullable
    public GenericAttributeValue<?> getDomElement(XmlAttribute attribute) {
        if (this.myChanging) {
            return null;
        }
        DomInvocationHandler handler = this.getDomHandler((XmlElement)attribute);
        return handler == null ? null : (GenericAttributeValue)handler.getProxy();
    }

    @Nullable
    public DomInvocationHandler getDomHandler(@Nullable XmlElement xml) {
        if (xml instanceof XmlTag) {
            return (DomInvocationHandler)((Object)CachedValuesManager.getCachedValue((PsiElement)xml, DomManagerImpl.chooseKey(HANDLER_KEY, HANDLER_KEY_FOR_INDEX), () -> {
                DomInvocationHandler handler = DomCreator.createTagHandler((XmlTag)xml);
                if (handler != null && handler.getXmlTag() != xml) {
                    throw new AssertionError((Object)("Inconsistent dom, stub=" + (Object)((Object)handler.getStub())));
                }
                return CachedValueProvider.Result.create((Object)((Object)handler), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this});
            }));
        }
        if (xml instanceof XmlAttribute) {
            return (DomInvocationHandler)((Object)CachedValuesManager.getCachedValue((PsiElement)xml, DomManagerImpl.chooseKey(HANDLER_KEY, HANDLER_KEY_FOR_INDEX), () -> CachedValueProvider.Result.create((Object)((Object)DomCreator.createAttributeHandler((XmlAttribute)xml)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this})));
        }
        return null;
    }

    @Nullable
    public AbstractDomChildrenDescription findChildrenDescription(@NotNull XmlTag tag, @NotNull DomElement parent) {
        DomInvocationHandler parentHandler = DomManagerImpl.getDomInvocationHandler(parent);
        assert (parentHandler != null);
        return parentHandler.getGenericInfo().findChildrenDescription(parentHandler, tag);
    }

    public final boolean isDomFile(@Nullable PsiFile file) {
        return file instanceof XmlFile && this.getFileElement((XmlFile)file) != null;
    }

    @Nullable
    public final DomFileDescription<?> getDomFileDescription(PsiElement element) {
        PsiFile psiFile;
        if (element instanceof XmlElement && (psiFile = element.getContainingFile()) instanceof XmlFile) {
            return this.getDomFileDescription((XmlFile)psiFile);
        }
        return null;
    }

    public final <T extends DomElement> T createMockElement(Class<T> aClass, Module module, boolean physical) {
        XmlFile file = (XmlFile)PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("a.xml", (FileType)StdFileTypes.XML, (CharSequence)"", 0L, physical);
        file.putUserData(MOCK_ELEMENT_MODULE, (Object)module);
        file.putUserData(MOCK, new Object());
        return this.getFileElement(file, (Class)aClass, "I_sincerely_hope_that_nobody_will_have_such_a_root_tag_name").getRootElement();
    }

    public final boolean isMockElement(DomElement element) {
        return DomUtil.getFile((DomElement)element).getUserData(MOCK) != null;
    }

    public final <T extends DomElement> T createStableValue(Factory<? extends T> provider) {
        return (T)((DomElement)this.createStableValue(provider, t -> t.isValid()));
    }

    public final <T> T createStableValue(Factory<? extends T> provider, Condition<? super T> validator) {
        Object initial = provider.create();
        assert (initial != null);
        StableInvocationHandler<? super T> handler = new StableInvocationHandler<T>(initial, provider, validator);
        HashSet<Class<StableElement>> intf = new HashSet<Class<StableElement>>();
        ContainerUtil.addAll(intf, (Object[])initial.getClass().getInterfaces());
        intf.add(StableElement.class);
        return (T)AdvancedProxy.createProxy(initial.getClass().getSuperclass(), (Class[])intf.toArray(ArrayUtil.EMPTY_CLASS_ARRAY), handler, (Object[])new Object[0]);
    }

    public final <T extends DomElement> void registerFileDescription(DomFileDescription<T> description, Disposable parentDisposable) {
        this.registerFileDescription(description);
        Disposer.register((Disposable)parentDisposable, () -> this.myApplicationComponent.removeDescription(description));
    }

    public final void registerFileDescription(DomFileDescription<?> description) {
        this.clearCache();
        this.myApplicationComponent.registerFileDescription(description);
    }

    @NotNull
    public final DomElement getResolvingScope(GenericDomValue<?> element) {
        DomFileDescription description = DomUtil.getFileElement(element).getFileDescription();
        return description.getResolveScope(element);
    }

    @NotNull
    public final DomElement getIdentityScope(DomElement element) {
        DomFileDescription description = DomUtil.getFileElement((DomElement)element).getFileDescription();
        return description.getIdentityScope(element);
    }

    public TypeChooserManager getTypeChooserManager() {
        return this.myApplicationComponent.getTypeChooserManager();
    }

    void performAtomicChange(@NotNull Runnable change) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        boolean oldValue = this.myBulkChange;
        this.myBulkChange = true;
        try {
            change.run();
        }
        finally {
            this.myBulkChange = oldValue;
            if (!oldValue) {
                this.clearCache();
            }
        }
        if (!this.isInsideAtomicChange()) {
            this.clearCache();
        }
    }

    private void clearCache() {
        this.incModificationCount();
    }
}

