/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.semantic.SemElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.ElementPresentation;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.EvaluatedXmlNameImpl;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomRootInvocationHandler;
import com.intellij.util.xml.impl.RootDomParentStrategy;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import com.intellij.util.xml.stubs.FileStub;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomFileElementImpl<T extends DomElement>
implements DomFileElement<T>,
SemElement {
    private static final DomGenericInfo EMPTY_DOM_GENERIC_INFO = new DomGenericInfo(){

        @Nullable
        public GenericDomValue getNameDomElement(DomElement element) {
            return null;
        }

        @NotNull
        public List<? extends CustomDomChildrenDescription> getCustomNameChildrenDescription() {
            return Collections.emptyList();
        }

        @Nullable
        public String getElementName(DomElement element) {
            return null;
        }

        @NotNull
        public List<DomChildrenDescription> getChildrenDescriptions() {
            return Collections.emptyList();
        }

        @NotNull
        public List<DomFixedChildDescription> getFixedChildrenDescriptions() {
            return Collections.emptyList();
        }

        @NotNull
        public List<DomCollectionChildDescription> getCollectionChildrenDescriptions() {
            return Collections.emptyList();
        }

        @NotNull
        public List<DomAttributeChildDescription<?>> getAttributeChildrenDescriptions() {
            return Collections.emptyList();
        }

        public boolean isTagValueElement() {
            return false;
        }

        @Nullable
        public DomFixedChildDescription getFixedChildDescription(String tagName) {
            return null;
        }

        @Nullable
        public DomFixedChildDescription getFixedChildDescription(@NonNls String tagName, @NonNls String namespace) {
            return null;
        }

        @Nullable
        public DomCollectionChildDescription getCollectionChildDescription(String tagName) {
            return null;
        }

        @Nullable
        public DomCollectionChildDescription getCollectionChildDescription(@NonNls String tagName, @NonNls String namespace) {
            return null;
        }

        public DomAttributeChildDescription getAttributeChildDescription(String attributeName) {
            return null;
        }

        @Nullable
        public DomAttributeChildDescription getAttributeChildDescription(@NonNls String attributeName, @NonNls String namespace) {
            return null;
        }
    };
    private final XmlFile myFile;
    private final DomFileDescription<T> myFileDescription;
    private final DomRootInvocationHandler myRootHandler;
    private final Class<T> myRootElementClass;
    private final EvaluatedXmlNameImpl myRootTagName;
    private final DomManagerImpl myManager;
    private final Map<Key, Object> myUserData = new HashMap<Key, Object>();

    protected DomFileElementImpl(XmlFile file, EvaluatedXmlNameImpl rootTagName, DomFileDescription<T> fileDescription, FileStub stub) {
        this.myFile = file;
        this.myRootElementClass = fileDescription.getRootElementClass();
        this.myRootTagName = rootTagName;
        this.myManager = DomManagerImpl.getDomManager(file.getProject());
        this.myFileDescription = fileDescription;
        this.myRootHandler = new DomRootInvocationHandler(this.myRootElementClass, new RootDomParentStrategy(this), this, (EvaluatedXmlName)rootTagName, stub == null ? null : stub.getRootTagStub());
    }

    @NotNull
    public final XmlFile getFile() {
        return this.myFile;
    }

    @NotNull
    public XmlFile getOriginalFile() {
        return (XmlFile)this.myFile.getOriginalFile();
    }

    @Nullable
    public XmlTag getRootTag() {
        XmlTag tag;
        if (!this.myFile.isValid()) {
            return null;
        }
        XmlDocument document = this.myFile.getDocument();
        if (document != null && (tag = document.getRootTag()) != null) {
            if (tag.getTextLength() > 0 && this.getFileDescription().acceptsOtherRootTagNames()) {
                return tag;
            }
            if (this.myRootTagName.getXmlName().getLocalName().equals(tag.getLocalName()) && this.myRootTagName.isNamespaceAllowed((DomFileElement)this, tag.getNamespace())) {
                return tag;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DomFileElementImpl)) {
            return false;
        }
        DomFileElementImpl that = (DomFileElementImpl)o;
        if (this.myFile != null ? !this.myFile.equals(that.myFile) : that.myFile != null) {
            return false;
        }
        if (this.myRootElementClass != null ? !this.myRootElementClass.equals(that.myRootElementClass) : that.myRootElementClass != null) {
            return false;
        }
        return !(this.myRootTagName != null ? !this.myRootTagName.equals((Object)that.myRootTagName) : that.myRootTagName != null);
    }

    public int hashCode() {
        int result = this.myFile != null ? this.myFile.hashCode() : 0;
        result = 31 * result + (this.myRootElementClass != null ? this.myRootElementClass.hashCode() : 0);
        result = 31 * result + (this.myRootTagName != null ? this.myRootTagName.hashCode() : 0);
        return result;
    }

    @NotNull
    public final DomManagerImpl getManager() {
        return this.myManager;
    }

    public final Type getDomElementType() {
        return this.getClass();
    }

    @NotNull
    public AbstractDomChildrenDescription getChildDescription() {
        throw new UnsupportedOperationException("Method getChildDescription is not yet implemented in " + this.getClass().getName());
    }

    public DomNameStrategy getNameStrategy() {
        return this.getRootHandler().getNameStrategy();
    }

    @NotNull
    public ElementPresentation getPresentation() {
        return new ElementPresentation(){

            @NonNls
            public String getElementName() {
                return "<ROOT>";
            }

            @NonNls
            public String getTypeName() {
                return "<ROOT>";
            }

            public Icon getIcon() {
                return null;
            }
        };
    }

    public GlobalSearchScope getResolveScope() {
        return this.myFile.getResolveScope();
    }

    @Nullable
    public <T extends DomElement> T getParentOfType(Class<T> requiredClass, boolean strict) {
        return (T)(DomFileElement.class.isAssignableFrom(requiredClass) && !strict ? this : null);
    }

    public Module getModule() {
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getFile());
    }

    public void copyFrom(DomElement other) {
        throw new UnsupportedOperationException("Method copyFrom is not yet implemented in " + this.getClass().getName());
    }

    public final <T extends DomElement> T createMockCopy(boolean physical) {
        throw new UnsupportedOperationException("Method createMockCopy is not yet implemented in " + this.getClass().getName());
    }

    public final <T extends DomElement> T createStableCopy() {
        PsiManager psiManager = this.myFile.getManager();
        VirtualFile vFile = this.myFile.getViewProvider().getVirtualFile();
        return this.myManager.createStableValue(() -> this.myManager.getFileElement((XmlFile)ObjectUtils.tryCast((Object)psiManager.findFile(vFile), XmlFile.class)));
    }

    @NotNull
    public String getXmlElementNamespace() {
        return "";
    }

    @NonNls
    @Nullable
    public String getXmlElementNamespaceKey() {
        return null;
    }

    @NotNull
    public final T getRootElement() {
        if (!this.isValid()) {
            PsiUtilCore.ensureValid((PsiElement)this.myFile);
            throw new AssertionError((Object)(this + " is not equal to " + this.myManager.getFileElement(this.myFile)));
        }
        return (T)this.getRootHandler().getProxy();
    }

    @NotNull
    public Class<T> getRootElementClass() {
        return this.myRootElementClass;
    }

    @NotNull
    public DomFileDescription<T> getFileDescription() {
        return this.myFileDescription;
    }

    @NotNull
    protected final DomRootInvocationHandler getRootHandler() {
        return this.myRootHandler;
    }

    @NonNls
    public String toString() {
        return "File " + this.myFile.toString();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return null;
    }

    public final XmlTag getXmlTag() {
        return null;
    }

    @NotNull
    public <T extends DomElement> DomFileElementImpl<T> getRoot() {
        return this;
    }

    @Nullable
    public DomElement getParent() {
        return null;
    }

    public final XmlTag ensureTagExists() {
        return null;
    }

    public final XmlElement getXmlElement() {
        return this.getFile();
    }

    public final XmlElement ensureXmlElementExists() {
        return this.ensureTagExists();
    }

    public void undefine() {
    }

    public final boolean isValid() {
        return this.checkValidity() == null;
    }

    public boolean exists() {
        return true;
    }

    @Nullable
    public String checkValidity() {
        if (!this.myFile.isValid()) {
            return "Invalid file";
        }
        DomFileElement fileElement = this.myManager.getFileElement(this.myFile);
        if (!this.equals(fileElement)) {
            return "file element changed: " + fileElement + "; fileType=" + this.myFile.getFileType();
        }
        return null;
    }

    @NotNull
    public final DomGenericInfo getGenericInfo() {
        return EMPTY_DOM_GENERIC_INFO;
    }

    @NotNull
    public String getXmlElementName() {
        return "";
    }

    public void accept(DomElementVisitor visitor) {
        this.myManager.getApplicationComponent().getVisitorDescription(visitor.getClass()).acceptElement(visitor, (DomElement)this);
    }

    public void acceptChildren(DomElementVisitor visitor) {
        this.getRootElement().accept(visitor);
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myUserData.get(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
        this.myUserData.put(key, value);
    }

    public final long getModificationCount() {
        return this.myFile.getModificationStamp();
    }
}

