/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.action.connect;

import com.google.api.client.repackaged.org.mortbay.jetty.Request;
import com.google.api.client.repackaged.org.mortbay.jetty.handler.AbstractHandler;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.action.connect.ConnectProjectPayload;
import com.google.services.firebase.config.AndroidConfigManager;
import com.google.services.firebase.config.AndroidConfigManagerImpl;
import com.google.services.firebase.consolereceiver.callback.CancellableReceiverHandlerFactory;
import com.google.services.firebase.consolereceiver.callback.ReceiverCallback;
import com.google.services.firebase.consolereceiver.validator.RequestValidator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectProjectCallbackHandler
extends AbstractHandler {
    private static final Logger LOGGER = Logger.getInstance(ConnectProjectCallbackHandler.class);
    public static final ImmutableList<RequestValidator> REQUEST_VALIDATORS = ImmutableList.of();
    private final Module androidModule;
    private final ReceiverCallback callback;
    private final AndroidConfigManager androidConfigManager;
    private final Gson gson = new Gson();

    ConnectProjectCallbackHandler(ReceiverCallback callback, Module androidModule) {
        this(callback, androidModule, new AndroidConfigManagerImpl());
    }

    ConnectProjectCallbackHandler(ReceiverCallback callback, Module androidModule, AndroidConfigManager androidConfigManager) {
        this.callback = callback;
        this.androidModule = androidModule;
        this.androidConfigManager = androidConfigManager;
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        if (request instanceof Request) {
            ((Request)request).setHandled(true);
        }
        if (!this.isValid(request)) {
            this.fail(response, "Received an invalid request.", null);
            return;
        }
        ConnectProjectPayload payload = this.getRequestPayload(request);
        if (payload == null || !payload.isValid()) {
            this.fail(response, "BAD REQUEST: Invalid payload", null);
            return;
        }
        LOGGER.info("Got non-empty request from the Console, writing file and signaling.");
        try {
            this.androidConfigManager.writeAndroidConfig(payload.getServicesJson(), this.androidModule);
        }
        catch (IOException e) {
            this.fail(response, FirebaseBundle.message("firebaseConnectAction.userError.couldNotWriteConfig", new Object[0]), e);
            return;
        }
        this.replyWithSuccess(request, response);
        this.callback.onSuccess(FirebaseBundle.message("firebase.service.notification.connect.process.complete", payload.getPackageName(), payload.getProjectId()));
    }

    private void fail(HttpServletResponse response, String errorMessage, Throwable exception) throws IOException {
        LOGGER.info(errorMessage);
        response.setStatus(400);
        this.respondWithResource("/console_connect_error.html", response);
        response.flushBuffer();
        this.callback.onFailure(errorMessage, exception);
    }

    private void replyWithSuccess(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setStatus(200);
        this.respondWithResource("/console_connect_success.html", response);
        response.flushBuffer();
    }

    private void respondWithResource(String resourceName, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        InputStream inputStream = ConnectProjectCallbackHandler.class.getResourceAsStream(resourceName);
        ServletOutputStream outputStream = response.getOutputStream();
        ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
        outputStream.flush();
    }

    private boolean isValid(HttpServletRequest request) {
        return REQUEST_VALIDATORS.stream().allMatch(validator -> validator.isValid(request));
    }

    @Nullable
    private ConnectProjectPayload getRequestPayload(HttpServletRequest request) throws IOException {
        return ConnectProjectPayload.newBuilder().setUserEmail(request.getParameter("userEmail")).setProjectNumber(request.getParameter("projectNumber")).setProjectId(request.getParameter("projectId")).setPackageName(request.getParameter("packageName")).setBase64ServicesJson(request.getParameter("servicesJson")).build();
    }

    public static CancellableReceiverHandlerFactory getFactory(@NotNull Module androidModule) {
        return callback -> new ConnectProjectCallbackHandler(callback, androidModule);
    }
}

