/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy;

import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoCache;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineDebugProbesProxyKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineInfoProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineLibraryAgent2Proxy;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineNoLibraryProxy;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.DefaultExecutionContext;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineDebugProbesProxy;", "", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "(Lcom/intellij/debugger/engine/SuspendContextImpl;)V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "getSuspendContext", "()Lcom/intellij/debugger/engine/SuspendContextImpl;", "dumpCoroutines", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoCache;", "findProvider", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineInfoProvider;", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/DefaultExecutionContext;", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineDebugProbesProxy {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final ReadOnlyProperty log$delegate;
    @NotNull
    private final SuspendContextImpl suspendContext;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(CoroutineDebugProbesProxy.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0))};
    }

    private final Logger getLog() {
        return (Logger)this.log$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @NotNull
    public final synchronized CoroutineInfoCache dumpCoroutines() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        CoroutineInfoCache coroutineInfoCache = new CoroutineInfoCache(null, null, 3, null);
        try {
            DefaultExecutionContext defaultExecutionContext = CoroutineUtilsKt.executionContext(this.suspendContext);
            if (defaultExecutionContext == null) {
                return coroutineInfoCache.fail();
            }
            DefaultExecutionContext executionContext2 = defaultExecutionContext;
            CoroutineInfoProvider coroutineInfoProvider = this.findProvider(executionContext2);
            if (coroutineInfoProvider == null) {
                return coroutineInfoCache.ok();
            }
            CoroutineInfoProvider libraryAgentProxy = coroutineInfoProvider;
            List<CoroutineInfoData> infoList = libraryAgentProxy.dumpCoroutinesInfo();
            coroutineInfoCache.ok(infoList);
        }
        catch (Throwable e) {
            this.getLog().error("Exception is thrown by calling dumpCoroutines.", e);
            coroutineInfoCache.fail();
        }
        return coroutineInfoCache;
    }

    private final CoroutineInfoProvider findProvider(DefaultExecutionContext executionContext2) {
        CoroutineLibraryAgent2Proxy agentProxy = CoroutineLibraryAgent2Proxy.Companion.instance(executionContext2);
        if (agentProxy != null) {
            return agentProxy;
        }
        if (CoroutineDebugProbesProxyKt.standaloneCoroutineDebuggerEnabled()) {
            return new CoroutineNoLibraryProxy(executionContext2);
        }
        return null;
    }

    @NotNull
    public final SuspendContextImpl getSuspendContext() {
        return this.suspendContext;
    }

    public CoroutineDebugProbesProxy(@NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        this.suspendContext = suspendContext;
        this.log$delegate = ProvidersKt.getLogger();
    }
}

